/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody.internal.web;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import net.bull.javamelody.internal.web.FilterServletResponseWrapper;
import net.bull.javamelody.internal.web.HtmlInjectorResponseStream;

class HtmlInjectorServletResponseWrapper
extends FilterServletResponseWrapper {
    private static final String INJECTOR_WRAPPED_REQUEST_KEY = "javamelody.injectorWrapped";
    private final HtmlInjectorResponseStream.HtmlToInject htmlToInject;

    HtmlInjectorServletResponseWrapper(HttpServletRequest request, HttpServletResponse response, HtmlInjectorResponseStream.HtmlToInject htmlToInject) {
        super(response);
        assert (request != null);
        assert (response != null);
        assert (htmlToInject != null);
        this.htmlToInject = htmlToInject;
        request.setAttribute(INJECTOR_WRAPPED_REQUEST_KEY, (Object)Boolean.TRUE);
    }

    static boolean acceptsRequest(HttpServletRequest request) {
        String accept = request.getHeader("accept");
        return accept != null && accept.contains("text/html") && request.getAttribute(INJECTOR_WRAPPED_REQUEST_KEY) == null;
    }

    @Override
    public ServletOutputStream createOutputStream() throws IOException {
        if (!this.isContentTypeHtml()) {
            return this.getHttpServletResponse().getOutputStream();
        }
        return new HtmlInjectorResponseStream(this.getHttpServletResponse(), this.htmlToInject);
    }

    public void setContentType(String contentType) {
        super.setContentType(contentType);
        if (!this.isContentTypeHtml() && this.getStream() instanceof HtmlInjectorResponseStream) {
            ((HtmlInjectorResponseStream)this.getStream()).cancelInjection();
        }
    }

    private boolean isContentTypeHtml() {
        String contentType = this.getContentType();
        return contentType == null || contentType.contains("text/html");
    }

    public void setContentLength(int length) {
    }

    public void setContentLengthLong(long length) {
    }

    public void addHeader(String name, String value) {
        if (!"Content-Length".equalsIgnoreCase(name)) {
            super.addHeader(name, value);
        }
    }

    public void addIntHeader(String name, int value) {
        if (!"Content-Length".equalsIgnoreCase(name)) {
            super.addIntHeader(name, value);
        }
    }

    public void setHeader(String name, String value) {
        if (!"Content-Length".equalsIgnoreCase(name)) {
            super.setHeader(name, value);
        }
    }

    public void setIntHeader(String name, int value) {
        if (!"Content-Length".equalsIgnoreCase(name)) {
            super.setIntHeader(name, value);
        }
    }
}

