/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody.internal.web.pdf;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.PdfPCell;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.bull.javamelody.internal.common.I18N;
import net.bull.javamelody.internal.model.SamplingProfiler;
import net.bull.javamelody.internal.web.pdf.PdfAbstractTableReport;

class PdfHotspotsReport
extends PdfAbstractTableReport {
    private final List<SamplingProfiler.SampledMethod> hotspots;
    private final long totalCount;
    private final DecimalFormat percentFormat = I18N.createPercentFormat();

    PdfHotspotsReport(List<SamplingProfiler.SampledMethod> hotspots, Document document) {
        super(document);
        assert (hotspots != null);
        this.hotspots = hotspots;
        long total = 0L;
        for (SamplingProfiler.SampledMethod hotspot : hotspots) {
            total += hotspot.getCount();
        }
        this.totalCount = total;
    }

    @Override
    void toPdf() throws DocumentException {
        this.writeHeader();
        this.writeHotspots();
    }

    private void writeHotspots() throws DocumentException {
        for (SamplingProfiler.SampledMethod hotspot : this.hotspots) {
            this.nextRow();
            this.writeHotspot(hotspot);
        }
        this.addTableToDocument();
    }

    private void writeHeader() throws DocumentException {
        List<String> headers = this.createHeaders();
        int[] relativeWidths = new int[headers.size()];
        Arrays.fill(relativeWidths, 0, headers.size(), 1);
        relativeWidths[0] = 12;
        this.initTable(headers, relativeWidths);
    }

    private List<String> createHeaders() {
        ArrayList<String> headers = new ArrayList<String>();
        headers.add(PdfHotspotsReport.getString("Methode_executee"));
        headers.add(PdfHotspotsReport.getString("percent_time"));
        return headers;
    }

    private void writeHotspot(SamplingProfiler.SampledMethod hotspot) {
        PdfPCell defaultCell = this.getDefaultCell();
        defaultCell.setHorizontalAlignment(0);
        this.addCell(hotspot.getClassName() + "." + hotspot.getMethodName());
        defaultCell.setHorizontalAlignment(2);
        double percent = 100.0 * (double)hotspot.getCount() / (double)this.totalCount;
        this.addCell(this.percentFormat.format(percent));
    }
}

