/*
 * Decompiled with CFR 0.152.
 */
package net.corda.client.rpc.internal;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.corda.core.internal.NamedCacheFactory;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J@\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u00060\u0004\"\u0004\b\u0000\u0010\u0005\"\u0004\b\u0001\u0010\u00062\u0016\u0010\u0007\u001a\u0012\u0012\u0006\b\u0000\u0012\u0002H\u0005\u0012\u0006\b\u0000\u0012\u0002H\u00060\b2\u0006\u0010\t\u001a\u00020\nH\u0016JT\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u00060\u000b\"\u0004\b\u0000\u0010\u0005\"\u0004\b\u0001\u0010\u00062\u0016\u0010\u0007\u001a\u0012\u0012\u0006\b\u0000\u0012\u0002H\u0005\u0012\u0006\b\u0000\u0012\u0002H\u00060\b2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u00060\rH\u0016\u00a8\u0006\u000e"}, d2={"Lnet/corda/client/rpc/internal/ClientCacheFactory;", "Lnet/corda/core/internal/NamedCacheFactory;", "()V", "buildNamed", "Lcom/github/benmanes/caffeine/cache/Cache;", "K", "V", "caffeine", "Lcom/github/benmanes/caffeine/cache/Caffeine;", "name", "", "Lcom/github/benmanes/caffeine/cache/LoadingCache;", "loader", "Lcom/github/benmanes/caffeine/cache/CacheLoader;", "rpc"})
public final class ClientCacheFactory
implements NamedCacheFactory {
    @NotNull
    public <K, V> Cache<K, V> buildNamed(@NotNull Caffeine<? super K, ? super V> caffeine, @NotNull String name) {
        Intrinsics.checkParameterIsNotNull(caffeine, (String)"caffeine");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        this.checkCacheName(name);
        Cache cache = caffeine.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)cache, (String)"caffeine.build<K, V>()");
        return cache;
    }

    @NotNull
    public <K, V> LoadingCache<K, V> buildNamed(@NotNull Caffeine<? super K, ? super V> caffeine, @NotNull String name, @NotNull CacheLoader<K, V> loader) {
        Intrinsics.checkParameterIsNotNull(caffeine, (String)"caffeine");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull(loader, (String)"loader");
        this.checkCacheName(name);
        LoadingCache loadingCache = caffeine.build(loader);
        Intrinsics.checkExpressionValueIsNotNull((Object)loadingCache, (String)"caffeine.build<K, V>(loader)");
        return loadingCache;
    }

    public void checkCacheName(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        NamedCacheFactory.DefaultImpls.checkCacheName((NamedCacheFactory)this, (String)name);
    }
}

