/*
 * Decompiled with CFR 0.152.
 */
package net.corda.client.rpc.internal;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.corda.client.rpc.CordaRPCClientConfiguration;
import net.corda.client.rpc.RPCConnection;
import net.corda.client.rpc.UnrecoverableRPCException;
import net.corda.client.rpc.ext.RPCConnectionListener;
import net.corda.client.rpc.internal.DistributionMux;
import net.corda.client.rpc.internal.RPCClient;
import net.corda.client.rpc.internal.RPCClientProxyHandler;
import net.corda.core.context.Actor;
import net.corda.core.context.Trace;
import net.corda.core.identity.CordaX500Name;
import net.corda.core.internal.InternalUtils;
import net.corda.core.messaging.ClientRpcSslOptions;
import net.corda.core.messaging.RPCOps;
import net.corda.core.serialization.SerializationContext;
import net.corda.core.serialization.SerializationDefaults;
import net.corda.core.serialization.internal.SerializationEnvironmentKt;
import net.corda.core.utilities.KotlinUtilsKt;
import net.corda.core.utilities.NetworkHostAndPort;
import net.corda.nodeapi.internal.ArtemisTcpTransport;
import net.corda.nodeapi.internal.RoundRobinConnectionPolicy;
import net.corda.nodeapi.internal.config.SslConfiguration;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 +*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0001+B/\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fB+\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\r\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u000eB5\b\u0016\u0012\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0010\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u0011B1\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\b\b\u0002\u0010\u0014\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\u000e\b\u0002\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00130\u0010\u00a2\u0006\u0002\u0010\u0016J\u0014\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\u0019J\u0014\u0010\u001d\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\u0019JN\u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00000\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00028\u00000!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#2\n\b\u0002\u0010%\u001a\u0004\u0018\u00010&2\n\b\u0002\u0010'\u001a\u0004\u0018\u00010(2\n\b\u0002\u0010)\u001a\u0004\u0018\u00010*R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00130\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00190\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lnet/corda/client/rpc/internal/RPCClient;", "I", "Lnet/corda/core/messaging/RPCOps;", "", "hostAndPort", "Lnet/corda/core/utilities/NetworkHostAndPort;", "sslConfiguration", "Lnet/corda/core/messaging/ClientRpcSslOptions;", "configuration", "Lnet/corda/client/rpc/CordaRPCClientConfiguration;", "serializationContext", "Lnet/corda/core/serialization/SerializationContext;", "(Lnet/corda/core/utilities/NetworkHostAndPort;Lnet/corda/core/messaging/ClientRpcSslOptions;Lnet/corda/client/rpc/CordaRPCClientConfiguration;Lnet/corda/core/serialization/SerializationContext;)V", "Lnet/corda/nodeapi/internal/config/SslConfiguration;", "(Lnet/corda/core/utilities/NetworkHostAndPort;Lnet/corda/nodeapi/internal/config/SslConfiguration;Lnet/corda/client/rpc/CordaRPCClientConfiguration;Lnet/corda/core/serialization/SerializationContext;)V", "haAddressPool", "", "(Ljava/util/List;Lnet/corda/core/messaging/ClientRpcSslOptions;Lnet/corda/client/rpc/CordaRPCClientConfiguration;Lnet/corda/core/serialization/SerializationContext;)V", "transport", "Lorg/apache/activemq/artemis/api/core/TransportConfiguration;", "rpcConfiguration", "haPoolTransportConfigurations", "(Lorg/apache/activemq/artemis/api/core/TransportConfiguration;Lnet/corda/client/rpc/CordaRPCClientConfiguration;Lnet/corda/core/serialization/SerializationContext;Ljava/util/List;)V", "listeners", "", "Lnet/corda/client/rpc/ext/RPCConnectionListener;", "addConnectionListener", "", "listener", "removeConnectionListener", "start", "Lnet/corda/client/rpc/RPCConnection;", "rpcOpsClass", "Ljava/lang/Class;", "username", "", "password", "externalTrace", "Lnet/corda/core/context/Trace;", "impersonatedActor", "Lnet/corda/core/context/Actor;", "targetLegalIdentity", "Lnet/corda/core/identity/CordaX500Name;", "Companion", "rpc"})
public final class RPCClient<I extends RPCOps> {
    private final Set<RPCConnectionListener<I>> listeners;
    private final TransportConfiguration transport;
    private final CordaRPCClientConfiguration rpcConfiguration;
    private final SerializationContext serializationContext;
    private final List<TransportConfiguration> haPoolTransportConfigurations;
    private static final Logger log;
    public static final Companion Companion;

    @NotNull
    public final RPCConnection<I> start(@NotNull Class<I> rpcOpsClass, @NotNull String username, @NotNull String password, @Nullable Trace externalTrace, @Nullable Actor impersonatedActor, @Nullable CordaX500Name targetLegalIdentity) {
        Intrinsics.checkParameterIsNotNull(rpcOpsClass, (String)"rpcOpsClass");
        Intrinsics.checkParameterIsNotNull((Object)username, (String)"username");
        Intrinsics.checkParameterIsNotNull((Object)password, (String)"password");
        return (RPCConnection)InternalUtils.logElapsedTime((Logger)log, (String)"Startup", (Function0)((Function0)new Function0<start.connection.1>(this, username, password, rpcOpsClass, externalTrace, impersonatedActor, targetLegalIdentity){
            final /* synthetic */ RPCClient this$0;
            final /* synthetic */ String $username;
            final /* synthetic */ String $password;
            final /* synthetic */ Class $rpcOpsClass;
            final /* synthetic */ Trace $externalTrace;
            final /* synthetic */ Actor $impersonatedActor;
            final /* synthetic */ CordaX500Name $targetLegalIdentity;

            @NotNull
            public final start.connection.1 invoke() {
                RPCConnection<I> rPCConnection;
                Collection $receiver$iv;
                ServerLocator serverLocator;
                if (RPCClient.access$getHaPoolTransportConfigurations$p(this.this$0).isEmpty()) {
                    serverLocator = ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{RPCClient.access$getTransport$p(this.this$0)});
                } else {
                    Collection collection = $receiver$iv = (Collection)RPCClient.access$getHaPoolTransportConfigurations$p(this.this$0);
                    if (collection == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
                    }
                    Collection thisCollection$iv = collection;
                    TransportConfiguration[] transportConfigurationArray = thisCollection$iv.toArray(new TransportConfiguration[0]);
                    if (transportConfigurationArray == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                    }
                    serverLocator = ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])Arrays.copyOf(transportConfigurationArray, transportConfigurationArray.length));
                }
                Collection $receiver = $receiver$iv = serverLocator;
                $receiver.setConnectionTTL(60000L);
                $receiver.setClientFailureCheckPeriod(30000L);
                $receiver.setRetryInterval(RPCClient.access$getRpcConfiguration$p(this.this$0).getConnectionRetryInterval().toMillis());
                $receiver.setRetryIntervalMultiplier(RPCClient.access$getRpcConfiguration$p(this.this$0).getConnectionRetryIntervalMultiplier());
                $receiver.setMaxRetryInterval(RPCClient.access$getRpcConfiguration$p(this.this$0).getConnectionMaxRetryInterval().toMillis());
                $receiver.setReconnectAttempts(RPCClient.access$getHaPoolTransportConfigurations$p(this.this$0).isEmpty() ? RPCClient.access$getRpcConfiguration$p(this.this$0).getMaxReconnectAttempts() : 0);
                $receiver.setMinLargeMessageSize(RPCClient.access$getRpcConfiguration$p(this.this$0).getMaxFileSize());
                $receiver.setUseGlobalPools(SerializationEnvironmentKt.getNodeSerializationEnv() != null);
                $receiver.setConnectionLoadBalancingPolicyClassName(RoundRobinConnectionPolicy.class.getCanonicalName());
                Collection serverLocator2 = $receiver$iv;
                Trace.SessionId sessionId = Trace.SessionId.Companion.newInstance$default((Trace.SessionId.Companion)Trace.SessionId.Companion, null, null, (int)3, null);
                DistributionMux<I> distributionMux = new DistributionMux<I>(RPCClient.access$getListeners$p(this.this$0), this.$username);
                CordaRPCClientConfiguration cordaRPCClientConfiguration = RPCClient.access$getRpcConfiguration$p(this.this$0);
                Collection collection = serverLocator2;
                Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"serverLocator");
                RPCClientProxyHandler proxyHandler = new RPCClientProxyHandler(cordaRPCClientConfiguration, this.$username, this.$password, (ServerLocator)collection, this.$rpcOpsClass, RPCClient.access$getSerializationContext$p(this.this$0), sessionId, this.$externalTrace, this.$impersonatedActor, this.$targetLegalIdentity, distributionMux, null, 2048, null);
                try {
                    proxyHandler.start();
                    RPCOps ops = (RPCOps)InternalUtils.uncheckedCast((Object)Proxy.newProxyInstance(this.$rpcOpsClass.getClassLoader(), new Class[]{this.$rpcOpsClass}, (InvocationHandler)proxyHandler));
                    int serverProtocolVersion = ops.getProtocolVersion();
                    if (serverProtocolVersion < RPCClient.access$getRpcConfiguration$p(this.this$0).getMinimumServerProtocolVersion()) {
                        throw (Throwable)((Object)new UnrecoverableRPCException("Requested minimum protocol version " + '(' + RPCClient.access$getRpcConfiguration$p(this.this$0).getMinimumServerProtocolVersion() + ") is higher" + " than the server's supported protocol version (" + serverProtocolVersion + ')', null, 2, null));
                    }
                    proxyHandler.setServerProtocolVersion$rpc(serverProtocolVersion);
                    RPCClient.access$getLog$cp().debug("RPC connected, returning proxy");
                    RPCConnection<I> connection2 = new RPCConnection<I>(proxyHandler, (ServerLocator)serverLocator2, ops, serverProtocolVersion){
                        @NotNull
                        private final I proxy;
                        private final int serverProtocolVersion;
                        final /* synthetic */ RPCClientProxyHandler $proxyHandler;
                        final /* synthetic */ ServerLocator $serverLocator;
                        final /* synthetic */ RPCOps $ops;
                        final /* synthetic */ int $serverProtocolVersion;

                        @NotNull
                        public I getProxy() {
                            return this.proxy;
                        }

                        public int getServerProtocolVersion() {
                            return this.serverProtocolVersion;
                        }

                        private final void close(boolean notify) {
                            if (notify) {
                                this.$proxyHandler.notifyServerAndClose();
                            } else {
                                this.$proxyHandler.forceClose();
                            }
                            this.$serverLocator.close();
                        }

                        public void notifyServerAndClose() {
                            this.close(true);
                        }

                        public void forceClose() {
                            this.close(false);
                        }
                        {
                            this.$proxyHandler = $captured_local_variable$0;
                            this.$serverLocator = $captured_local_variable$1;
                            this.$ops = $captured_local_variable$2;
                            this.$serverProtocolVersion = $captured_local_variable$3;
                            this.proxy = $captured_local_variable$2;
                            this.serverProtocolVersion = $captured_local_variable$3;
                        }

                        public void close() {
                            RPCConnection.DefaultImpls.close(this);
                        }
                    };
                    distributionMux.setConnectionOpt$rpc(connection2);
                    distributionMux.onConnect$rpc();
                    rPCConnection = connection2;
                }
                catch (Throwable throwable) {
                    proxyHandler.notifyServerAndClose();
                    serverLocator2.close();
                    distributionMux.onPermanentFailure$rpc(throwable);
                    throw throwable;
                }
                return rPCConnection;
            }
            {
                this.this$0 = rPCClient;
                this.$username = string;
                this.$password = string2;
                this.$rpcOpsClass = clazz;
                this.$externalTrace = trace;
                this.$impersonatedActor = actor;
                this.$targetLegalIdentity = cordaX500Name;
                super(0);
            }
        }));
    }

    @NotNull
    public static /* bridge */ /* synthetic */ RPCConnection start$default(RPCClient rPCClient, Class clazz, String string, String string2, Trace trace, Actor actor, CordaX500Name cordaX500Name, int n, Object object) {
        if ((n & 8) != 0) {
            trace = null;
        }
        if ((n & 0x10) != 0) {
            actor = null;
        }
        if ((n & 0x20) != 0) {
            cordaX500Name = null;
        }
        return rPCClient.start(clazz, string, string2, trace, actor, cordaX500Name);
    }

    public final boolean addConnectionListener(@NotNull RPCConnectionListener<I> listener) {
        Intrinsics.checkParameterIsNotNull(listener, (String)"listener");
        return this.listeners.add(listener);
    }

    public final boolean removeConnectionListener(@NotNull RPCConnectionListener<I> listener) {
        Intrinsics.checkParameterIsNotNull(listener, (String)"listener");
        return this.listeners.remove(listener);
    }

    public RPCClient(@NotNull TransportConfiguration transport, @NotNull CordaRPCClientConfiguration rpcConfiguration, @NotNull SerializationContext serializationContext, @NotNull List<? extends TransportConfiguration> haPoolTransportConfigurations) {
        Intrinsics.checkParameterIsNotNull((Object)transport, (String)"transport");
        Intrinsics.checkParameterIsNotNull((Object)rpcConfiguration, (String)"rpcConfiguration");
        Intrinsics.checkParameterIsNotNull((Object)serializationContext, (String)"serializationContext");
        Intrinsics.checkParameterIsNotNull(haPoolTransportConfigurations, (String)"haPoolTransportConfigurations");
        this.transport = transport;
        this.rpcConfiguration = rpcConfiguration;
        this.serializationContext = serializationContext;
        this.haPoolTransportConfigurations = haPoolTransportConfigurations;
        this.listeners = new CopyOnWriteArraySet();
    }

    public /* synthetic */ RPCClient(TransportConfiguration transportConfiguration, CordaRPCClientConfiguration cordaRPCClientConfiguration, SerializationContext serializationContext, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            cordaRPCClientConfiguration = CordaRPCClientConfiguration.DEFAULT;
        }
        if ((n & 4) != 0) {
            serializationContext = SerializationDefaults.INSTANCE.getRPC_CLIENT_CONTEXT();
        }
        if ((n & 8) != 0) {
            list = CollectionsKt.emptyList();
        }
        this(transportConfiguration, cordaRPCClientConfiguration, serializationContext, list);
    }

    public RPCClient(@NotNull NetworkHostAndPort hostAndPort, @Nullable ClientRpcSslOptions sslConfiguration, @NotNull CordaRPCClientConfiguration configuration, @NotNull SerializationContext serializationContext) {
        Intrinsics.checkParameterIsNotNull((Object)hostAndPort, (String)"hostAndPort");
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        Intrinsics.checkParameterIsNotNull((Object)serializationContext, (String)"serializationContext");
        this(ArtemisTcpTransport.Companion.rpcConnectorTcpTransport$default((ArtemisTcpTransport.Companion)ArtemisTcpTransport.Companion, (NetworkHostAndPort)hostAndPort, (ClientRpcSslOptions)sslConfiguration, (boolean)false, (int)4, null), configuration, serializationContext, null, 8, null);
    }

    public /* synthetic */ RPCClient(NetworkHostAndPort networkHostAndPort, ClientRpcSslOptions clientRpcSslOptions, CordaRPCClientConfiguration cordaRPCClientConfiguration, SerializationContext serializationContext, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            clientRpcSslOptions = null;
        }
        if ((n & 4) != 0) {
            cordaRPCClientConfiguration = CordaRPCClientConfiguration.DEFAULT;
        }
        if ((n & 8) != 0) {
            serializationContext = SerializationDefaults.INSTANCE.getRPC_CLIENT_CONTEXT();
        }
        this(networkHostAndPort, clientRpcSslOptions, cordaRPCClientConfiguration, serializationContext);
    }

    public RPCClient(@NotNull NetworkHostAndPort hostAndPort, @NotNull SslConfiguration sslConfiguration, @NotNull CordaRPCClientConfiguration configuration, @NotNull SerializationContext serializationContext) {
        Intrinsics.checkParameterIsNotNull((Object)hostAndPort, (String)"hostAndPort");
        Intrinsics.checkParameterIsNotNull((Object)sslConfiguration, (String)"sslConfiguration");
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        Intrinsics.checkParameterIsNotNull((Object)serializationContext, (String)"serializationContext");
        this(ArtemisTcpTransport.Companion.rpcInternalClientTcpTransport$default((ArtemisTcpTransport.Companion)ArtemisTcpTransport.Companion, (NetworkHostAndPort)hostAndPort, (SslConfiguration)sslConfiguration, null, (int)4, null), configuration, serializationContext, null, 8, null);
    }

    public /* synthetic */ RPCClient(NetworkHostAndPort networkHostAndPort, SslConfiguration sslConfiguration, CordaRPCClientConfiguration cordaRPCClientConfiguration, SerializationContext serializationContext, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            cordaRPCClientConfiguration = CordaRPCClientConfiguration.DEFAULT;
        }
        if ((n & 8) != 0) {
            serializationContext = SerializationDefaults.INSTANCE.getRPC_CLIENT_CONTEXT();
        }
        this(networkHostAndPort, sslConfiguration, cordaRPCClientConfiguration, serializationContext);
    }

    public RPCClient(@NotNull List<NetworkHostAndPort> haAddressPool, @Nullable ClientRpcSslOptions sslConfiguration, @NotNull CordaRPCClientConfiguration configuration, @NotNull SerializationContext serializationContext) {
        Intrinsics.checkParameterIsNotNull(haAddressPool, (String)"haAddressPool");
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        Intrinsics.checkParameterIsNotNull((Object)serializationContext, (String)"serializationContext");
        this(ArtemisTcpTransport.Companion.rpcConnectorTcpTransport$default((ArtemisTcpTransport.Companion)ArtemisTcpTransport.Companion, (NetworkHostAndPort)((NetworkHostAndPort)CollectionsKt.first(haAddressPool)), (ClientRpcSslOptions)sslConfiguration, (boolean)false, (int)4, null), configuration, serializationContext, ArtemisTcpTransport.Companion.rpcConnectorTcpTransportsFromList$default((ArtemisTcpTransport.Companion)ArtemisTcpTransport.Companion, haAddressPool, (ClientRpcSslOptions)sslConfiguration, (boolean)false, (int)4, null));
    }

    public /* synthetic */ RPCClient(List list, ClientRpcSslOptions clientRpcSslOptions, CordaRPCClientConfiguration cordaRPCClientConfiguration, SerializationContext serializationContext, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            clientRpcSslOptions = null;
        }
        if ((n & 4) != 0) {
            cordaRPCClientConfiguration = CordaRPCClientConfiguration.DEFAULT;
        }
        if ((n & 8) != 0) {
            serializationContext = SerializationDefaults.INSTANCE.getRPC_CLIENT_CONTEXT();
        }
        this(list, clientRpcSslOptions, cordaRPCClientConfiguration, serializationContext);
    }

    static {
        Companion = new Companion(null);
        log = KotlinUtilsKt.contextLogger((Object)Companion);
    }

    @NotNull
    public static final /* synthetic */ List access$getHaPoolTransportConfigurations$p(RPCClient $this) {
        return $this.haPoolTransportConfigurations;
    }

    @NotNull
    public static final /* synthetic */ TransportConfiguration access$getTransport$p(RPCClient $this) {
        return $this.transport;
    }

    @NotNull
    public static final /* synthetic */ CordaRPCClientConfiguration access$getRpcConfiguration$p(RPCClient $this) {
        return $this.rpcConfiguration;
    }

    @NotNull
    public static final /* synthetic */ Set access$getListeners$p(RPCClient $this) {
        return $this.listeners;
    }

    @NotNull
    public static final /* synthetic */ SerializationContext access$getSerializationContext$p(RPCClient $this) {
        return $this.serializationContext;
    }

    @NotNull
    public static final /* synthetic */ Logger access$getLog$cp() {
        return log;
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lnet/corda/client/rpc/internal/RPCClient$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "rpc"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

