/*
 * Decompiled with CFR 0.152.
 */
package net.corda.client.rpc.internal;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.RemovalCause;
import com.github.benmanes.caffeine.cache.RemovalListener;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KFunction;
import kotlin.reflect.jvm.ReflectJvmMapping;
import net.corda.client.rpc.ConnectionFailureException;
import net.corda.client.rpc.CordaRPCClientConfiguration;
import net.corda.client.rpc.RPCException;
import net.corda.client.rpc.RPCSinceVersion;
import net.corda.client.rpc.internal.ClientCacheFactory;
import net.corda.client.rpc.internal.DistributionMux;
import net.corda.client.rpc.internal.RPCClientProxyHandler;
import net.corda.client.rpc.internal.RPCClientProxyHandler$FailoverHandler$WhenMappings;
import net.corda.client.rpc.internal.RPCClientProxyHandlerKt$sam$java_lang_Runnable$0;
import net.corda.client.rpc.internal.RPCClientProxyHandlerKt$sam$org_apache_activemq_artemis_api_core_client_MessageHandler$0;
import net.corda.client.rpc.internal.RPCUtils;
import net.corda.core.context.Actor;
import net.corda.core.context.Trace;
import net.corda.core.crypto.CryptoUtils;
import net.corda.core.identity.CordaX500Name;
import net.corda.core.internal.InternalUtils;
import net.corda.core.internal.LazyStickyPool;
import net.corda.core.internal.LifeCycle;
import net.corda.core.internal.NamedCacheFactory;
import net.corda.core.internal.ThreadBox;
import net.corda.core.messaging.CordaRPCOps;
import net.corda.core.messaging.RPCOps;
import net.corda.core.serialization.SerializationAPIKt;
import net.corda.core.serialization.SerializationContext;
import net.corda.core.serialization.SerializedBytes;
import net.corda.core.utilities.KotlinUtilsKt;
import net.corda.core.utilities.OpaqueBytes;
import net.corda.core.utilities.Try;
import net.corda.nodeapi.RPCApi;
import net.corda.nodeapi.internal.DeduplicationChecker;
import net.corda.nodeapi.internal.rpc.client.CallSite;
import net.corda.nodeapi.internal.rpc.client.ObservableContext;
import net.corda.nodeapi.internal.rpc.client.RpcClientObservableDeSerializer;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQNotConnectedException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.FailoverEventListener;
import org.apache.activemq.artemis.api.core.client.FailoverEventType;
import org.apache.activemq.artemis.api.core.client.MessageHandler;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import rx.Notification;
import rx.exceptions.OnErrorNotImplementedException;
import rx.subjects.UnicastSubject;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u00b9\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n*\u00014\b\u0000\u0018\u0000 y2\u00020\u0001:\u0003yz{B}\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u000e\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u0012\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u0012\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015\u0012\u000e\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\u0017\u0012\b\b\u0002\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\u0002\u0010\u001aJ\u0010\u0010Q\u001a\u00020R2\u0006\u0010S\u001a\u00020TH\u0002J\b\u0010U\u001a\u00020RH\u0002J\u0010\u0010V\u001a\u00020R2\u0006\u0010W\u001a\u00020XH\u0002J\b\u0010Y\u001a\u00020RH\u0002J\u0012\u0010Z\u001a\u00020R2\b\b\u0002\u0010[\u001a\u00020\\H\u0002J\"\u0010]\u001a\u001c\u0012\u0004\u0012\u00020\u001d\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030`0_0^j\u0002`aH\u0002J\u0013\u0010b\u001a\u00020\\2\b\u0010c\u001a\u0004\u0018\u00010FH\u0096\u0002J\u0006\u0010d\u001a\u00020RJ\b\u0010e\u001a\u00020MH\u0016J\b\u0010f\u001a\u00020RH\u0002J4\u0010g\u001a\u0004\u0018\u00010F2\u0006\u0010h\u001a\u00020F2\u0006\u0010i\u001a\u00020X2\u0012\u0010j\u001a\u000e\u0012\b\b\u0001\u0012\u0004\u0018\u00010F\u0018\u00010kH\u0096\u0002\u00a2\u0006\u0002\u0010lJ\u0006\u0010m\u001a\u00020RJ\u0010\u0010n\u001a\u00020\u00052\u0006\u0010i\u001a\u00020XH\u0002J\u0012\u0010o\u001a\u00020R2\b\b\u0002\u0010[\u001a\u00020\\H\u0002J\b\u0010p\u001a\u00020RH\u0002J\u0010\u0010q\u001a\u00020R2\u0006\u0010S\u001a\u00020rH\u0002J\u0015\u0010s\u001a\u00020R2\u0006\u0010t\u001a\u00020MH\u0000\u00a2\u0006\u0002\buJ\u0006\u0010v\u001a\u00020RJ\b\u0010w\u001a\u00020RH\u0002J\b\u0010x\u001a\u00020\u0005H\u0016R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u001b\u001a\u0018\u0012\u0004\u0012\u00020\u001d\u0012\u0006\u0012\u0004\u0018\u00010\u001e\u0018\u00010\u001cj\u0004\u0018\u0001`\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010 \u001a\u0004\u0018\u00010!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\"\u001a\u0004\u0018\u00010#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010+\u001a\u0004\u0018\u00010,X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010-\u001a\b\u0012\u0004\u0012\u00020/0.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u000201X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00102\u001a\b\u0012\u0004\u0012\u00020403X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u00105\u001a\u0010\u0012\f\u0012\n 8*\u0004\u0018\u0001070706X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u00109\u001a\n 8*\u0004\u0018\u00010:0:X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010;\u001a\u0004\u0018\u00010#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010<\u001a\u0004\u0018\u00010=X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010>\u001a\b\u0012\u0002\b\u0003\u0018\u00010?X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010@\u001a\u0004\u0018\u00010AX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010B\u001a\u0004\u0018\u00010CX\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010D\u001a\u001a\u0012\u0004\u0012\u00020\u001d\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010F0E0\u001cj\u0002`GX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010H\u001a\u0004\u0018\u000107X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010I\u001a\u00020JX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010K\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010L\u001a\u0004\u0018\u00010MX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010NR\u0010\u0010O\u001a\u0004\u0018\u00010PX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006|"}, d2={"Lnet/corda/client/rpc/internal/RPCClientProxyHandler;", "Ljava/lang/reflect/InvocationHandler;", "rpcConfiguration", "Lnet/corda/client/rpc/CordaRPCClientConfiguration;", "rpcUsername", "", "rpcPassword", "serverLocator", "Lorg/apache/activemq/artemis/api/core/client/ServerLocator;", "rpcOpsClass", "Ljava/lang/Class;", "Lnet/corda/core/messaging/RPCOps;", "serializationContext", "Lnet/corda/core/serialization/SerializationContext;", "sessionId", "Lnet/corda/core/context/Trace$SessionId;", "externalTrace", "Lnet/corda/core/context/Trace;", "impersonatedActor", "Lnet/corda/core/context/Actor;", "targetLegalIdentity", "Lnet/corda/core/identity/CordaX500Name;", "notificationDistributionMux", "Lnet/corda/client/rpc/internal/DistributionMux;", "cacheFactory", "Lnet/corda/core/internal/NamedCacheFactory;", "(Lnet/corda/client/rpc/CordaRPCClientConfiguration;Ljava/lang/String;Ljava/lang/String;Lorg/apache/activemq/artemis/api/core/client/ServerLocator;Ljava/lang/Class;Lnet/corda/core/serialization/SerializationContext;Lnet/corda/core/context/Trace$SessionId;Lnet/corda/core/context/Trace;Lnet/corda/core/context/Actor;Lnet/corda/core/identity/CordaX500Name;Lnet/corda/client/rpc/internal/DistributionMux;Lnet/corda/core/internal/NamedCacheFactory;)V", "callSiteMap", "Ljava/util/concurrent/ConcurrentHashMap;", "Lnet/corda/core/context/Trace$InvocationId;", "Lnet/corda/nodeapi/internal/rpc/client/CallSite;", "Lnet/corda/nodeapi/internal/rpc/client/CallSiteMap;", "clientAddress", "Lorg/apache/activemq/artemis/api/core/SimpleString;", "consumerSession", "Lorg/apache/activemq/artemis/api/core/client/ClientSession;", "deduplicationChecker", "Lnet/corda/nodeapi/internal/DeduplicationChecker;", "deduplicationSequenceNumber", "Ljava/util/concurrent/atomic/AtomicLong;", "defaultFailoverHandler", "Lnet/corda/client/rpc/internal/RPCClientProxyHandler$FailoverHandler;", "haFailoverHandler", "haFailoverThread", "Ljava/lang/Thread;", "lifeCycle", "Lnet/corda/core/internal/LifeCycle;", "Lnet/corda/client/rpc/internal/RPCClientProxyHandler$State;", "observableContext", "Lnet/corda/nodeapi/internal/rpc/client/ObservableContext;", "observablesToReap", "Lnet/corda/core/internal/ThreadBox;", "net/corda/client/rpc/internal/RPCClientProxyHandler$observablesToReap$1", "observationExecutorPool", "Lnet/corda/core/internal/LazyStickyPool;", "Ljava/util/concurrent/ExecutorService;", "kotlin.jvm.PlatformType", "observationExecutorThreadFactory", "Ljava/util/concurrent/ThreadFactory;", "producerSession", "reaperExecutor", "Ljava/util/concurrent/ScheduledExecutorService;", "reaperScheduledFuture", "Ljava/util/concurrent/ScheduledFuture;", "rpcConsumer", "Lorg/apache/activemq/artemis/api/core/client/ClientConsumer;", "rpcProducer", "Lorg/apache/activemq/artemis/api/core/client/ClientProducer;", "rpcReplyMap", "Lcom/google/common/util/concurrent/SettableFuture;", "", "Lnet/corda/client/rpc/internal/RpcReplyMap;", "sendExecutor", "sendingEnabled", "Ljava/util/concurrent/atomic/AtomicBoolean;", "serializationContextWithObservableContext", "serverProtocolVersion", "", "Ljava/lang/Integer;", "sessionFactory", "Lorg/apache/activemq/artemis/api/core/client/ClientSessionFactory;", "artemisMessageHandler", "", "message", "Lorg/apache/activemq/artemis/api/core/client/ClientMessage;", "attemptReconnect", "checkProtocolVersion", "calledMethod", "Ljava/lang/reflect/Method;", "cleanUpOnConnectionLoss", "close", "notify", "", "createRpcObservableMap", "Lcom/github/benmanes/caffeine/cache/Cache;", "Lrx/subjects/UnicastSubject;", "Lrx/Notification;", "Lnet/corda/nodeapi/internal/rpc/client/RpcObservableMap;", "equals", "other", "forceClose", "hashCode", "initSessions", "invoke", "proxy", "method", "arguments", "", "(Ljava/lang/Object;Ljava/lang/reflect/Method;[Ljava/lang/Object;)Ljava/lang/Object;", "notifyServerAndClose", "produceMethodFullyQualifiedName", "reapObservables", "reapObservablesAndNotify", "sendMessage", "Lnet/corda/nodeapi/RPCApi$ClientToServer;", "setServerProtocolVersion", "version", "setServerProtocolVersion$rpc", "start", "startSessions", "toString", "Companion", "FailoverHandler", "State", "rpc"})
public final class RPCClientProxyHandler
implements InvocationHandler {
    private final LifeCycle<State> lifeCycle;
    private ScheduledExecutorService reaperExecutor;
    private ExecutorService sendExecutor;
    private final ThreadFactory observationExecutorThreadFactory;
    private final LazyStickyPool<ExecutorService> observationExecutorPool;
    private final ConcurrentHashMap<Trace.InvocationId, SettableFuture<Object>> rpcReplyMap;
    private final ConcurrentHashMap<Trace.InvocationId, CallSite> callSiteMap;
    private final ObservableContext observableContext;
    private ScheduledFuture<?> reaperScheduledFuture;
    private Integer serverProtocolVersion;
    private final ThreadBox<observablesToReap.1> observablesToReap;
    private final SerializationContext serializationContextWithObservableContext;
    private SimpleString clientAddress;
    private ClientSessionFactory sessionFactory;
    private ClientSession producerSession;
    private ClientSession consumerSession;
    private ClientProducer rpcProducer;
    private ClientConsumer rpcConsumer;
    private final DeduplicationChecker deduplicationChecker;
    private final AtomicLong deduplicationSequenceNumber;
    private final AtomicBoolean sendingEnabled;
    private Thread haFailoverThread;
    private final FailoverHandler haFailoverHandler;
    private final FailoverHandler defaultFailoverHandler;
    private final CordaRPCClientConfiguration rpcConfiguration;
    private final String rpcUsername;
    private final String rpcPassword;
    private final ServerLocator serverLocator;
    private final Class<? extends RPCOps> rpcOpsClass;
    private final Trace.SessionId sessionId;
    private final Trace externalTrace;
    private final Actor impersonatedActor;
    private final CordaX500Name targetLegalIdentity;
    private final DistributionMux<? extends RPCOps> notificationDistributionMux;
    private final NamedCacheFactory cacheFactory;
    private static final Logger log;
    @NotNull
    private static final Method toStringMethod;
    @NotNull
    private static final Method equalsMethod;
    @NotNull
    private static final Method hashCodeMethod;
    private static boolean terminating;
    @Deprecated
    public static final Companion Companion;

    private final Cache<Trace.InvocationId, UnicastSubject<Notification<?>>> createRpcObservableMap() {
        RemovalListener onObservableRemove2 = new RemovalListener<Trace.InvocationId, UnicastSubject<Notification<?>>>(this){
            final /* synthetic */ RPCClientProxyHandler this$0;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void onRemoval(@Nullable Trace.InvocationId key, @Nullable UnicastSubject<Notification<?>> $noName_1, @NotNull RemovalCause cause) {
                CallSite rpcCallSite;
                Intrinsics.checkParameterIsNotNull((Object)cause, (String)"cause");
                Trace.InvocationId invocationId = key;
                if (invocationId == null) {
                    Intrinsics.throwNpe();
                }
                Trace.InvocationId observableId = invocationId;
                ConcurrentHashMap concurrentHashMap = RPCClientProxyHandler.access$getCallSiteMap$p(this.this$0);
                CallSite callSite = rpcCallSite = concurrentHashMap != null ? (CallSite)concurrentHashMap.remove(observableId) : null;
                if (cause == RemovalCause.COLLECTED) {
                    RPCClientProxyHandler.access$Companion();
                    RPCClientProxyHandler.access$getLog$cp().warn(CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOf((Object[])new String[]{"A hot observable returned from an RPC was never subscribed to.", "This wastes server-side resources because it was queueing observations for retrieval.", "It is being closed now, but please adjust your code to call .notUsed() on the observable", "to close it explicitly. (Java users: subscribe to it then unsubscribe). If you aren't sure", "where the leak is coming from, set -Dnet.corda.client.rpc.trackRpcCallSites=true on the JVM", "command line and you will get a stack trace with this warning."}), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null), (Throwable)rpcCallSite);
                    CallSite callSite2 = rpcCallSite;
                    if (callSite2 != null) {
                        callSite2.printStackTrace();
                    }
                }
                ThreadBox this_$iv = RPCClientProxyHandler.access$getObservablesToReap$p(this.this$0);
                Lock lock = this_$iv.getLock();
                lock.lock();
                try {
                    observablesToReap.1 $receiver = this_$iv.getContent();
                    boolean bl = $receiver.getObservables().add(observableId);
                }
                finally {
                    lock.unlock();
                }
            }
            {
                this.this$0 = rPCClientProxyHandler;
            }
        };
        Caffeine caffeine = Caffeine.newBuilder().weakValues().removalListener(onObservableRemove2).executor(MoreExecutors.directExecutor());
        Intrinsics.checkExpressionValueIsNotNull((Object)caffeine, (String)"Caffeine.newBuilder()\n  \u2026ecutors.directExecutor())");
        return this.cacheFactory.buildNamed(caffeine, "RpcClientProxyHandler_rpcObservable");
    }

    public final void start() {
        this.lifeCycle.requireState((Enum)State.UNSTARTED);
        this.reaperExecutor = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setNameFormat("rpc-client-reaper-%d").setDaemon(true).build());
        this.sendExecutor = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("rpc-client-sender-%d").setDaemon(true).build());
        ScheduledExecutorService scheduledExecutorService = this.reaperExecutor;
        if (scheduledExecutorService == null) {
            Intrinsics.throwNpe();
        }
        Function0 function0 = (Function0)new Function0<Unit>(this){

            public final void invoke() {
                RPCClientProxyHandler.access$reapObservablesAndNotify((RPCClientProxyHandler)this.receiver);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(RPCClientProxyHandler.class);
            }

            public final String getName() {
                return "reapObservablesAndNotify";
            }

            public final String getSignature() {
                return "reapObservablesAndNotify()V";
            }
        };
        this.reaperScheduledFuture = scheduledExecutorService.scheduleAtFixedRate(new RPCClientProxyHandlerKt$sam$java_lang_Runnable$0(function0), this.rpcConfiguration.getReapInterval().toMillis(), this.rpcConfiguration.getReapInterval().toMillis(), TimeUnit.MILLISECONDS);
        try {
            this.sessionFactory = this.serverLocator.createSessionFactory();
        }
        catch (ActiveMQNotConnectedException e) {
            throw (Throwable)((Object)new RPCException("Cannot connect to server(s). Tried with all available servers.", e));
        }
        if (this.serverLocator.getStaticTransportConfigurations().length == 1) {
            ClientSessionFactory clientSessionFactory = this.sessionFactory;
            if (clientSessionFactory == null) {
                Intrinsics.throwNpe();
            }
            clientSessionFactory.addFailoverListener((FailoverEventListener)this.defaultFailoverHandler);
        } else {
            ClientSessionFactory clientSessionFactory = this.sessionFactory;
            if (clientSessionFactory == null) {
                Intrinsics.throwNpe();
            }
            clientSessionFactory.addFailoverListener((FailoverEventListener)this.haFailoverHandler);
        }
        this.initSessions();
        this.lifeCycle.transition((Enum)State.UNSTARTED, (Enum)State.SERVER_VERSION_NOT_SET);
        this.startSessions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Object invoke(@NotNull Object proxy, @NotNull Method method, @Nullable Object[] arguments) {
        Intrinsics.checkParameterIsNotNull((Object)proxy, (String)"proxy");
        Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
        LifeCycle.requireState$default(this.lifeCycle, null, (Function1)invoke.1.INSTANCE, (int)1, null);
        this.checkProtocolVersion(method);
        if (Intrinsics.areEqual((Object)method, (Object)toStringMethod)) {
            return this.toString();
        }
        if (Intrinsics.areEqual((Object)method, (Object)equalsMethod)) {
            return this.equals(arguments != null ? ArraysKt.getOrNull((Object[])arguments, (int)0) : null);
        }
        if (Intrinsics.areEqual((Object)method, (Object)hashCodeMethod)) {
            return this.hashCode();
        }
        ClientSession clientSession = this.consumerSession;
        if (clientSession == null) {
            Intrinsics.throwNpe();
        }
        if (clientSession.isClosed()) {
            throw (Throwable)((Object)new RPCException("RPC Proxy is closed"));
        }
        if (!this.sendingEnabled.get()) {
            throw (Throwable)((Object)new RPCException("RPC server is not available."));
        }
        Trace.InvocationId replyId = Trace.InvocationId.Companion.newInstance$default((Trace.InvocationId.Companion)Trace.InvocationId.Companion, null, null, (int)3, null);
        String methodFqn = this.produceMethodFullyQualifiedName(method);
        ConcurrentHashMap<Trace.InvocationId, CallSite> concurrentHashMap = this.callSiteMap;
        if (concurrentHashMap != null) {
            Map map = concurrentHashMap;
            CallSite callSite = new CallSite(methodFqn);
            map.put(replyId, callSite);
        }
        try {
            boolean bl;
            Object object = arguments;
            if (arguments == null || (object = ArraysKt.toList((Object[])object)) == null) {
                object = CollectionsKt.emptyList();
            }
            SerializedBytes serialisedArguments = SerializationAPIKt.serialize$default((Object)object, null, (SerializationContext)this.serializationContextWithObservableContext, (int)1, null);
            SimpleString simpleString = this.clientAddress;
            if (simpleString == null) {
                Intrinsics.throwNpe();
            }
            RPCApi.ClientToServer.RpcRequest request = new RPCApi.ClientToServer.RpcRequest(simpleString, methodFqn, (OpaqueBytes)serialisedArguments, replyId, this.sessionId, this.externalTrace, this.impersonatedActor);
            SettableFuture replyFuture = SettableFuture.create();
            boolean bl2 = bl = this.rpcReplyMap.put(replyId, (SettableFuture<Object>)replyFuture) == null;
            if (!bl) {
                String string = "Generated several RPC requests with same ID " + replyId;
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            if (RPCUtils.INSTANCE.isShutdownCmd(request)) {
                terminating = true;
            }
            this.sendMessage((RPCApi.ClientToServer)request);
            SettableFuture settableFuture = replyFuture;
            Intrinsics.checkExpressionValueIsNotNull((Object)settableFuture, (String)"replyFuture");
            Object object2 = KotlinUtilsKt.getOrThrow$default((Future)((Future)settableFuture), null, (int)1, null);
            return object2;
        }
        catch (RuntimeException e) {
            throw (Throwable)e;
        }
        catch (Exception e) {
            String string = e.getMessage();
            if (string == null) {
                string = "";
            }
            throw (Throwable)((Object)new RPCException(string, e));
        }
        finally {
            block18: {
                ConcurrentHashMap<Trace.InvocationId, CallSite> concurrentHashMap2 = this.callSiteMap;
                if (concurrentHashMap2 == null) break block18;
                concurrentHashMap2.remove(replyId);
            }
        }
    }

    private final String produceMethodFullyQualifiedName(Method method) {
        String string;
        if (Intrinsics.areEqual(CordaRPCOps.class, this.rpcOpsClass)) {
            String string2 = method.getName();
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"method.name");
        } else {
            string = this.rpcOpsClass.getName() + "#" + method.getName();
        }
        return string;
    }

    private final void sendMessage(RPCApi.ClientToServer message) {
        ClientMessage artemisMessage;
        ClientSession clientSession = this.producerSession;
        if (clientSession == null) {
            Intrinsics.throwNpe();
        }
        ClientMessage clientMessage = artemisMessage = clientSession.createMessage(false);
        Intrinsics.checkExpressionValueIsNotNull((Object)clientMessage, (String)"artemisMessage");
        message.writeToClientMessage(clientMessage);
        CordaX500Name cordaX500Name = this.targetLegalIdentity;
        if (cordaX500Name != null) {
            CordaX500Name cordaX500Name2;
            CordaX500Name it = cordaX500Name2 = cordaX500Name;
            artemisMessage.putStringProperty("rpc-target-legal-identity", it.toString());
        }
        ExecutorService executorService = this.sendExecutor;
        if (executorService == null) {
            Intrinsics.throwNpe();
        }
        executorService.submit(new Runnable(this, artemisMessage, message){
            final /* synthetic */ RPCClientProxyHandler this$0;
            final /* synthetic */ ClientMessage $artemisMessage;
            final /* synthetic */ RPCApi.ClientToServer $message;

            public final void run() {
                this.$artemisMessage.putLongProperty("deduplication-sequence-number", RPCClientProxyHandler.access$getDeduplicationSequenceNumber$p(this.this$0).getAndIncrement());
                RPCClientProxyHandler.access$Companion();
                Logger $receiver$iv = RPCClientProxyHandler.access$getLog$cp();
                if ($receiver$iv.isDebugEnabled()) {
                    Logger logger = $receiver$iv;
                    String string = "-> RPC -> " + this.$message;
                    logger.debug(string);
                }
                ClientProducer clientProducer = RPCClientProxyHandler.access$getRpcProducer$p(this.this$0);
                if (clientProducer == null) {
                    Intrinsics.throwNpe();
                }
                clientProducer.send((Message)this.$artemisMessage);
            }
            {
                this.this$0 = rPCClientProxyHandler;
                this.$artemisMessage = clientMessage;
                this.$message = clientToServer;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void artemisMessageHandler(ClientMessage message) {
        block20: {
            Function3<Trace.InvocationId, Throwable, SettableFuture<Object>, Unit> completeExceptionally$ = new Function3<Trace.InvocationId, Throwable, SettableFuture<Object>, Unit>(this){
                final /* synthetic */ RPCClientProxyHandler this$0;

                public final void invoke(@NotNull Trace.InvocationId id, @NotNull Throwable e, @Nullable SettableFuture<Object> future) {
                    block2: {
                        CallSite rpcCallSite;
                        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
                        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                        ConcurrentHashMap concurrentHashMap = RPCClientProxyHandler.access$getCallSiteMap$p(this.this$0);
                        CallSite callSite = rpcCallSite = concurrentHashMap != null ? (CallSite)concurrentHashMap.get(id) : null;
                        if (rpcCallSite != null) {
                            net.corda.client.rpc.internal.RPCClientProxyHandler$Companion.access$addRpcCallSiteToThrowable(RPCClientProxyHandler.access$Companion(), e, rpcCallSite);
                        }
                        SettableFuture<Object> settableFuture = future;
                        if (settableFuture == null) break block2;
                        Throwable throwable = e.getCause();
                        if (throwable == null) {
                            throwable = e;
                        }
                        settableFuture.setException(throwable);
                    }
                }
                {
                    this.this$0 = rPCClientProxyHandler;
                    super(3);
                }
            };
            try {
                void this_$iv;
                String string;
                Logger logger;
                RPCApi.ServerToClient serverToClient;
                try {
                    serverToClient = RPCApi.ServerToClient.Companion.fromClientMessage(this.serializationContextWithObservableContext, message);
                }
                catch (RPCApi.ServerToClient.FailedToDeserializeReply e) {
                    log.error("Failed to deserialize RPC body", (Throwable)e);
                    completeExceptionally$.invoke(e.getId(), (Throwable)e, this.rpcReplyMap.remove(e.getId()));
                    message.acknowledge();
                    return;
                }
                RPCApi.ServerToClient serverToClient2 = serverToClient;
                Long deduplicationSequenceNumber = message.getLongProperty("deduplication-sequence-number");
                String string2 = serverToClient2.getDeduplicationIdentity();
                Long l = deduplicationSequenceNumber;
                Intrinsics.checkExpressionValueIsNotNull((Object)l, (String)"deduplicationSequenceNumber");
                if (this.deduplicationChecker.checkDuplicateMessageId((Object)string2, l.longValue())) {
                    log.info("Message duplication detected, discarding message");
                    return;
                }
                Logger $receiver$iv = log;
                if ($receiver$iv.isDebugEnabled()) {
                    logger = $receiver$iv;
                    string = "Got message from RPC server " + serverToClient2;
                    logger.debug(string);
                }
                RPCApi.ServerToClient serverToClient3 = serverToClient2;
                if (serverToClient3 instanceof RPCApi.ServerToClient.RpcReply) {
                    SettableFuture<Object> replyFuture = this.rpcReplyMap.remove(((RPCApi.ServerToClient.RpcReply)serverToClient2).getId());
                    if (replyFuture == null) {
                        log.error("RPC reply arrived to unknown RPC ID " + ((RPCApi.ServerToClient.RpcReply)serverToClient2).getId() + ", this indicates an internal RPC error.");
                    } else {
                        Try result = ((RPCApi.ServerToClient.RpcReply)serverToClient2).getResult();
                        Try try_ = result;
                        if (try_ instanceof Try.Success) {
                            replyFuture.set(((Try.Success)result).getValue());
                        } else if (try_ instanceof Try.Failure) {
                            completeExceptionally$.invoke(((RPCApi.ServerToClient.RpcReply)serverToClient2).getId(), ((Try.Failure)result).getException(), replyFuture);
                        }
                    }
                    break block20;
                }
                if (!(serverToClient3 instanceof RPCApi.ServerToClient.Observation)) break block20;
                UnicastSubject observable2 = (UnicastSubject)this.observableContext.getObservableMap().getIfPresent((Object)((RPCApi.ServerToClient.Observation)serverToClient2).getId());
                if (observable2 == null) {
                    Logger $receiver$iv2 = log;
                    if ($receiver$iv2.isDebugEnabled()) {
                        logger = $receiver$iv2;
                        string = "Observation " + ((RPCApi.ServerToClient.Observation)serverToClient2).getContent() + " arrived to unknown Observable with ID " + ((RPCApi.ServerToClient.Observation)serverToClient2).getId() + ". " + "This may be due to an observation arriving before the server was " + "notified of observable shutdown";
                        logger.debug(string);
                    }
                    break block20;
                }
                LazyStickyPool<ExecutorService> $receiver$iv2 = this.observationExecutorPool;
                Trace.InvocationId stickToOrNull$iv = ((RPCApi.ServerToClient.Observation)serverToClient2).getId();
                Object object = stickToOrNull$iv == null ? this_$iv.borrow() : new Pair((Object)stickToOrNull$iv, this_$iv.borrow((Object)stickToOrNull$iv));
                Object object2 = object.component1();
                Object instance$iv = object.component2();
                try {
                    ExecutorService executor = (ExecutorService)instance$iv;
                    object = executor.submit(new Runnable(this, serverToClient2, observable2){
                        final /* synthetic */ RPCClientProxyHandler this$0;
                        final /* synthetic */ RPCApi.ServerToClient $serverToClient$inlined;
                        final /* synthetic */ UnicastSubject $observable$inlined;
                        {
                            this.this$0 = rPCClientProxyHandler;
                            this.$serverToClient$inlined = serverToClient;
                            this.$observable$inlined = unicastSubject;
                        }

                        public final void run() {
                            Notification content = ((RPCApi.ServerToClient.Observation)this.$serverToClient$inlined).getContent();
                            if (content.isOnCompleted() || content.isOnError()) {
                                RPCClientProxyHandler.access$getObservableContext$p(this.this$0).getObservableMap().invalidate((Object)((RPCApi.ServerToClient.Observation)this.$serverToClient$inlined).getId());
                            }
                            if (content.isOnError()) {
                                CallSite rpcCallSite;
                                ConcurrentHashMap concurrentHashMap = RPCClientProxyHandler.access$getCallSiteMap$p(this.this$0);
                                CallSite callSite = rpcCallSite = concurrentHashMap != null ? (CallSite)concurrentHashMap.get(((RPCApi.ServerToClient.Observation)this.$serverToClient$inlined).getId()) : null;
                                if (rpcCallSite != null) {
                                    Companion companion = RPCClientProxyHandler.access$Companion();
                                    Throwable throwable = content.getThrowable();
                                    Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"content.throwable");
                                    net.corda.client.rpc.internal.RPCClientProxyHandler$Companion.access$addRpcCallSiteToThrowable(companion, throwable, rpcCallSite);
                                }
                            }
                            this.$observable$inlined.onNext((Object)content);
                        }
                    });
                }
                finally {
                    void stickTo$iv;
                    this_$iv.release((Object)stickTo$iv, instance$iv);
                }
            }
            finally {
                message.acknowledge();
            }
        }
    }

    public final void forceClose() {
        this.close(false);
    }

    public final void notifyServerAndClose() {
        this.close(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void close(boolean notify) {
        Iterable observationExecutors;
        Object this_$iv;
        Map.Entry element$iv2;
        Object $receiver;
        Thread thread = this.haFailoverThread;
        if (thread != null) {
            Thread thread2 = thread;
            $receiver = thread2;
            ((Thread)$receiver).interrupt();
            ((Thread)$receiver).join(1000L);
        }
        if (notify) {
            ClientSessionFactory clientSessionFactory = this.sessionFactory;
            if (clientSessionFactory != null) {
                clientSessionFactory.close();
            }
        } else {
            ClientSessionFactory clientSessionFactory = this.sessionFactory;
            if (clientSessionFactory != null) {
                clientSessionFactory.cleanup();
            }
        }
        ScheduledFuture<?> scheduledFuture = this.reaperScheduledFuture;
        if (scheduledFuture != null) {
            scheduledFuture.cancel(false);
        }
        ConcurrentMap concurrentMap = this.observableContext.getObservableMap().asMap();
        Intrinsics.checkExpressionValueIsNotNull((Object)concurrentMap, (String)"observableContext.observableMap.asMap()");
        Map $receiver$iv = concurrentMap;
        $receiver = $receiver$iv;
        Iterator iterator = $receiver.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry $key_observable;
            Map.Entry entry = $key_observable = (element$iv2 = iterator.next());
            Trace.InvocationId key = (Trace.InvocationId)entry.getKey();
            entry = $key_observable;
            UnicastSubject observable2 = (UnicastSubject)entry.getValue();
            this_$iv = this.observationExecutorPool;
            Pair pair = key == null ? this_$iv.borrow() : new Pair((Object)key, this_$iv.borrow((Object)key));
            Object object = pair.component1();
            Object instance$iv = pair.component2();
            try {
                UnicastSubject unicastSubject;
                ExecutorService it = (ExecutorService)instance$iv;
                if (observable2 != null) {
                    UnicastSubject unicastSubject2;
                    Companion companion = Companion;
                    UnicastSubject p1 = unicastSubject2;
                    companion.closeObservable(p1);
                    unicastSubject = unicastSubject2;
                } else {
                    unicastSubject = null;
                }
                pair = unicastSubject;
            }
            finally {
                void stickTo$iv;
                this_$iv.release((Object)stickTo$iv, instance$iv);
            }
        }
        this.observableContext.getObservableMap().invalidateAll();
        $receiver$iv = this.rpcReplyMap;
        $receiver = $receiver$iv;
        iterator = $receiver.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry $$_$_replyFuture = element$iv2 = iterator.next();
            this_$iv = $$_$_replyFuture;
            SettableFuture replyFuture = (SettableFuture)this_$iv.getValue();
            replyFuture.setException((Throwable)((Object)new ConnectionFailureException(null, 1, null)));
        }
        this.rpcReplyMap.clear();
        ConcurrentHashMap<Trace.InvocationId, CallSite> concurrentHashMap = this.callSiteMap;
        if (concurrentHashMap != null) {
            concurrentHashMap.clear();
        }
        this.reapObservables(notify);
        ScheduledExecutorService scheduledExecutorService = this.reaperExecutor;
        if (scheduledExecutorService != null) {
            scheduledExecutorService.shutdownNow();
        }
        ExecutorService executorService = this.sendExecutor;
        if (executorService != null) {
            executorService.shutdownNow();
        }
        Iterable $receiver$iv2 = observationExecutors = this.observationExecutorPool.close();
        for (Map.Entry element$iv2 : $receiver$iv2) {
            ExecutorService it = (ExecutorService)((Object)element$iv2);
            it.shutdownNow();
        }
        this.notificationDistributionMux.onDisconnect$rpc(null);
        this.lifeCycle.justTransition((Enum)State.FINISHED);
    }

    static /* bridge */ /* synthetic */ void close$default(RPCClientProxyHandler rPCClientProxyHandler, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        rPCClientProxyHandler.close(bl);
    }

    private final void checkProtocolVersion(Method calledMethod) {
        Integer serverProtocolVersion = this.serverProtocolVersion;
        if (serverProtocolVersion == null) {
            this.lifeCycle.requireState((Enum)State.SERVER_VERSION_NOT_SET);
        } else {
            int sinceVersion;
            this.lifeCycle.requireState((Enum)State.STARTED);
            RPCSinceVersion rPCSinceVersion = calledMethod.getAnnotation(RPCSinceVersion.class);
            int n = sinceVersion = rPCSinceVersion != null ? rPCSinceVersion.version() : 0;
            if (Intrinsics.compare((int)sinceVersion, (int)serverProtocolVersion) > 0) {
                throw (Throwable)new UnsupportedOperationException("Method " + calledMethod + " was added in RPC protocol version " + sinceVersion + " but the server is running " + serverProtocolVersion);
            }
        }
    }

    public final void setServerProtocolVersion$rpc(int version) {
        if (this.serverProtocolVersion != null) {
            throw (Throwable)new IllegalStateException("setServerProtocolVersion called, but the protocol version was already set!");
        }
        this.serverProtocolVersion = version;
        this.lifeCycle.transition((Enum)State.SERVER_VERSION_NOT_SET, (Enum)State.STARTED);
    }

    private final void reapObservablesAndNotify() {
        RPCClientProxyHandler.reapObservables$default(this, false, 1, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void reapObservables(boolean notify) {
        observablesToReap.1 $receiver;
        this.observableContext.getObservableMap().cleanUp();
        if (!notify) {
            return;
        }
        ThreadBox<observablesToReap.1> this_$iv = this.observablesToReap;
        Lock lock = this_$iv.getLock();
        lock.lock();
        try {
            ArrayList<Trace.InvocationId> arrayList;
            $receiver = this_$iv.getContent();
            Collection collection = $receiver.getObservables();
            if (!collection.isEmpty()) {
                ArrayList<Trace.InvocationId> temporary = $receiver.getObservables();
                $receiver.setObservables(new ArrayList<Trace.InvocationId>());
                arrayList = temporary;
            } else {
                arrayList = null;
            }
            $receiver = arrayList;
        }
        finally {
            lock.unlock();
        }
        observablesToReap.1 observableIds = $receiver;
        if (observableIds != null) {
            Logger $receiver$iv = log;
            if ($receiver$iv.isDebugEnabled()) {
                Logger logger = $receiver$iv;
                String string = "Reaping " + ((ArrayList)((Object)observableIds)).size() + " observables";
                logger.debug(string);
            }
            this.sendMessage((RPCApi.ClientToServer)new RPCApi.ClientToServer.ObservablesClosed((List)((Object)observableIds)));
        }
    }

    static /* bridge */ /* synthetic */ void reapObservables$default(RPCClientProxyHandler rPCClientProxyHandler, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        rPCClientProxyHandler.reapObservables(bl);
    }

    private final void attemptReconnect() {
        boolean maxReconnectReached;
        String string;
        Logger logger;
        int maxReconnectCount = this.rpcConfiguration.getMaxReconnectAttempts() * this.serverLocator.getStaticTransportConfigurations().length;
        Logger $receiver$iv = log;
        if ($receiver$iv.isDebugEnabled()) {
            logger = $receiver$iv;
            string = "maxReconnectCount = " + maxReconnectCount;
            logger.debug(string);
        }
        int reconnectAttempt = 1;
        Duration retryInterval = this.rpcConfiguration.getConnectionRetryInterval();
        Duration maxRetryInterval = this.rpcConfiguration.getConnectionMaxRetryInterval();
        Function1<Integer, Boolean> shouldRetry$ = new Function1<Integer, Boolean>(maxReconnectCount){
            final /* synthetic */ int $maxReconnectCount;

            public final boolean invoke(int reconnectAttempt) {
                return this.$maxReconnectCount < 0 ? true : reconnectAttempt <= this.$maxReconnectCount;
            }
            {
                this.$maxReconnectCount = n;
                super(1);
            }
        };
        while (shouldRetry$.invoke(reconnectAttempt)) {
            Logger $receiver$iv2;
            TransportConfiguration transport;
            block11: {
                TransportConfiguration[] transportConfigurationArray;
                TransportConfiguration[] it = transportConfigurationArray = this.serverLocator.getStaticTransportConfigurations();
                transport = it[(reconnectAttempt - 1) % it.length];
                $receiver$iv2 = log;
                if ($receiver$iv2.isDebugEnabled()) {
                    logger = $receiver$iv2;
                    StringBuilder stringBuilder = new StringBuilder().append("Trying to connect using ");
                    TransportConfiguration transportConfiguration = transport;
                    Intrinsics.checkExpressionValueIsNotNull((Object)transportConfiguration, (String)"transport");
                    string = stringBuilder.append(transportConfiguration.getParams()).toString();
                    logger.debug(string);
                }
                try {
                    if (!this.serverLocator.isClosed()) {
                        this.sessionFactory = this.serverLocator.createSessionFactory(transport);
                        break block11;
                    }
                    log.warn("Stopping reconnect attempts.");
                    $receiver$iv2 = log;
                    if (!$receiver$iv2.isDebugEnabled()) break;
                    logger = $receiver$iv2;
                    string = "Server locator is closed or garbage collected. Proxy may have been closed during reconnect.";
                    logger.debug(string);
                    break;
                }
                catch (ActiveMQException e) {
                    try {
                        Thread.sleep(retryInterval.toMillis());
                    }
                    catch (InterruptedException $i$a$4$debug) {
                        // empty catch block
                    }
                    int $i$a$4$debug = reconnectAttempt;
                    reconnectAttempt = $i$a$4$debug + 1;
                    retryInterval = (Duration)ComparisonsKt.minOf((Comparable)maxRetryInterval, (Comparable)InternalUtils.times((Duration)retryInterval, (long)((long)this.rpcConfiguration.getConnectionRetryIntervalMultiplier())));
                    continue;
                }
            }
            $receiver$iv2 = log;
            if ($receiver$iv2.isDebugEnabled()) {
                logger = $receiver$iv2;
                StringBuilder stringBuilder = new StringBuilder().append("Connected successfully after ").append(reconnectAttempt).append(" attempts using ");
                TransportConfiguration transportConfiguration = transport;
                Intrinsics.checkExpressionValueIsNotNull((Object)transportConfiguration, (String)"transport");
                string = stringBuilder.append(transportConfiguration.getParams()).append('.').toString();
                logger.debug(string);
            }
            log.info("RPC server available.");
            ClientSessionFactory clientSessionFactory = this.sessionFactory;
            if (clientSessionFactory == null) {
                Intrinsics.throwNpe();
            }
            clientSessionFactory.addFailoverListener((FailoverEventListener)this.haFailoverHandler);
            this.initSessions();
            this.startSessions();
            this.sendingEnabled.set(true);
            this.notificationDistributionMux.onConnect$rpc();
            break;
        }
        boolean bl = maxReconnectReached = !shouldRetry$.invoke(reconnectAttempt);
        if (maxReconnectReached || this.sessionFactory == null) {
            String errMessage = "Could not reconnect to the RPC server after trying " + reconnectAttempt + " times." + (this.sessionFactory != null ? "" : " It was never possible to to establish connection with any of the endpoints.");
            log.error(errMessage);
            this.notificationDistributionMux.onPermanentFailure$rpc(new IllegalStateException(errMessage));
        }
    }

    private final void initSessions() {
        ClientSessionFactory clientSessionFactory = this.sessionFactory;
        if (clientSessionFactory == null) {
            Intrinsics.throwNpe();
        }
        ClientSession clientSession = this.producerSession = clientSessionFactory.createSession(this.rpcUsername, this.rpcPassword, false, true, true, false, 0x100000);
        if (clientSession == null) {
            Intrinsics.throwNpe();
        }
        this.rpcProducer = clientSession.createProducer("rpc.server");
        ClientSessionFactory clientSessionFactory2 = this.sessionFactory;
        if (clientSessionFactory2 == null) {
            Intrinsics.throwNpe();
        }
        this.consumerSession = clientSessionFactory2.createSession(this.rpcUsername, this.rpcPassword, false, true, true, false, 16384);
        this.clientAddress = new SimpleString("rpc.client." + this.rpcUsername + '.' + CryptoUtils.random63BitValue());
        Logger $receiver$iv = log;
        if ($receiver$iv.isDebugEnabled()) {
            Logger logger = $receiver$iv;
            String string = "Client address: " + this.clientAddress;
            logger.debug(string);
        }
        ClientSession clientSession2 = this.consumerSession;
        if (clientSession2 == null) {
            Intrinsics.throwNpe();
        }
        clientSession2.createTemporaryQueue(this.clientAddress, RoutingType.ANYCAST, this.clientAddress);
        ClientSession clientSession3 = this.consumerSession;
        if (clientSession3 == null) {
            Intrinsics.throwNpe();
        }
        ClientConsumer clientConsumer = this.rpcConsumer = clientSession3.createConsumer(this.clientAddress);
        if (clientConsumer == null) {
            Intrinsics.throwNpe();
        }
        Function1 function1 = (Function1)new Function1<ClientMessage, Unit>(this){

            public final void invoke(@NotNull ClientMessage p1) {
                Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                RPCClientProxyHandler.access$artemisMessageHandler((RPCClientProxyHandler)this.receiver, p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(RPCClientProxyHandler.class);
            }

            public final String getName() {
                return "artemisMessageHandler";
            }

            public final String getSignature() {
                return "artemisMessageHandler(Lorg/apache/activemq/artemis/api/core/client/ClientMessage;)V";
            }
        };
        clientConsumer.setMessageHandler((MessageHandler)new RPCClientProxyHandlerKt$sam$org_apache_activemq_artemis_api_core_client_MessageHandler$0(function1));
    }

    private final void startSessions() {
        ClientSession clientSession = this.consumerSession;
        if (clientSession == null) {
            Intrinsics.throwNpe();
        }
        clientSession.start();
        ClientSession clientSession2 = this.producerSession;
        if (clientSession2 == null) {
            Intrinsics.throwNpe();
        }
        clientSession2.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void cleanUpOnConnectionLoss() {
        String string;
        Object object;
        Object object2;
        Object element$iv;
        this.sendingEnabled.set(false);
        log.warn("Terminating observables.");
        ConcurrentMap m = this.observableContext.getObservableMap().asMap();
        ConnectionFailureException connectionFailureException = new ConnectionFailureException(null, 1, null);
        Object $receiver$iv = m.keySet();
        Object object3 = $receiver$iv.iterator();
        while (object3.hasNext()) {
            element$iv = object3.next();
            Trace.InvocationId k = (Trace.InvocationId)element$iv;
            LazyStickyPool<ExecutorService> this_$iv = this.observationExecutorPool;
            object2 = k == null ? this_$iv.borrow() : new Pair((Object)k, this_$iv.borrow((Object)k));
            Object object4 = object2.component1();
            Object instance$iv = object2.component2();
            try {
                Unit unit;
                ExecutorService it = (ExecutorService)instance$iv;
                try {
                    Unit unit2;
                    UnicastSubject unicastSubject = (UnicastSubject)m.get(k);
                    if (unicastSubject != null) {
                        unicastSubject.onError((Throwable)((Object)connectionFailureException));
                        unit2 = Unit.INSTANCE;
                    } else {
                        unit2 = null;
                    }
                    unit = unit2;
                }
                catch (Exception e) {
                    log.error("Unexpected exception when RPC connection failure handling", (Throwable)e);
                    unit = Unit.INSTANCE;
                }
                object2 = unit;
            }
            finally {
                void stickTo$iv;
                this_$iv.release((Object)stickTo$iv, instance$iv);
            }
        }
        this.observableContext.getObservableMap().invalidateAll();
        object3 = $receiver$iv = (Map)this.rpcReplyMap;
        element$iv = object3.entrySet().iterator();
        while (element$iv.hasNext()) {
            Map.Entry element$iv2;
            Map.Entry $$_$_replyFuture = element$iv2 = (Map.Entry)element$iv.next();
            object2 = $$_$_replyFuture;
            SettableFuture replyFuture = (SettableFuture)object2.getValue();
            replyFuture.setException((Throwable)((Object)connectionFailureException));
        }
        $receiver$iv = log;
        if ($receiver$iv.isDebugEnabled()) {
            object = $receiver$iv;
            string = "rpcReplyMap size before clear: " + this.rpcReplyMap.size();
            object.debug(string);
        }
        this.rpcReplyMap.clear();
        $receiver$iv = log;
        if ($receiver$iv.isDebugEnabled()) {
            object = $receiver$iv;
            ConcurrentHashMap<Trace.InvocationId, CallSite> concurrentHashMap = this.callSiteMap;
            string = "callSiteMap size before clear: " + (concurrentHashMap != null ? Integer.valueOf(concurrentHashMap.size()) : null);
            object.debug(string);
        }
        ConcurrentHashMap<Trace.InvocationId, CallSite> concurrentHashMap = this.callSiteMap;
        if (concurrentHashMap != null) {
            concurrentHashMap.clear();
        }
        this.notificationDistributionMux.onDisconnect$rpc((Throwable)((Object)connectionFailureException));
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null) ^ true) {
            return false;
        }
        Object object2 = other;
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type net.corda.client.rpc.internal.RPCClientProxyHandler");
        }
        RPCClientProxyHandler cfr_ignored_0 = (RPCClientProxyHandler)object2;
        if (Intrinsics.areEqual((Object)this.rpcUsername, (Object)((RPCClientProxyHandler)other).rpcUsername) ^ true) {
            return false;
        }
        if (Intrinsics.areEqual((Object)this.sessionId, (Object)((RPCClientProxyHandler)other).sessionId) ^ true) {
            return false;
        }
        return !(Intrinsics.areEqual((Object)this.targetLegalIdentity, (Object)((RPCClientProxyHandler)other).targetLegalIdentity) ^ true);
    }

    public int hashCode() {
        int result = this.rpcUsername.hashCode();
        result = 31 * result + this.sessionId.hashCode();
        CordaX500Name cordaX500Name = this.targetLegalIdentity;
        result = 31 * result + (cordaX500Name != null ? cordaX500Name.hashCode() : 0);
        return result;
    }

    @NotNull
    public String toString() {
        return "{rpcUsername='" + this.rpcUsername + "', clientAddress=" + this.clientAddress + ", sessionId=" + this.sessionId + ", targetLegalIdentity=" + this.targetLegalIdentity + '}';
    }

    public RPCClientProxyHandler(@NotNull CordaRPCClientConfiguration rpcConfiguration, @NotNull String rpcUsername, @NotNull String rpcPassword, @NotNull ServerLocator serverLocator, @NotNull Class<? extends RPCOps> rpcOpsClass, @NotNull SerializationContext serializationContext, @NotNull Trace.SessionId sessionId, @Nullable Trace externalTrace, @Nullable Actor impersonatedActor, @Nullable CordaX500Name targetLegalIdentity, @NotNull DistributionMux<? extends RPCOps> notificationDistributionMux, @NotNull NamedCacheFactory cacheFactory) {
        ObservableContext observableContext;
        Intrinsics.checkParameterIsNotNull((Object)rpcConfiguration, (String)"rpcConfiguration");
        Intrinsics.checkParameterIsNotNull((Object)rpcUsername, (String)"rpcUsername");
        Intrinsics.checkParameterIsNotNull((Object)rpcPassword, (String)"rpcPassword");
        Intrinsics.checkParameterIsNotNull((Object)serverLocator, (String)"serverLocator");
        Intrinsics.checkParameterIsNotNull(rpcOpsClass, (String)"rpcOpsClass");
        Intrinsics.checkParameterIsNotNull((Object)serializationContext, (String)"serializationContext");
        Intrinsics.checkParameterIsNotNull((Object)sessionId, (String)"sessionId");
        Intrinsics.checkParameterIsNotNull(notificationDistributionMux, (String)"notificationDistributionMux");
        Intrinsics.checkParameterIsNotNull((Object)cacheFactory, (String)"cacheFactory");
        this.rpcConfiguration = rpcConfiguration;
        this.rpcUsername = rpcUsername;
        this.rpcPassword = rpcPassword;
        this.serverLocator = serverLocator;
        this.rpcOpsClass = rpcOpsClass;
        this.sessionId = sessionId;
        this.externalTrace = externalTrace;
        this.impersonatedActor = impersonatedActor;
        this.targetLegalIdentity = targetLegalIdentity;
        this.notificationDistributionMux = notificationDistributionMux;
        this.cacheFactory = cacheFactory;
        this.lifeCycle = new LifeCycle((Enum)State.UNSTARTED);
        this.observationExecutorThreadFactory = new ThreadFactoryBuilder().setNameFormat("rpc-client-observation-pool-%d").setDaemon(true).build();
        this.observationExecutorPool = new LazyStickyPool(this.rpcConfiguration.getObservationExecutorPoolSize(), (Function0)new Function0<ExecutorService>(this){
            final /* synthetic */ RPCClientProxyHandler this$0;

            public final ExecutorService invoke() {
                return Executors.newFixedThreadPool(1, RPCClientProxyHandler.access$getObservationExecutorThreadFactory$p(this.this$0));
            }
            {
                this.this$0 = rPCClientProxyHandler;
                super(0);
            }
        });
        this.rpcReplyMap = new ConcurrentHashMap();
        this.callSiteMap = this.rpcConfiguration.getTrackRpcCallSites() ? new ConcurrentHashMap() : null;
        Cache<Trace.InvocationId, UnicastSubject<Notification<?>>> cache = this.createRpcObservableMap();
        ConcurrentHashMap<Trace.InvocationId, CallSite> concurrentHashMap = this.callSiteMap;
        ObservableContext observableContext2 = observableContext;
        ObservableContext observableContext3 = observableContext;
        RPCClientProxyHandler rPCClientProxyHandler = this;
        Set set = new LinkedHashSet();
        Set set2 = Collections.synchronizedSet(set);
        Intrinsics.checkExpressionValueIsNotNull(set2, (String)"Collections.synchronized\u2026leSetOf<Observable<*>>())");
        observableContext2(concurrentHashMap, cache, set2);
        rPCClientProxyHandler.observableContext = observableContext3;
        this.observablesToReap = new ThreadBox(new Object(){
            @NotNull
            private ArrayList<Trace.InvocationId> observables;

            @NotNull
            public final ArrayList<Trace.InvocationId> getObservables() {
                return this.observables;
            }

            public final void setObservables(@NotNull ArrayList<Trace.InvocationId> arrayList) {
                Intrinsics.checkParameterIsNotNull(arrayList, (String)"<set-?>");
                this.observables = arrayList;
            }
            {
                this.observables = new ArrayList<E>();
            }
        }, null, 2, null);
        this.serializationContextWithObservableContext = RpcClientObservableDeSerializer.INSTANCE.createContext(serializationContext, this.observableContext);
        this.deduplicationChecker = new DeduplicationChecker(this.rpcConfiguration.getDeduplicationCacheExpiry(), null, this.cacheFactory, 2, null);
        this.deduplicationSequenceNumber = new AtomicLong(0L);
        this.sendingEnabled = new AtomicBoolean(true);
        this.haFailoverHandler = new FailoverHandler((Function0)new Function0<Unit>(this){
            final /* synthetic */ RPCClientProxyHandler this$0;

            public final void invoke() {
                RPCClientProxyHandler.access$Companion();
                RPCClientProxyHandler.access$getLog$cp().warn("Connection failure. Attempting to reconnect using back-up addresses.");
                RPCClientProxyHandler.access$cleanUpOnConnectionLoss(this.this$0);
                ClientSessionFactory clientSessionFactory = RPCClientProxyHandler.access$getSessionFactory$p(this.this$0);
                if (clientSessionFactory != null) {
                    ClientSessionFactory clientSessionFactory2;
                    ClientSessionFactory $receiver = clientSessionFactory2 = clientSessionFactory;
                    $receiver.getConnection().destroy();
                    $receiver.cleanup();
                    $receiver.close();
                }
                RPCClientProxyHandler.access$setHaFailoverThread$p(this.this$0, Thread.currentThread());
                RPCClientProxyHandler.access$attemptReconnect(this.this$0);
            }
            {
                this.this$0 = rPCClientProxyHandler;
                super(0);
            }
        }, null, null, 6, null);
        this.defaultFailoverHandler = new FailoverHandler((Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ RPCClientProxyHandler this$0;

            public final void invoke() {
                RPCClientProxyHandler.access$cleanUpOnConnectionLoss(this.this$0);
            }
            {
                this.this$0 = rPCClientProxyHandler;
                super(0);
            }
        }), (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ RPCClientProxyHandler this$0;

            public final void invoke() {
                RPCClientProxyHandler.access$getSendingEnabled$p(this.this$0).set(true);
                RPCClientProxyHandler.access$Companion();
                RPCClientProxyHandler.access$getLog$cp().info("RPC server available.");
            }
            {
                this.this$0 = rPCClientProxyHandler;
                super(0);
            }
        }), (Function0<Unit>)((Function0)defaultFailoverHandler.3.INSTANCE));
    }

    public /* synthetic */ RPCClientProxyHandler(CordaRPCClientConfiguration cordaRPCClientConfiguration, String string, String string2, ServerLocator serverLocator, Class clazz, SerializationContext serializationContext, Trace.SessionId sessionId, Trace trace, Actor actor, CordaX500Name cordaX500Name, DistributionMux distributionMux, NamedCacheFactory namedCacheFactory, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x800) != 0) {
            namedCacheFactory = new ClientCacheFactory();
        }
        this(cordaRPCClientConfiguration, string, string2, serverLocator, clazz, serializationContext, sessionId, trace, actor, cordaX500Name, distributionMux, namedCacheFactory);
    }

    static {
        Companion = new Companion(null);
        log = KotlinUtilsKt.contextLogger((Object)Companion);
        Method method = ReflectJvmMapping.getJavaMethod((KFunction)Companion.toStringMethod.1.INSTANCE);
        if (method == null) {
            Intrinsics.throwNpe();
        }
        toStringMethod = method;
        Method method2 = ReflectJvmMapping.getJavaMethod((KFunction)Companion.equalsMethod.1.INSTANCE);
        if (method2 == null) {
            Intrinsics.throwNpe();
        }
        equalsMethod = method2;
        Method method3 = ReflectJvmMapping.getJavaMethod((KFunction)Companion.hashCodeMethod.1.INSTANCE);
        if (method3 == null) {
            Intrinsics.throwNpe();
        }
        hashCodeMethod = method3;
    }

    @Nullable
    public static final /* synthetic */ ConcurrentHashMap access$getCallSiteMap$p(RPCClientProxyHandler $this) {
        return $this.callSiteMap;
    }

    @NotNull
    public static final /* synthetic */ ThreadBox access$getObservablesToReap$p(RPCClientProxyHandler $this) {
        return $this.observablesToReap;
    }

    public static final /* synthetic */ void access$reapObservablesAndNotify(RPCClientProxyHandler $this) {
        $this.reapObservablesAndNotify();
    }

    @NotNull
    public static final /* synthetic */ AtomicLong access$getDeduplicationSequenceNumber$p(RPCClientProxyHandler $this) {
        return $this.deduplicationSequenceNumber;
    }

    @Nullable
    public static final /* synthetic */ ClientProducer access$getRpcProducer$p(RPCClientProxyHandler $this) {
        return $this.rpcProducer;
    }

    public static final /* synthetic */ void access$setRpcProducer$p(RPCClientProxyHandler $this, @Nullable ClientProducer clientProducer) {
        $this.rpcProducer = clientProducer;
    }

    @NotNull
    public static final /* synthetic */ ObservableContext access$getObservableContext$p(RPCClientProxyHandler $this) {
        return $this.observableContext;
    }

    public static final /* synthetic */ void access$artemisMessageHandler(RPCClientProxyHandler $this, @NotNull ClientMessage message) {
        $this.artemisMessageHandler(message);
    }

    public static final /* synthetic */ ThreadFactory access$getObservationExecutorThreadFactory$p(RPCClientProxyHandler $this) {
        return $this.observationExecutorThreadFactory;
    }

    public static final /* synthetic */ void access$cleanUpOnConnectionLoss(RPCClientProxyHandler $this) {
        $this.cleanUpOnConnectionLoss();
    }

    @Nullable
    public static final /* synthetic */ ClientSessionFactory access$getSessionFactory$p(RPCClientProxyHandler $this) {
        return $this.sessionFactory;
    }

    public static final /* synthetic */ void access$setSessionFactory$p(RPCClientProxyHandler $this, @Nullable ClientSessionFactory clientSessionFactory) {
        $this.sessionFactory = clientSessionFactory;
    }

    @Nullable
    public static final /* synthetic */ Thread access$getHaFailoverThread$p(RPCClientProxyHandler $this) {
        return $this.haFailoverThread;
    }

    public static final /* synthetic */ void access$setHaFailoverThread$p(RPCClientProxyHandler $this, @Nullable Thread thread) {
        $this.haFailoverThread = thread;
    }

    public static final /* synthetic */ void access$attemptReconnect(RPCClientProxyHandler $this) {
        $this.attemptReconnect();
    }

    @NotNull
    public static final /* synthetic */ AtomicBoolean access$getSendingEnabled$p(RPCClientProxyHandler $this) {
        return $this.sendingEnabled;
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lnet/corda/client/rpc/internal/RPCClientProxyHandler$State;", "", "(Ljava/lang/String;I)V", "UNSTARTED", "SERVER_VERSION_NOT_SET", "STARTED", "FINISHED", "rpc"})
    private static final class State
    extends Enum<State> {
        public static final /* enum */ State UNSTARTED;
        public static final /* enum */ State SERVER_VERSION_NOT_SET;
        public static final /* enum */ State STARTED;
        public static final /* enum */ State FINISHED;
        private static final /* synthetic */ State[] $VALUES;

        static {
            State[] stateArray = new State[4];
            State[] stateArray2 = stateArray;
            stateArray[0] = UNSTARTED = new State();
            stateArray[1] = SERVER_VERSION_NOT_SET = new State();
            stateArray[2] = STARTED = new State();
            stateArray[3] = FINISHED = new State();
            $VALUES = stateArray;
        }

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String string) {
            return Enum.valueOf(State.class, string);
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B5\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0007J\u0012\u0010\b\u001a\u00020\u00042\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lnet/corda/client/rpc/internal/RPCClientProxyHandler$FailoverHandler;", "Lorg/apache/activemq/artemis/api/core/client/FailoverEventListener;", "detected", "Lkotlin/Function0;", "", "completed", "failed", "(Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)V", "failoverEvent", "eventType", "Lorg/apache/activemq/artemis/api/core/client/FailoverEventType;", "rpc"})
    public static final class FailoverHandler
    implements FailoverEventListener {
        private final Function0<Unit> detected;
        private final Function0<Unit> completed;
        private final Function0<Unit> failed;

        public void failoverEvent(@Nullable FailoverEventType eventType) {
            FailoverEventType failoverEventType = eventType;
            if (failoverEventType != null) {
                switch (RPCClientProxyHandler$FailoverHandler$WhenMappings.$EnumSwitchMapping$0[failoverEventType.ordinal()]) {
                    case 1: {
                        this.detected.invoke();
                        break;
                    }
                    case 2: {
                        this.completed.invoke();
                        break;
                    }
                    case 3: {
                        if (Companion.getTerminating()) break;
                        this.failed.invoke();
                    }
                }
            }
        }

        public FailoverHandler(@NotNull Function0<Unit> detected, @NotNull Function0<Unit> completed, @NotNull Function0<Unit> failed) {
            Intrinsics.checkParameterIsNotNull(detected, (String)"detected");
            Intrinsics.checkParameterIsNotNull(completed, (String)"completed");
            Intrinsics.checkParameterIsNotNull(failed, (String)"failed");
            this.detected = detected;
            this.completed = completed;
            this.failed = failed;
        }

        public /* synthetic */ FailoverHandler(Function0 function0, Function0 function02, Function0 function03, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                function0 = 1.INSTANCE;
            }
            if ((n & 2) != 0) {
                function02 = 2.INSTANCE;
            }
            if ((n & 4) != 0) {
                function03 = 3.INSTANCE;
            }
            this((Function0<Unit>)function0, (Function0<Unit>)function02, (Function0<Unit>)function03);
        }

        public FailoverHandler() {
            this(null, null, null, 7, null);
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u001a\u0010\u0019\u001a\u00020\u00142\u0010\u0010\u001a\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001c0\u001bH\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0006\u00a8\u0006\u001d"}, d2={"Lnet/corda/client/rpc/internal/RPCClientProxyHandler$Companion;", "", "()V", "equalsMethod", "Ljava/lang/reflect/Method;", "getEqualsMethod", "()Ljava/lang/reflect/Method;", "hashCodeMethod", "getHashCodeMethod", "log", "Lorg/slf4j/Logger;", "terminating", "", "getTerminating", "()Z", "setTerminating", "(Z)V", "toStringMethod", "getToStringMethod", "addRpcCallSiteToThrowable", "", "throwable", "", "callSite", "Lnet/corda/nodeapi/internal/rpc/client/CallSite;", "closeObservable", "observable", "Lrx/subjects/UnicastSubject;", "Lrx/Notification;", "rpc"})
    private static final class Companion {
        @NotNull
        public final Method getToStringMethod() {
            return toStringMethod;
        }

        @NotNull
        public final Method getEqualsMethod() {
            return equalsMethod;
        }

        @NotNull
        public final Method getHashCodeMethod() {
            return hashCodeMethod;
        }

        public final boolean getTerminating() {
            return terminating;
        }

        public final void setTerminating(boolean bl) {
            terminating = bl;
        }

        private final void addRpcCallSiteToThrowable(Throwable throwable, CallSite callSite) {
            Throwable currentThrowable = throwable;
            while (true) {
                Throwable cause;
                if ((cause = currentThrowable.getCause()) == null) {
                    try {
                        currentThrowable.initCause((Throwable)callSite);
                    }
                    catch (IllegalStateException illegalStateException) {}
                    break;
                }
                currentThrowable = cause;
            }
        }

        private final void closeObservable(UnicastSubject<Notification<?>> observable2) {
            try {
                observable2.onError((Throwable)((Object)new ConnectionFailureException(null, 1, null)));
            }
            catch (OnErrorNotImplementedException ex) {
                Logger $receiver$iv = log;
                if ($receiver$iv.isDebugEnabled()) {
                    Logger logger = $receiver$iv;
                    String string = "Closed connection on observable whose observers have no error handling.";
                    logger.debug(string);
                }
            }
            catch (Exception ex) {
                log.error("Unexpected exception when RPC connection failure handling", (Throwable)ex);
            }
        }

        private Companion() {
        }

        public static final /* synthetic */ void access$addRpcCallSiteToThrowable(Companion $this, @NotNull Throwable throwable, @NotNull CallSite callSite) {
            $this.addRpcCallSiteToThrowable(throwable, callSite);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

