/*
 * Decompiled with CFR 0.152.
 */
package net.corda.plugins;

import io.github.lukehutch.fastclasspathscanner.scanner.ClassInfo;
import io.github.lukehutch.fastclasspathscanner.scanner.FieldInfo;
import io.github.lukehutch.fastclasspathscanner.scanner.MethodInfo;
import io.github.lukehutch.fastclasspathscanner.typesignature.TypeSignature;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class ApiPrintWriter
extends PrintWriter {
    ApiPrintWriter(File file, String encoding) throws FileNotFoundException, UnsupportedEncodingException {
        super(file, encoding);
    }

    public void println(ClassInfo classInfo, int modifierMask, List<String> filteredAnnotations) {
        this.append(ApiPrintWriter.asAnnotations(filteredAnnotations, ""));
        this.append(Modifier.toString(classInfo.getClassRef().getModifiers() & modifierMask));
        if (classInfo.isAnnotation()) {
            this.append(" @interface ").print(classInfo.getClassName());
        } else if (classInfo.isStandardClass()) {
            Set interfaces;
            this.append(" class ").print(classInfo.getClassName());
            Set superclasses = classInfo.getDirectSuperclasses();
            if (!superclasses.isEmpty()) {
                this.append(" extends ").print(ApiPrintWriter.stringOf(superclasses));
            }
            if (!(interfaces = classInfo.getDirectlyImplementedInterfaces()).isEmpty()) {
                this.append(" implements ").print(ApiPrintWriter.stringOf(interfaces));
            }
        } else {
            this.append(" interface ").print(classInfo.getClassName());
            Set superinterfaces = classInfo.getDirectSuperinterfaces();
            if (!superinterfaces.isEmpty()) {
                this.append(" extends ").print(ApiPrintWriter.stringOf(superinterfaces));
            }
        }
        this.println();
    }

    public void println(MethodInfo method, String indentation) {
        this.append(ApiPrintWriter.asAnnotations(method.getAnnotationNames(), indentation));
        this.append(indentation);
        if (method.getModifiersStr() != null) {
            this.append(method.getModifiersStr()).append(' ');
        }
        if (!method.isConstructor()) {
            this.append(ApiPrintWriter.removeQualifierFromBaseTypes(method.getResultTypeStr())).append(' ');
        }
        this.append(method.getMethodName()).append('(');
        LinkedList paramTypes = method.getTypeSignature().getParameterTypeSignatures().stream().map(ApiPrintWriter::removeQualifierFromBaseTypes).collect(Collectors.toCollection(LinkedList::new));
        if (method.isVarArgs() && !paramTypes.isEmpty()) {
            String vararg = (String)paramTypes.removeLast();
            paramTypes.add(vararg.substring(0, vararg.length() - 2) + "...");
        }
        this.append(String.join((CharSequence)", ", paramTypes));
        this.println(')');
    }

    public void println(FieldInfo field, String indentation) {
        this.append(ApiPrintWriter.asAnnotations(field.getAnnotationNames(), indentation)).append(indentation).append(field.getModifierStr()).append(' ').append(ApiPrintWriter.removeQualifierFromBaseTypes(field.getTypeStr())).append(' ').append(field.getFieldName());
        if (field.getConstFinalValue() != null) {
            this.append(" = ");
            if (field.getConstFinalValue() instanceof String) {
                this.append('\"').append(field.getConstFinalValue().toString()).append('\"');
            } else if (field.getConstFinalValue() instanceof Character) {
                this.append('\'').append(field.getConstFinalValue().toString()).append('\'');
            } else {
                this.append(field.getConstFinalValue().toString());
            }
        }
        this.println();
    }

    private static String asAnnotations(Collection<String> items, String indentation) {
        if (items.isEmpty()) {
            return "";
        }
        return items.stream().map(ApiPrintWriter::removePackageName).collect(Collectors.joining(System.lineSeparator() + indentation + '@', indentation + '@', System.lineSeparator()));
    }

    private static String removePackageName(String className) {
        return className.substring(className.lastIndexOf(46) + 1);
    }

    private static String stringOf(Collection<ClassInfo> items) {
        return items.stream().map(ClassInfo::getClassName).collect(Collectors.joining(", "));
    }

    private static String removeQualifierFromBaseTypes(String className) {
        return className.replace("java.lang.", "");
    }

    private static String removeQualifierFromBaseTypes(TypeSignature typeSignature) {
        return ApiPrintWriter.removeQualifierFromBaseTypes(typeSignature.toString());
    }
}

