/*
 * Decompiled with CFR 0.152.
 */
package net.corda.plugins;

import javax.annotation.Nonnull;
import net.corda.plugins.GenerateApi;
import net.corda.plugins.ScanApi;
import net.corda.plugins.ScannerExtension;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.TaskCollection;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.jvm.tasks.Jar;

public class ApiScanner
implements Plugin<Project> {
    public void apply(@Nonnull Project project) {
        project.getLogger().info("Applying API scanner to {}", (Object)project.getName());
        ScannerExtension extension = (ScannerExtension)project.getExtensions().create("scanApi", ScannerExtension.class, new Object[0]);
        project.getLogger().info("Adding scanApi task to {}", (Object)project.getName());
        TaskProvider scanProvider = project.getTasks().register("scanApi", ScanApi.class, scanTask -> {
            TaskCollection jarTasks = project.getTasks().withType(Jar.class).matching(jarTask -> jarTask.getClassifier().isEmpty() && jarTask.isEnabled());
            ConfigurableFileCollection jarSources = project.files(new Object[]{jarTasks});
            scanTask.setClasspath(ApiScanner.compilationClasspath(project.getConfigurations()));
            scanTask.setSources((FileCollection)jarSources);
            scanTask.setExcludeClasses(extension.getExcludeClasses());
            scanTask.setExcludeMethods(extension.getExcludeMethods());
            scanTask.setVerbose(extension.isVerbose());
            scanTask.setEnabled(extension.isEnabled());
        });
        for (Project target = project; target != null; target = target.getParent()) {
            target.getTasks().withType(GenerateApi.class, generateTask -> generateTask.dependsOn(new Object[]{scanProvider}));
        }
    }

    private static FileCollection compilationClasspath(ConfigurationContainer configurations) {
        return configurations.getByName("compile").plus((FileCollection)configurations.getByName("compileOnly"));
    }
}

