/*
 * Decompiled with CFR 0.152.
 */
package net.corda.plugins;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Comparator;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.corda.plugins.ScanApi;
import org.gradle.api.DefaultTask;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.AbstractTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

public class GenerateApi
extends DefaultTask {
    private final File outputDir;
    private String baseName;
    private String version;

    public GenerateApi() {
        this.setGroup("Corda API");
        this.outputDir = new File(this.getProject().getBuildDir(), "api");
        this.baseName = "api-" + this.getProject().getName();
        this.version = this.getProject().getVersion().toString();
    }

    public void setBaseName(String baseName) {
        this.baseName = baseName;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @Input
    public String getBaseName() {
        return this.baseName;
    }

    @Input
    public String getVersion() {
        return this.version;
    }

    @InputFiles
    public FileCollection getSources() {
        return this.getProject().files(new Object[]{this.getProject().getAllprojects().stream().flatMap(project -> project.getTasks().withType(ScanApi.class).matching(AbstractTask::isEnabled).stream()).flatMap(scanTask -> scanTask.getTargets().getFiles().stream()).sorted(Comparator.comparing(File::getName)).collect(Collectors.toList())});
    }

    private StringBuilder appendVersion(@Nonnull StringBuilder builder) {
        if (!this.version.isEmpty()) {
            builder.append('-').append(this.version);
        }
        return builder;
    }

    @OutputFile
    public File getTarget() {
        String fileName = this.appendVersion(new StringBuilder(this.baseName)).append(".txt").toString();
        return new File(this.outputDir, fileName);
    }

    @TaskAction
    public void generate() {
        FileCollection apiFiles = this.getSources();
        try (BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(this.getTarget()));){
            for (File apiFile : apiFiles) {
                Files.copy(apiFile.toPath(), output);
            }
        }
        catch (IOException e) {
            this.getLogger().error("Failed to generate API file: {}", (Object)e.getMessage());
            throw new InvalidUserCodeException(e.getMessage(), (Throwable)e);
        }
    }
}

