/*
 * Decompiled with CFR 0.152.
 */
package net.corda.plugins;

import io.github.lukehutch.fastclasspathscanner.FastClasspathScanner;
import io.github.lukehutch.fastclasspathscanner.scanner.AnnotationInfo;
import io.github.lukehutch.fastclasspathscanner.scanner.ClassInfo;
import io.github.lukehutch.fastclasspathscanner.scanner.FieldInfo;
import io.github.lukehutch.fastclasspathscanner.scanner.MethodInfo;
import io.github.lukehutch.fastclasspathscanner.scanner.ScanResult;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.annotation.Inherited;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.corda.plugins.ApiPrintWriter;
import net.corda.plugins.Names;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.CompileClasspath;
import org.gradle.api.tasks.Console;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFiles;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;

public class ScanApi
extends DefaultTask {
    private static final int CLASS_MASK = Modifier.classModifiers();
    private static final int INTERFACE_MASK = Modifier.interfaceModifiers() & 0xFFFFFBFF;
    private static final int METHOD_MASK = Modifier.methodModifiers() | 0x80 | 0x1000;
    private static final int FIELD_MASK = Modifier.fieldModifiers();
    private static final int VISIBILITY_MASK = 5;
    private static final String DONOTIMPLEMENT_ANNOTATION_NAME = "net.corda.core.DoNotImplement";
    private static final String INTERNAL_ANNOTATION_NAME = ".CordaInternal";
    private static final String DEFAULT_INTERNAL_ANNOTATION = "net.corda.core.CordaInternal";
    private static final Set<String> ANNOTATION_BLACKLIST;
    private static final String KOTLIN_METADATA = "kotlin.Metadata";
    private static final String KOTLIN_CLASSTYPE_METHOD = "k";
    private static final int KOTLIN_SYNTHETIC = 3;
    private final ConfigurableFileCollection sources = this.getProject().files(new Object[0]);
    private final ConfigurableFileCollection classpath = this.getProject().files(new Object[0]);
    private final Set<String> excludeClasses = new LinkedHashSet<String>();
    private final Map<String, Set<String>> excludeMethods = new LinkedHashMap<String, Set<String>>();
    private final File outputDir = new File(this.getProject().getBuildDir(), "api");
    private boolean verbose;

    @SkipWhenEmpty
    @InputFiles
    public FileCollection getSources() {
        return this.sources;
    }

    void setSources(FileCollection sources) {
        this.sources.setFrom((Iterable)sources);
    }

    @CompileClasspath
    @InputFiles
    public FileCollection getClasspath() {
        return this.classpath;
    }

    void setClasspath(FileCollection classpath) {
        this.classpath.setFrom((Iterable)classpath);
    }

    @Input
    public Collection<String> getExcludeClasses() {
        return Collections.unmodifiableSet(this.excludeClasses);
    }

    void setExcludeClasses(Collection<String> excludeClasses) {
        this.excludeClasses.clear();
        this.excludeClasses.addAll(excludeClasses);
    }

    @Input
    public Map<String, Collection<String>> getExcludeMethods() {
        return Collections.unmodifiableMap(this.excludeMethods);
    }

    void setExcludeMethods(Map<String, ? extends Collection<String>> excludeMethods) {
        this.excludeMethods.clear();
        excludeMethods.forEach((key, value) -> {
            Set cfr_ignored_0 = this.excludeMethods.put((String)key, new LinkedHashSet(value));
        });
    }

    @OutputFiles
    public FileCollection getTargets() {
        return this.getProject().files(new Object[]{StreamSupport.stream(this.sources.spliterator(), false).map(this::toTarget).collect(Collectors.toList())});
    }

    @Console
    public boolean isVerbose() {
        return this.verbose;
    }

    void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    private File toTarget(File source) {
        return new File(this.outputDir, source.getName().replaceAll("\\.jar$", ".txt"));
    }

    @TaskAction
    public void scan() {
        try (Scanner scanner = new Scanner((FileCollection)this.classpath);){
            for (File source : this.sources) {
                scanner.scan(source);
            }
        }
        catch (IOException e) {
            this.getLogger().error("Failed to write API file", (Throwable)e);
        }
    }

    private static <T extends Comparable<? super T>> List<T> ordering(List<T> list) {
        Collections.sort(list);
        return list;
    }

    private static boolean isKotlinInternalScope(MethodInfo method) {
        return method.getMethodName().indexOf(36) >= 0;
    }

    private static boolean isValid(int modifiers, int mask) {
        return (modifiers & mask) == modifiers;
    }

    private boolean isExcluded(MethodInfo methodWithoutAnnotations) {
        String methodSignature = methodWithoutAnnotations.getMethodName() + methodWithoutAnnotations.getTypeDescriptorStr();
        String className = methodWithoutAnnotations.getClassName();
        return this.excludeMethods.containsKey(className) && this.excludeMethods.get(className).contains(methodSignature);
    }

    private static boolean isVisible(int accessFlags) {
        return (accessFlags & 5) != 0;
    }

    private static boolean isApplicationClass(String typeName) {
        return !typeName.startsWith("java.") && !typeName.startsWith("kotlin.");
    }

    private static URL toURL(File file) throws MalformedURLException {
        return file.toURI().toURL();
    }

    private static URL[] toURLs(Iterable<File> files) throws MalformedURLException {
        LinkedList<URL> urls = new LinkedList<URL>();
        for (File file : files) {
            urls.add(ScanApi.toURL(file));
        }
        return urls.toArray(new URL[0]);
    }

    static {
        LinkedHashSet<String> blacklist = new LinkedHashSet<String>();
        blacklist.add("kotlin.jvm.JvmField");
        blacklist.add("kotlin.jvm.JvmOverloads");
        blacklist.add("kotlin.jvm.JvmStatic");
        blacklist.add("kotlin.jvm.JvmDefault");
        blacklist.add("kotlin.Deprecated");
        blacklist.add("java.lang.Deprecated");
        blacklist.add(DEFAULT_INTERNAL_ANNOTATION);
        ANNOTATION_BLACKLIST = Collections.unmodifiableSet(blacklist);
    }

    class Scanner
    implements Closeable {
        private final URLClassLoader classpathLoader;
        private final Class<? extends Annotation> metadataClass;
        private final Method classTypeMethod;
        private Collection<String> internalAnnotations;
        private Collection<String> invisibleAnnotations;
        private Collection<String> inheritedAnnotations;

        Scanner(URLClassLoader classpathLoader) {
            Method kMethod;
            Class<?> kClass;
            this.classpathLoader = classpathLoader;
            this.invisibleAnnotations = ANNOTATION_BLACKLIST;
            this.inheritedAnnotations = Collections.emptySet();
            this.internalAnnotations = Collections.emptySet();
            try {
                kClass = Class.forName(ScanApi.KOTLIN_METADATA, true, classpathLoader);
                kMethod = kClass.getDeclaredMethod(ScanApi.KOTLIN_CLASSTYPE_METHOD, new Class[0]);
            }
            catch (ClassNotFoundException | NoSuchMethodException e) {
                kClass = null;
                kMethod = null;
            }
            this.metadataClass = kClass;
            this.classTypeMethod = kMethod;
        }

        Scanner(FileCollection classpath) throws MalformedURLException {
            this(new URLClassLoader(ScanApi.toURLs((Iterable)classpath)));
        }

        @Override
        public void close() throws IOException {
            this.classpathLoader.close();
        }

        void scan(File source) {
            File target = ScanApi.this.toTarget(source);
            ScanApi.this.getLogger().info("API file: {}", (Object)target.getAbsolutePath());
            try (URLClassLoader appLoader = new URLClassLoader(new URL[]{ScanApi.toURL(source)}, (ClassLoader)this.classpathLoader);
                 ApiPrintWriter writer = new ApiPrintWriter(target, "UTF-8");){
                this.scan(writer, appLoader);
            }
            catch (IOException e) {
                ScanApi.this.getLogger().error("API scan has failed", (Throwable)e);
            }
        }

        void scan(ApiPrintWriter writer, ClassLoader appLoader) {
            HashSet inherited = new HashSet();
            ScanResult result = new FastClasspathScanner(this.getScanSpecification()).matchAllAnnotationClasses(annotation -> {
                if (annotation.isAnnotationPresent(Inherited.class)) {
                    inherited.add(annotation.getName());
                }
            }).overrideClassLoaders(new ClassLoader[]{appLoader}).ignoreParentClassLoaders().ignoreMethodVisibility().ignoreFieldVisibility().enableMethodInfo().enableFieldInfo().verbose(ScanApi.this.verbose).scan();
            this.inheritedAnnotations = Collections.unmodifiableSet(inherited);
            this.loadAnnotationCaches(result);
            ScanApi.this.getLogger().info("Annotations:");
            ScanApi.this.getLogger().info("- Inherited: {}", this.inheritedAnnotations);
            ScanApi.this.getLogger().info("- Internal:  {}", this.internalAnnotations);
            ScanApi.this.getLogger().info("- Invisible: {}", this.invisibleAnnotations);
            this.writeApis(writer, result);
        }

        private String[] getScanSpecification() {
            String[] spec = new String[2 + ScanApi.this.excludeClasses.size()];
            spec[0] = "!";
            spec[1] = "-dir:";
            int i = 2;
            for (String excludeClass : ScanApi.this.excludeClasses) {
                spec[i++] = '-' + excludeClass;
            }
            return spec;
        }

        private void loadAnnotationCaches(ScanResult result) {
            Set internal = result.getNamesOfAllAnnotationClasses().stream().filter(s -> s.endsWith(ScanApi.INTERNAL_ANNOTATION_NAME)).collect(Collectors.toCollection(LinkedHashSet::new));
            internal.add(ScanApi.DEFAULT_INTERNAL_ANNOTATION);
            this.internalAnnotations = Collections.unmodifiableSet(internal);
            Set invisible = this.internalAnnotations.stream().flatMap(a -> result.getNamesOfAnnotationsWithMetaAnnotation(a).stream()).collect(Collectors.toCollection(LinkedHashSet::new));
            invisible.addAll(ANNOTATION_BLACKLIST);
            invisible.addAll(internal);
            this.invisibleAnnotations = Collections.unmodifiableSet(invisible);
        }

        private void writeApis(ApiPrintWriter writer, ScanResult result) {
            Map allInfo = result.getClassNameToClassInfo();
            result.getNamesOfAllClasses().forEach(className -> {
                if (className.contains(".internal.")) {
                    return;
                }
                ClassInfo classInfo = (ClassInfo)allInfo.get(className);
                if (classInfo.getClassLoaders() == null) {
                    return;
                }
                if (classInfo.isAnnotation() && !this.isVisibleAnnotation((String)className)) {
                    return;
                }
                Class javaClass = result.classNameToClassRef(className);
                if (!ScanApi.isVisible(javaClass.getModifiers())) {
                    return;
                }
                if (classInfo.getFullyQualifiedContainingMethodName() != null) {
                    return;
                }
                int kotlinClassType = this.getKotlinClassType(javaClass);
                if (kotlinClassType == 3) {
                    return;
                }
                this.writeClass(writer, classInfo);
                this.writeMethods(writer, classInfo.getMethodAndConstructorInfo());
                this.writeFields(writer, classInfo.getFieldInfo());
                writer.println("##");
            });
        }

        private void writeClass(ApiPrintWriter writer, ClassInfo classInfo) {
            if (classInfo.isAnnotation()) {
                writer.println(classInfo, INTERFACE_MASK, Collections.emptyList());
            } else if (classInfo.isStandardClass()) {
                writer.println(classInfo, CLASS_MASK, this.toNames(this.readClassAnnotationsFor((ClassInfo)classInfo)).visible);
            } else {
                writer.println(classInfo, INTERFACE_MASK, this.toNames(this.readInterfaceAnnotationsFor((ClassInfo)classInfo)).visible);
            }
        }

        private void writeMethods(ApiPrintWriter writer, List<MethodInfo> methods) {
            Collections.sort(methods);
            for (MethodInfo method : methods) {
                if (!ScanApi.isVisible(method.getModifiers()) || ScanApi.this.isExcluded(this.filterAnnotationsFor(method)) || !ScanApi.isValid(method.getModifiers(), METHOD_MASK) || this.hasInternalAnnotation(method.getAnnotationNames()) || ScanApi.isKotlinInternalScope(method)) continue;
                writer.println(this.filterAnnotationsFor(method), "  ");
            }
        }

        private void writeFields(ApiPrintWriter writer, List<FieldInfo> fields) {
            Collections.sort(fields);
            for (FieldInfo field : fields) {
                if (!ScanApi.isVisible(field.getModifiers()) || !ScanApi.isValid(field.getModifiers(), FIELD_MASK) || this.hasInternalAnnotation(field.getAnnotationNames())) continue;
                writer.println(this.filterAnnotationsFor(field), "  ");
            }
        }

        private int getKotlinClassType(Class<?> javaClass) {
            Annotation metadata;
            if (this.metadataClass != null && (metadata = javaClass.getAnnotation(this.metadataClass)) != null) {
                try {
                    return (Integer)this.classTypeMethod.invoke((Object)metadata, new Object[0]);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    ScanApi.this.getLogger().error("Failed to read Kotlin annotation", (Throwable)e);
                }
            }
            return 0;
        }

        private Names toNames(Collection<ClassInfo> classes) {
            Map<Boolean, List> partitioned = classes.stream().map(ClassInfo::getClassName).filter(x$0 -> ScanApi.isApplicationClass(x$0)).collect(Collectors.partitioningBy(this::isVisibleAnnotation, Collectors.toCollection(ArrayList::new)));
            List visible = partitioned.get(true);
            int idx = visible.indexOf(ScanApi.DONOTIMPLEMENT_ANNOTATION_NAME);
            if (idx != -1) {
                Collections.swap(visible, 0, idx);
                Collections.sort(visible.subList(1, visible.size()));
            } else {
                Collections.sort(visible);
            }
            return new Names(visible, ScanApi.ordering(partitioned.get(false)));
        }

        private Set<ClassInfo> readClassAnnotationsFor(ClassInfo classInfo) {
            HashSet<ClassInfo> annotations = new HashSet<ClassInfo>(classInfo.getAnnotations());
            annotations.addAll(this.selectInheritedAnnotations(classInfo.getSuperclasses()));
            annotations.addAll(this.selectInheritedAnnotations(classInfo.getImplementedInterfaces()));
            return annotations;
        }

        private Set<ClassInfo> readInterfaceAnnotationsFor(ClassInfo classInfo) {
            HashSet<ClassInfo> annotations = new HashSet<ClassInfo>(classInfo.getAnnotations());
            annotations.addAll(this.selectInheritedAnnotations(classInfo.getSuperinterfaces()));
            return annotations;
        }

        private List<ClassInfo> selectInheritedAnnotations(Collection<ClassInfo> classes) {
            return classes.stream().flatMap(cls -> cls.getAnnotations().stream()).filter(ann -> this.inheritedAnnotations.contains(ann.getClassName())).collect(Collectors.toList());
        }

        private MethodInfo filterAnnotationsFor(MethodInfo method) {
            return new MethodInfo(method.getClassName(), method.getMethodName(), method.getAnnotationInfo().stream().filter(this::isVisibleAnnotation).sorted().collect(Collectors.toList()), method.getModifiers(), method.getTypeDescriptorStr(), method.getTypeSignatureStr(), method.getParameterNames(), method.getParameterModifiers(), method.getParameterAnnotationInfo());
        }

        private FieldInfo filterAnnotationsFor(FieldInfo field) {
            return new FieldInfo(field.getClassName(), field.getFieldName(), field.getModifiers(), field.getTypeDescriptorStr(), field.getTypeSignatureStr(), field.getConstFinalValue(), field.getAnnotationInfo().stream().filter(this::isVisibleAnnotation).sorted().collect(Collectors.toList()));
        }

        private boolean isVisibleAnnotation(AnnotationInfo annotation) {
            return this.isVisibleAnnotation(annotation.getAnnotationName());
        }

        private boolean isVisibleAnnotation(String className) {
            return !this.invisibleAnnotations.contains(className);
        }

        private boolean hasInternalAnnotation(Collection<String> annotationNames) {
            return annotationNames.stream().anyMatch(this.internalAnnotations::contains);
        }
    }
}

