/*
 * Decompiled with CFR 0.152.
 */
package net.devh.boot.grpc.common.codec;

import com.google.common.collect.ImmutableList;
import io.grpc.Codec;
import java.util.Collection;
import net.devh.boot.grpc.common.codec.GrpcCodec;
import net.devh.boot.grpc.common.codec.GrpcCodecDefinition;
import net.devh.boot.grpc.common.codec.GrpcCodecDiscoverer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class AnnotationGrpcCodecDiscoverer
implements ApplicationContextAware,
GrpcCodecDiscoverer {
    private static final Logger log = LoggerFactory.getLogger(AnnotationGrpcCodecDiscoverer.class);
    private ApplicationContext applicationContext;
    private Collection<GrpcCodecDefinition> definitions;

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Override
    public Collection<GrpcCodecDefinition> findGrpcCodecs() {
        if (this.definitions == null) {
            log.debug("Searching for codecs...");
            String[] beanNames = this.applicationContext.getBeanNamesForAnnotation(GrpcCodec.class);
            ImmutableList.Builder builder = ImmutableList.builder();
            for (String beanName : beanNames) {
                Codec codec = (Codec)this.applicationContext.getBean(beanName, Codec.class);
                GrpcCodec annotation = (GrpcCodec)this.applicationContext.findAnnotationOnBean(beanName, GrpcCodec.class);
                builder.add((Object)new GrpcCodecDefinition(codec, annotation.advertised(), annotation.codecType()));
                log.debug("Found gRPC codec: {}, bean: {}, class: {}", new Object[]{codec.getMessageEncoding(), beanName, codec.getClass().getName()});
            }
            this.definitions = builder.build();
            log.debug("Done");
        }
        return this.definitions;
    }
}

