/*
 * Decompiled with CFR 0.152.
 */
package com.sap.olingo.jpa.processor.core.api;

import com.sap.olingo.jpa.processor.core.api.JPAODataRequestContextAccess;
import com.sap.olingo.jpa.processor.core.api.JPAODataTransactionFactory;
import com.sap.olingo.jpa.processor.core.exception.ODataJPAProcessorException;
import com.sap.olingo.jpa.processor.core.exception.ODataJPATransactionException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.persistence.OptimisticLockException;
import javax.persistence.RollbackException;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.commons.api.http.HttpStatusCode;
import org.apache.olingo.server.api.OData;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.ODataLibraryException;
import org.apache.olingo.server.api.ODataRequest;
import org.apache.olingo.server.api.ODataResponse;
import org.apache.olingo.server.api.ServiceMetadata;
import org.apache.olingo.server.api.batch.BatchFacade;
import org.apache.olingo.server.api.deserializer.batch.BatchOptions;
import org.apache.olingo.server.api.deserializer.batch.BatchRequestPart;
import org.apache.olingo.server.api.deserializer.batch.ODataResponsePart;
import org.apache.olingo.server.api.processor.BatchProcessor;

public final class JPAODataBatchProcessor
implements BatchProcessor {
    private final JPAODataRequestContextAccess requestContext;
    private OData odata;

    public JPAODataBatchProcessor(JPAODataRequestContextAccess requestContext) {
        this.requestContext = requestContext;
    }

    public void init(OData odata, ServiceMetadata serviceMetadata) {
        this.odata = odata;
    }

    public void processBatch(BatchFacade facade, ODataRequest request, ODataResponse response) throws ODataApplicationException, ODataLibraryException {
        int handle = this.requestContext.getDebugger().startRuntimeMeasurement(this, "processBatch");
        String boundary = facade.extractBoundaryFromContentType(request.getHeader("Content-Type"));
        BatchOptions options = BatchOptions.with().rawBaseUri(request.getRawBaseUri()).rawServiceResolutionUri(request.getRawServiceResolutionUri()).build();
        List requestParts = this.odata.createFixedFormatDeserializer().parseBatchRequest(request.getBody(), boundary, options);
        ArrayList<ODataResponsePart> responseParts = new ArrayList<ODataResponsePart>();
        for (BatchRequestPart part : requestParts) {
            responseParts.add(facade.handleBatchRequest(part));
        }
        String responseBoundary = "batch_" + UUID.randomUUID().toString();
        InputStream responseContent = this.odata.createFixedFormatSerializer().batchResponse(responseParts, responseBoundary);
        response.setHeader("Content-Type", ContentType.MULTIPART_MIXED + ";boundary=" + responseBoundary);
        response.setContent(responseContent);
        response.setStatusCode(HttpStatusCode.ACCEPTED.getStatusCode());
        this.requestContext.getDebugger().stopRuntimeMeasurement(handle);
    }

    public ODataResponsePart processChangeSet(BatchFacade facade, List<ODataRequest> requests) throws ODataApplicationException, ODataLibraryException {
        int handle = this.requestContext.getDebugger().startRuntimeMeasurement(this, "processChangeSet");
        ArrayList<ODataResponse> responses = new ArrayList<ODataResponse>();
        try {
            JPAODataTransactionFactory.JPAODataTransaction t = this.requestContext.getTransactionFactory().createTransaction();
            try {
                for (ODataRequest request : requests) {
                    ODataResponse response = facade.handleODataRequest(request);
                    int statusCode = response.getStatusCode();
                    if (statusCode < 400) {
                        responses.add(response);
                        continue;
                    }
                    t.rollback();
                    this.requestContext.getDebugger().stopRuntimeMeasurement(handle);
                    return new ODataResponsePart(response, false);
                }
                this.requestContext.getCUDRequestHandler().validateChanges(this.requestContext.getEntityManager());
                t.commit();
                this.requestContext.getDebugger().stopRuntimeMeasurement(handle);
                return new ODataResponsePart(responses, true);
            }
            catch (ODataApplicationException e) {
                t.rollback();
                this.requestContext.getDebugger().stopRuntimeMeasurement(handle);
                throw e;
            }
            catch (ODataLibraryException e) {
                t.rollback();
                this.requestContext.getDebugger().stopRuntimeMeasurement(handle);
                throw e;
            }
            catch (RollbackException e) {
                if (e.getCause() instanceof OptimisticLockException) {
                    this.requestContext.getDebugger().stopRuntimeMeasurement(handle);
                    throw new ODataJPAProcessorException(e.getCause().getCause(), HttpStatusCode.PRECONDITION_FAILED);
                }
                this.requestContext.getDebugger().stopRuntimeMeasurement(handle);
                throw new ODataJPAProcessorException(e, HttpStatusCode.INTERNAL_SERVER_ERROR);
            }
        }
        catch (ODataJPATransactionException e) {
            throw new ODataJPAProcessorException((Throwable)((Object)e), HttpStatusCode.NOT_IMPLEMENTED);
        }
    }
}

