/*
 * Decompiled with CFR 0.152.
 */
package com.sap.olingo.jpa.processor.core.api;

import com.sap.olingo.jpa.processor.core.api.JPAODataTransactionFactory;
import com.sap.olingo.jpa.processor.core.exception.ODataJPATransactionException;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.RollbackException;

public class JPAODataDefaultTransactionFactory
implements JPAODataTransactionFactory {
    private final EntityManager em;
    private JPAODataTransactionFactory.JPAODataTransaction currentTransaction;

    public JPAODataDefaultTransactionFactory(@Nonnull EntityManager em) {
        this.em = Objects.requireNonNull(em);
    }

    @Override
    public JPAODataTransactionFactory.JPAODataTransaction createTransaction() throws ODataJPATransactionException {
        try {
            if (this.currentTransaction != null && this.currentTransaction.isActive()) {
                throw new ODataJPATransactionException(ODataJPATransactionException.MessageKeys.CANNOT_CREATE_NEW_TRANSACTION);
            }
            this.currentTransaction = new JPAODataEntityTransaction(this.em.getTransaction());
            return this.currentTransaction;
        }
        catch (Exception e) {
            throw new ODataJPATransactionException(ODataJPATransactionException.MessageKeys.CANNOT_CREATE_NEW_TRANSACTION);
        }
    }

    @Override
    public boolean hasActiveTransaction() {
        try {
            boolean baseActive = this.em.getTransaction().isActive();
            if (this.currentTransaction == null && !baseActive) {
                return false;
            }
            if (this.currentTransaction == null) {
                return true;
            }
            return this.currentTransaction.isActive();
        }
        catch (ODataJPATransactionException | RuntimeException e) {
            return true;
        }
    }

    private class JPAODataEntityTransaction
    implements JPAODataTransactionFactory.JPAODataTransaction {
        private final EntityTransaction et;

        public JPAODataEntityTransaction(EntityTransaction et) {
            this.et = et;
            this.et.begin();
        }

        @Override
        public void commit() throws ODataJPATransactionException {
            try {
                this.et.commit();
            }
            catch (RollbackException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new ODataJPATransactionException(e);
            }
        }

        @Override
        public void rollback() throws ODataJPATransactionException {
            try {
                this.et.rollback();
            }
            catch (RuntimeException e) {
                throw new ODataJPATransactionException(e);
            }
        }

        @Override
        public boolean isActive() throws ODataJPATransactionException {
            try {
                return this.et.isActive();
            }
            catch (RuntimeException e) {
                throw new ODataJPATransactionException(e);
            }
        }

        @Override
        public boolean rollbackOnly() throws ODataJPATransactionException {
            try {
                return this.et.getRollbackOnly();
            }
            catch (RuntimeException e) {
                throw new ODataJPATransactionException(e);
            }
        }
    }
}

