/*
 * Decompiled with CFR 0.152.
 */
package com.sap.olingo.jpa.processor.core.api;

import com.sap.olingo.jpa.metadata.api.JPAEdmProvider;
import com.sap.olingo.jpa.metadata.api.JPAEntityManagerFactory;
import com.sap.olingo.jpa.processor.core.api.JPAODataBatchProcessor;
import com.sap.olingo.jpa.processor.core.api.JPAODataCRUDContextAccess;
import com.sap.olingo.jpa.processor.core.api.JPAODataClaimProvider;
import com.sap.olingo.jpa.processor.core.api.JPAODataGetContext;
import com.sap.olingo.jpa.processor.core.api.JPAODataRequestContext;
import com.sap.olingo.jpa.processor.core.api.JPAODataRequestProcessor;
import com.sap.olingo.jpa.processor.core.api.JPAODataServiceContext;
import com.sap.olingo.jpa.processor.core.api.JPAODataServiceDocumentProcessor;
import com.sap.olingo.jpa.processor.core.processor.JPAODataRequestContextImpl;
import java.util.Optional;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.metamodel.Metamodel;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import org.apache.olingo.commons.api.edm.provider.CsdlEdmProvider;
import org.apache.olingo.commons.api.ex.ODataException;
import org.apache.olingo.server.api.OData;
import org.apache.olingo.server.api.ODataHttpHandler;
import org.apache.olingo.server.api.debug.DebugSupport;
import org.apache.olingo.server.api.etag.CustomETagSupport;
import org.apache.olingo.server.api.processor.Processor;

public class JPAODataGetHandler {
    private static final String REQUEST_MAPPING_ATTRIBUTE = "requestMapping";
    public final Optional<EntityManagerFactory> emf;
    private final JPAODataServiceContext serviceContext;
    private final JPAODataRequestContextImpl requestContext;
    final OData odata;
    @Deprecated
    final DataSource ds;
    @Deprecated
    final String namespace;
    @Deprecated
    final Metamodel jpaMetamodel;

    @Deprecated
    public JPAODataGetHandler(String pUnit) throws ODataException {
        this(pUnit, (DataSource)null);
    }

    @Deprecated
    public JPAODataGetHandler(String pUnit, DataSource ds) throws ODataException {
        this.namespace = pUnit;
        this.ds = ds;
        this.emf = ds != null ? Optional.ofNullable(JPAEntityManagerFactory.getEntityManagerFactory((String)pUnit, (DataSource)ds)) : Optional.empty();
        this.jpaMetamodel = this.emf.isPresent() ? this.emf.get().getMetamodel() : null;
        this.serviceContext = new JPAODataServiceContext(this);
        this.requestContext = new JPAODataRequestContextImpl();
        this.odata = OData.newInstance();
    }

    public JPAODataGetHandler(JPAODataCRUDContextAccess serviceContext) {
        this(serviceContext, OData.newInstance());
    }

    JPAODataGetHandler(JPAODataCRUDContextAccess serviceContext, OData odata) {
        this.namespace = null;
        this.ds = null;
        this.emf = serviceContext.getEntityManagerFactory();
        this.jpaMetamodel = null;
        this.serviceContext = (JPAODataServiceContext)serviceContext;
        this.requestContext = new JPAODataRequestContextImpl();
        this.odata = odata;
    }

    public JPAODataGetContext getJPAODataContext() {
        return this.serviceContext;
    }

    public JPAODataRequestContext getJPAODataRequestContext() {
        return this.requestContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(HttpServletRequest request, HttpServletResponse response) throws ODataException {
        if (this.emf.isPresent() && this.requestContext.getEntityManager() == null) {
            try (EntityManager em = this.emf.get().createEntityManager();){
                this.requestContext.setEntityManager(em);
                this.processInternal(request, response);
            }
        } else {
            this.processInternal(request, response);
        }
    }

    @Deprecated
    public void process(HttpServletRequest request, HttpServletResponse response, EntityManager em) throws ODataException {
        this.requestContext.setEntityManager(em);
        this.process(request, response);
    }

    @Deprecated
    public void process(HttpServletRequest request, HttpServletResponse response, JPAODataClaimProvider claims, EntityManager em) throws ODataException {
        this.requestContext.setClaimsProvider(claims);
        this.requestContext.setEntityManager(em);
        this.process(request, response);
    }

    private void processInternal(HttpServletRequest request, HttpServletResponse response) throws ODataException {
        JPAEdmProvider jpaEdm = this.serviceContext.getEdmProvider() == null && this.serviceContext instanceof JPAODataServiceContext ? this.serviceContext.getEdmProvider(this.requestContext.getEntityManager()) : this.serviceContext.getEdmProvider();
        ODataHttpHandler handler = this.odata.createHandler(this.odata.createServiceMetadata((CsdlEdmProvider)jpaEdm, jpaEdm.getReferences()));
        this.serviceContext.getEdmProvider().setRequestLocales(request.getLocales());
        this.requestContext.setDebugFormat(request.getParameter("odata-debug"));
        this.setCUDHandler();
        HttpServletRequest mappedRequest = this.prepareRequestMapping(request, this.serviceContext.getMappingPath());
        handler.register((DebugSupport)this.requestContext.getDebugSupport());
        handler.register((Processor)new JPAODataRequestProcessor(this.serviceContext, this.requestContext));
        handler.register((Processor)new JPAODataBatchProcessor(this.requestContext));
        handler.register((CustomETagSupport)this.serviceContext.getEdmProvider().getServiceDocument());
        handler.register((Processor)this.serviceContext.getErrorProcessor());
        handler.register((Processor)new JPAODataServiceDocumentProcessor(this.serviceContext));
        handler.process(mappedRequest, response);
    }

    private void setCUDHandler() {
        if (this.serviceContext.getCUDRequestHandler() != null && this.requestContext.getCUDRequestHandler() == null) {
            this.requestContext.setCUDRequestHandler(this.serviceContext.getCUDRequestHandler());
        }
    }

    private HttpServletRequest prepareRequestMapping(HttpServletRequest req, String requestPath) {
        if (requestPath != null && !requestPath.isEmpty()) {
            HttpServletRequestWrapper request = new HttpServletRequestWrapper(req);
            request.setAttribute(REQUEST_MAPPING_ATTRIBUTE, (Object)requestPath);
            return request;
        }
        return req;
    }
}

