/*
 * Decompiled with CFR 0.152.
 */
package com.sap.olingo.jpa.processor.core.api;

import com.sap.olingo.jpa.processor.core.api.JPAODataCRUDContextAccess;
import com.sap.olingo.jpa.processor.core.api.JPAODataRequestContextAccess;
import com.sap.olingo.jpa.processor.core.exception.ODataJPAProcessorException;
import com.sap.olingo.jpa.processor.core.processor.JPAActionRequestProcessor;
import com.sap.olingo.jpa.processor.core.processor.JPACUDRequestProcessor;
import com.sap.olingo.jpa.processor.core.processor.JPAProcessorFactory;
import com.sap.olingo.jpa.processor.core.processor.JPARequestProcessor;
import javax.persistence.OptimisticLockException;
import javax.persistence.RollbackException;
import org.apache.olingo.commons.api.ex.ODataException;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.commons.api.http.HttpStatusCode;
import org.apache.olingo.server.api.OData;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.ODataLibraryException;
import org.apache.olingo.server.api.ODataRequest;
import org.apache.olingo.server.api.ODataResponse;
import org.apache.olingo.server.api.ServiceMetadata;
import org.apache.olingo.server.api.processor.ActionPrimitiveProcessor;
import org.apache.olingo.server.api.processor.ActionVoidProcessor;
import org.apache.olingo.server.api.processor.ComplexCollectionProcessor;
import org.apache.olingo.server.api.processor.ComplexProcessor;
import org.apache.olingo.server.api.processor.CountEntityCollectionProcessor;
import org.apache.olingo.server.api.processor.EntityProcessor;
import org.apache.olingo.server.api.processor.MediaEntityProcessor;
import org.apache.olingo.server.api.processor.PrimitiveCollectionProcessor;
import org.apache.olingo.server.api.processor.PrimitiveValueProcessor;
import org.apache.olingo.server.api.uri.UriInfo;

public final class JPAODataRequestProcessor
implements PrimitiveValueProcessor,
PrimitiveCollectionProcessor,
ComplexProcessor,
ComplexCollectionProcessor,
CountEntityCollectionProcessor,
EntityProcessor,
MediaEntityProcessor,
ActionPrimitiveProcessor,
ActionVoidProcessor {
    private final JPAODataCRUDContextAccess sessionContext;
    private final JPAODataRequestContextAccess requestContext;
    private JPAProcessorFactory factory;

    public JPAODataRequestProcessor(JPAODataCRUDContextAccess sessionContext, JPAODataRequestContextAccess requestContext) {
        this.sessionContext = sessionContext;
        this.requestContext = requestContext;
    }

    public void init(OData odata, ServiceMetadata serviceMetadata) {
        this.factory = new JPAProcessorFactory(odata, serviceMetadata, this.sessionContext);
    }

    public void countEntityCollection(ODataRequest request, ODataResponse response, UriInfo uriInfo) throws ODataApplicationException, ODataLibraryException {
        try {
            JPARequestProcessor p = this.factory.createProcessor(uriInfo, ContentType.TEXT_PLAIN, request.getAllHeaders(), this.requestContext);
            p.retrieveData(request, response, ContentType.TEXT_PLAIN);
        }
        catch (ODataApplicationException | ODataLibraryException e) {
            throw e;
        }
        catch (ODataException e) {
            throw new ODataApplicationException(e.getLocalizedMessage(), HttpStatusCode.INTERNAL_SERVER_ERROR.getStatusCode(), null, (Throwable)e);
        }
    }

    public void createEntity(ODataRequest request, ODataResponse response, UriInfo uriInfo, ContentType requestFormat, ContentType responseFormat) throws ODataApplicationException, ODataLibraryException {
        try {
            JPACUDRequestProcessor p = this.factory.createCUDRequestProcessor(uriInfo, responseFormat, this.requestContext, request.getAllHeaders());
            p.createEntity(request, response, requestFormat, responseFormat);
        }
        catch (ODataApplicationException | ODataLibraryException e) {
            throw e;
        }
        catch (ODataException e) {
            throw new ODataApplicationException(e.getLocalizedMessage(), HttpStatusCode.INTERNAL_SERVER_ERROR.getStatusCode(), null, (Throwable)e);
        }
    }

    public void createMediaEntity(ODataRequest request, ODataResponse response, UriInfo uriInfo, ContentType requestFormat, ContentType responseFormat) throws ODataApplicationException, ODataLibraryException {
        throw new ODataJPAProcessorException(ODataJPAProcessorException.MessageKeys.NOT_SUPPORTED_CREATE, HttpStatusCode.NOT_IMPLEMENTED);
    }

    public void deleteComplex(ODataRequest request, ODataResponse response, UriInfo uriInfo) throws ODataApplicationException, ODataLibraryException {
        try {
            JPACUDRequestProcessor p = this.factory.createCUDRequestProcessor(uriInfo, this.requestContext);
            p.clearFields(request, response);
        }
        catch (ODataApplicationException | ODataLibraryException e) {
            throw e;
        }
        catch (ODataException e) {
            throw new ODataJPAProcessorException(ODataJPAProcessorException.MessageKeys.NOT_SUPPORTED_DELETE, HttpStatusCode.NOT_IMPLEMENTED);
        }
    }

    public void deleteEntity(ODataRequest request, ODataResponse response, UriInfo uriInfo) throws ODataApplicationException, ODataLibraryException {
        try {
            JPACUDRequestProcessor p = this.factory.createCUDRequestProcessor(uriInfo, this.requestContext);
            p.deleteEntity(request, response);
        }
        catch (ODataApplicationException | ODataLibraryException e) {
            throw e;
        }
        catch (ODataException e) {
            throw new ODataApplicationException(e.getLocalizedMessage(), HttpStatusCode.INTERNAL_SERVER_ERROR.getStatusCode(), null, (Throwable)e);
        }
    }

    public void deletePrimitive(ODataRequest request, ODataResponse response, UriInfo uriInfo) throws ODataApplicationException, ODataLibraryException {
        try {
            JPACUDRequestProcessor p = this.factory.createCUDRequestProcessor(uriInfo, this.requestContext);
            p.clearFields(request, response);
        }
        catch (ODataApplicationException | ODataLibraryException e) {
            throw e;
        }
        catch (ODataException e) {
            throw new ODataJPAProcessorException(ODataJPAProcessorException.MessageKeys.NOT_SUPPORTED_DELETE, HttpStatusCode.NOT_IMPLEMENTED);
        }
    }

    public void deletePrimitiveValue(ODataRequest request, ODataResponse response, UriInfo uriInfo) throws ODataApplicationException, ODataLibraryException {
        throw new ODataJPAProcessorException(ODataJPAProcessorException.MessageKeys.NOT_SUPPORTED_DELETE_VALUE, HttpStatusCode.NOT_IMPLEMENTED);
    }

    public void deleteMediaEntity(ODataRequest request, ODataResponse response, UriInfo uriInfo) throws ODataApplicationException, ODataLibraryException {
        throw new ODataJPAProcessorException(ODataJPAProcessorException.MessageKeys.NOT_SUPPORTED_DELETE, HttpStatusCode.NOT_IMPLEMENTED);
    }

    public void readComplex(ODataRequest request, ODataResponse response, UriInfo uriInfo, ContentType responseFormat) throws ODataApplicationException, ODataLibraryException {
        try {
            JPARequestProcessor p = this.factory.createProcessor(uriInfo, responseFormat, request.getAllHeaders(), this.requestContext);
            p.retrieveData(request, response, responseFormat);
        }
        catch (ODataApplicationException | ODataLibraryException e) {
            throw e;
        }
        catch (ODataException e) {
            throw new ODataApplicationException(e.getLocalizedMessage(), HttpStatusCode.INTERNAL_SERVER_ERROR.getStatusCode(), null, (Throwable)e);
        }
    }

    public void readComplexCollection(ODataRequest request, ODataResponse response, UriInfo uriInfo, ContentType responseFormat) throws ODataApplicationException, ODataLibraryException {
        try {
            JPARequestProcessor p = this.factory.createProcessor(uriInfo, responseFormat, request.getAllHeaders(), this.requestContext);
            p.retrieveData(request, response, responseFormat);
        }
        catch (ODataApplicationException | ODataLibraryException e) {
            throw e;
        }
        catch (ODataException e) {
            throw new ODataApplicationException(e.getLocalizedMessage(), HttpStatusCode.INTERNAL_SERVER_ERROR.getStatusCode(), null, (Throwable)e);
        }
    }

    public void readEntity(ODataRequest request, ODataResponse response, UriInfo uriInfo, ContentType responseFormat) throws ODataApplicationException, ODataLibraryException {
        try {
            JPARequestProcessor p = this.factory.createProcessor(uriInfo, responseFormat, request.getAllHeaders(), this.requestContext);
            p.retrieveData(request, response, responseFormat);
        }
        catch (ODataApplicationException | ODataLibraryException e) {
            throw e;
        }
        catch (ODataException e) {
            throw new ODataApplicationException(e.getLocalizedMessage(), HttpStatusCode.INTERNAL_SERVER_ERROR.getStatusCode(), null, (Throwable)e);
        }
    }

    public void readEntityCollection(ODataRequest request, ODataResponse response, UriInfo uriInfo, ContentType responseFormat) throws ODataApplicationException, ODataLibraryException {
        try {
            JPARequestProcessor p = this.factory.createProcessor(uriInfo, responseFormat, request.getAllHeaders(), this.requestContext);
            p.retrieveData(request, response, responseFormat);
        }
        catch (ODataApplicationException | ODataLibraryException e) {
            throw e;
        }
        catch (ODataException e) {
            throw new ODataApplicationException(e.getLocalizedMessage(), HttpStatusCode.INTERNAL_SERVER_ERROR.getStatusCode(), null, (Throwable)e);
        }
    }

    public void readPrimitiveCollection(ODataRequest request, ODataResponse response, UriInfo uriInfo, ContentType responseFormat) throws ODataApplicationException, ODataLibraryException {
        try {
            JPARequestProcessor p = this.factory.createProcessor(uriInfo, responseFormat, request.getAllHeaders(), this.requestContext);
            p.retrieveData(request, response, responseFormat);
        }
        catch (ODataApplicationException | ODataLibraryException e) {
            throw e;
        }
        catch (ODataException e) {
            throw new ODataApplicationException(e.getLocalizedMessage(), HttpStatusCode.INTERNAL_SERVER_ERROR.getStatusCode(), null, (Throwable)e);
        }
    }

    public void readPrimitive(ODataRequest request, ODataResponse response, UriInfo uriInfo, ContentType responseFormat) throws ODataApplicationException, ODataLibraryException {
        try {
            JPARequestProcessor p = this.factory.createProcessor(uriInfo, responseFormat, request.getAllHeaders(), this.requestContext);
            p.retrieveData(request, response, responseFormat);
        }
        catch (ODataApplicationException | ODataLibraryException e) {
            throw e;
        }
        catch (ODataException e) {
            throw new ODataApplicationException(e.getLocalizedMessage(), HttpStatusCode.INTERNAL_SERVER_ERROR.getStatusCode(), null, (Throwable)e);
        }
    }

    public void readPrimitiveValue(ODataRequest request, ODataResponse response, UriInfo uriInfo, ContentType responseFormat) throws ODataApplicationException, ODataLibraryException {
        try {
            JPARequestProcessor p = this.factory.createProcessor(uriInfo, responseFormat, request.getAllHeaders(), this.requestContext);
            p.retrieveData(request, response, responseFormat);
        }
        catch (ODataApplicationException | ODataLibraryException e) {
            throw e;
        }
        catch (ODataException e) {
            throw new ODataApplicationException(e.getLocalizedMessage(), HttpStatusCode.INTERNAL_SERVER_ERROR.getStatusCode(), null, (Throwable)e);
        }
    }

    public void readMediaEntity(ODataRequest request, ODataResponse response, UriInfo uriInfo, ContentType responseFormat) throws ODataApplicationException, ODataLibraryException {
        try {
            JPARequestProcessor p = this.factory.createProcessor(uriInfo, responseFormat, request.getAllHeaders(), this.requestContext);
            p.retrieveData(request, response, responseFormat);
        }
        catch (ODataApplicationException | ODataLibraryException e) {
            throw e;
        }
        catch (ODataException e) {
            throw new ODataApplicationException(e.getLocalizedMessage(), HttpStatusCode.INTERNAL_SERVER_ERROR.getStatusCode(), null, (Throwable)e);
        }
    }

    public void updateComplex(ODataRequest request, ODataResponse response, UriInfo uriInfo, ContentType requestFormat, ContentType responseFormat) throws ODataApplicationException, ODataLibraryException {
        throw new ODataJPAProcessorException(ODataJPAProcessorException.MessageKeys.NOT_SUPPORTED_UPDATE_VALUE, HttpStatusCode.NOT_IMPLEMENTED);
    }

    public void updateEntity(ODataRequest request, ODataResponse response, UriInfo uriInfo, ContentType requestFormat, ContentType responseFormat) throws ODataApplicationException, ODataLibraryException {
        try {
            JPACUDRequestProcessor p = this.factory.createCUDRequestProcessor(uriInfo, responseFormat, this.requestContext, request.getAllHeaders());
            p.updateEntity(request, response, requestFormat, responseFormat);
        }
        catch (ODataApplicationException | ODataLibraryException e) {
            throw e;
        }
        catch (ODataException e) {
            throw new ODataApplicationException(e.getLocalizedMessage(), HttpStatusCode.INTERNAL_SERVER_ERROR.getStatusCode(), null, (Throwable)e);
        }
        catch (RollbackException e) {
            if (e.getCause() instanceof OptimisticLockException) {
                throw new ODataJPAProcessorException(e.getCause().getCause(), HttpStatusCode.PRECONDITION_FAILED);
            }
            throw new ODataJPAProcessorException(e, HttpStatusCode.INTERNAL_SERVER_ERROR);
        }
    }

    public void updatePrimitive(ODataRequest request, ODataResponse response, UriInfo uriInfo, ContentType requestFormat, ContentType responseFormat) throws ODataApplicationException, ODataLibraryException {
        this.updateEntity(request, response, uriInfo, requestFormat, responseFormat);
    }

    public void updatePrimitiveValue(ODataRequest request, ODataResponse response, UriInfo uriInfo, ContentType requestFormat, ContentType responseFormat) throws ODataApplicationException, ODataLibraryException {
        throw new ODataJPAProcessorException(ODataJPAProcessorException.MessageKeys.NOT_SUPPORTED_UPDATE_VALUE, HttpStatusCode.NOT_IMPLEMENTED);
    }

    public void updateMediaEntity(ODataRequest request, ODataResponse response, UriInfo uriInfo, ContentType requestFormat, ContentType responseFormat) throws ODataApplicationException, ODataLibraryException {
        throw new ODataJPAProcessorException(ODataJPAProcessorException.MessageKeys.NOT_SUPPORTED_UPDATE, HttpStatusCode.NOT_IMPLEMENTED);
    }

    public void updatePrimitiveCollection(ODataRequest request, ODataResponse response, UriInfo uriInfo, ContentType requestFormat, ContentType responseFormat) throws ODataApplicationException, ODataLibraryException {
        this.updateEntity(request, response, uriInfo, requestFormat, responseFormat);
    }

    public void deletePrimitiveCollection(ODataRequest request, ODataResponse response, UriInfo uriInfo) throws ODataApplicationException, ODataLibraryException {
        try {
            JPACUDRequestProcessor p = this.factory.createCUDRequestProcessor(uriInfo, this.requestContext);
            p.clearFields(request, response);
        }
        catch (ODataApplicationException | ODataLibraryException e) {
            throw e;
        }
        catch (ODataException e) {
            throw new ODataJPAProcessorException(ODataJPAProcessorException.MessageKeys.NOT_SUPPORTED_DELETE, HttpStatusCode.NOT_IMPLEMENTED);
        }
    }

    public void updateComplexCollection(ODataRequest request, ODataResponse response, UriInfo uriInfo, ContentType requestFormat, ContentType responseFormat) throws ODataApplicationException, ODataLibraryException {
        this.updateEntity(request, response, uriInfo, requestFormat, responseFormat);
    }

    public void deleteComplexCollection(ODataRequest request, ODataResponse response, UriInfo uriInfo) throws ODataApplicationException, ODataLibraryException {
        try {
            JPACUDRequestProcessor p = this.factory.createCUDRequestProcessor(uriInfo, this.requestContext);
            p.clearFields(request, response);
        }
        catch (ODataApplicationException | ODataLibraryException e) {
            throw e;
        }
        catch (ODataException e) {
            throw new ODataJPAProcessorException(ODataJPAProcessorException.MessageKeys.NOT_SUPPORTED_DELETE, HttpStatusCode.NOT_IMPLEMENTED);
        }
    }

    public void processActionPrimitive(ODataRequest request, ODataResponse response, UriInfo uriInfo, ContentType requestFormat, ContentType responseFormat) throws ODataApplicationException, ODataLibraryException {
        try {
            JPAActionRequestProcessor p = this.factory.createActionProcessor(uriInfo, responseFormat, request.getAllHeaders(), this.requestContext);
            p.performAction(request, response, requestFormat);
        }
        catch (ODataApplicationException | ODataLibraryException e) {
            throw e;
        }
        catch (ODataException e) {
            throw new ODataApplicationException(e.getLocalizedMessage(), HttpStatusCode.INTERNAL_SERVER_ERROR.getStatusCode(), null, (Throwable)e);
        }
    }

    public void processActionVoid(ODataRequest request, ODataResponse response, UriInfo uriInfo, ContentType requestFormat) throws ODataApplicationException, ODataLibraryException {
        try {
            JPAActionRequestProcessor p = this.factory.createActionProcessor(uriInfo, null, request.getAllHeaders(), this.requestContext);
            p.performAction(request, response, requestFormat);
        }
        catch (ODataApplicationException | ODataLibraryException e) {
            throw e;
        }
        catch (ODataException e) {
            throw new ODataApplicationException(e.getLocalizedMessage(), HttpStatusCode.INTERNAL_SERVER_ERROR.getStatusCode(), null, (Throwable)e);
        }
    }
}

