/*
 * Decompiled with CFR 0.152.
 */
package com.sap.olingo.jpa.processor.core.api;

import com.sap.olingo.jpa.metadata.api.JPAEdmMetadataPostProcessor;
import com.sap.olingo.jpa.metadata.api.JPAEdmProvider;
import com.sap.olingo.jpa.metadata.api.JPAEntityManagerFactory;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAEdmNameBuilder;
import com.sap.olingo.jpa.metadata.core.edm.mapper.impl.JPADefaultEdmNameBuilder;
import com.sap.olingo.jpa.processor.core.api.JPACUDRequestHandler;
import com.sap.olingo.jpa.processor.core.api.JPADefaultErrorProcessor;
import com.sap.olingo.jpa.processor.core.api.JPAODataCRUDContext;
import com.sap.olingo.jpa.processor.core.api.JPAODataCRUDContextAccess;
import com.sap.olingo.jpa.processor.core.api.JPAODataDatabaseProcessor;
import com.sap.olingo.jpa.processor.core.api.JPAODataGetHandler;
import com.sap.olingo.jpa.processor.core.api.JPAODataPagingProvider;
import com.sap.olingo.jpa.processor.core.api.JPAServiceDebugger;
import com.sap.olingo.jpa.processor.core.database.JPADefaultDatabaseProcessor;
import com.sap.olingo.jpa.processor.core.database.JPAODataDatabaseOperations;
import com.sap.olingo.jpa.processor.core.database.JPAODataDatabaseProcessorFactory;
import com.sap.olingo.jpa.processor.core.exception.ODataJPAFilterException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceException;
import javax.sql.DataSource;
import org.apache.olingo.commons.api.edmx.EdmxReference;
import org.apache.olingo.commons.api.ex.ODataException;
import org.apache.olingo.commons.api.http.HttpStatusCode;
import org.apache.olingo.server.api.OData;
import org.apache.olingo.server.api.ODataResponse;
import org.apache.olingo.server.api.debug.DebugInformation;
import org.apache.olingo.server.api.debug.DebugSupport;
import org.apache.olingo.server.api.debug.DefaultDebugSupport;
import org.apache.olingo.server.api.debug.RuntimeMeasurement;
import org.apache.olingo.server.api.processor.ErrorProcessor;

public final class JPAODataServiceContext
implements JPAODataCRUDContext,
JPAODataCRUDContextAccess {
    @Deprecated
    private final JPAODataGetHandler jpaODataGetHandler;
    private List<EdmxReference> references = new ArrayList<EdmxReference>();
    private JPADebugSupportWrapper debugSupport;
    private JPAODataDatabaseOperations operationConverter;
    private JPAEdmProvider jpaEdm;
    private JPAODataDatabaseProcessor databaseProcessor;
    private JPAEdmMetadataPostProcessor postProcessor;
    private JPACUDRequestHandler jpaCUDRequestHandler;
    private String[] packageName;
    private ErrorProcessor errorProcessor;
    private JPAODataPagingProvider pagingProvider;
    private Optional<EntityManagerFactory> emf;
    private final String namespace;
    private String mappingPath;
    private boolean useAbsoluteContextURL;

    public static Builder with() {
        return new Builder();
    }

    @Deprecated
    JPAODataServiceContext(JPAODataGetHandler jpaODataGetHandler) throws ODataException {
        this.jpaODataGetHandler = jpaODataGetHandler;
        this.namespace = jpaODataGetHandler.namespace;
        this.debugSupport = new JPADebugSupportWrapper((DebugSupport)new DefaultDebugSupport());
        this.operationConverter = new JPADefaultDatabaseProcessor();
        try {
            this.databaseProcessor = new JPAODataDatabaseProcessorFactory().create(this.jpaODataGetHandler.ds);
        }
        catch (SQLException e) {
            throw new ODataJPAFilterException(e, HttpStatusCode.INTERNAL_SERVER_ERROR);
        }
    }

    private JPAODataServiceContext(Builder builder) {
        this.jpaODataGetHandler = null;
        this.operationConverter = builder.operationConverter;
        this.databaseProcessor = builder.databaseProcessor;
        this.references = builder.references;
        this.postProcessor = builder.postProcessor;
        this.jpaCUDRequestHandler = null;
        this.packageName = builder.packageName;
        this.errorProcessor = builder.errorProcessor;
        this.pagingProvider = builder.pagingProvider;
        this.jpaEdm = builder.jpaEdm;
        this.emf = builder.emf;
        this.namespace = builder.namespace;
        this.mappingPath = builder.mappingPath;
        this.useAbsoluteContextURL = builder.useAbsoluteContextURL;
    }

    @Override
    public JPACUDRequestHandler getCUDRequestHandler() {
        return this.jpaCUDRequestHandler;
    }

    @Override
    public JPAODataDatabaseProcessor getDatabaseProcessor() {
        return this.databaseProcessor;
    }

    @Override
    public DebugSupport getDebugSupport() {
        return this.debugSupport;
    }

    @Override
    public JPAEdmProvider getEdmProvider() throws ODataException {
        if (this.jpaEdm == null && this.jpaODataGetHandler != null && this.jpaODataGetHandler.jpaMetamodel != null) {
            this.jpaEdm = new JPAEdmProvider(this.namespace, this.jpaODataGetHandler.jpaMetamodel, this.postProcessor, this.packageName);
        }
        return this.jpaEdm;
    }

    public JPAEdmProvider getEdmProvider(@Nonnull EntityManager em) throws ODataException {
        if (this.jpaEdm == null) {
            Objects.nonNull(em);
            this.jpaEdm = new JPAEdmProvider(this.namespace, em.getMetamodel(), this.postProcessor, this.packageName);
        }
        return this.jpaEdm;
    }

    @Override
    public Optional<EntityManagerFactory> getEntityManagerFactory() {
        return this.emf;
    }

    @Override
    public ErrorProcessor getErrorProcessor() {
        return this.errorProcessor == null ? new JPADefaultErrorProcessor() : this.errorProcessor;
    }

    @Override
    public JPAODataDatabaseOperations getOperationConverter() {
        return this.operationConverter;
    }

    @Override
    public String[] getPackageName() {
        return this.packageName;
    }

    @Override
    public JPAODataPagingProvider getPagingProvider() {
        return this.pagingProvider;
    }

    @Override
    public List<EdmxReference> getReferences() {
        return this.references;
    }

    @Override
    public String getMappingPath() {
        return this.mappingPath;
    }

    @Override
    public boolean useAbsoluteContextURL() {
        return this.useAbsoluteContextURL;
    }

    @Override
    @Deprecated
    public void initDebugger(String debugFormat) {
    }

    @Override
    @Deprecated
    public void setCUDRequestHandler(JPACUDRequestHandler jpaCUDRequestHandler) {
        this.jpaCUDRequestHandler = jpaCUDRequestHandler;
    }

    @Override
    @Deprecated
    public void setDatabaseProcessor(JPAODataDatabaseProcessor databaseProcessor) {
        this.databaseProcessor = databaseProcessor;
    }

    @Override
    @Deprecated
    public void setDebugSupport(DebugSupport jpaDebugSupport) {
        this.debugSupport = new JPADebugSupportWrapper(jpaDebugSupport);
    }

    @Override
    @Deprecated
    public void setErrorProcessor(ErrorProcessor errorProcessor) {
        this.errorProcessor = errorProcessor;
    }

    @Override
    @Deprecated
    public void setMetadataPostProcessor(JPAEdmMetadataPostProcessor postProcessor) throws ODataException {
        if (this.jpaODataGetHandler.jpaMetamodel != null) {
            this.jpaEdm = new JPAEdmProvider(this.jpaODataGetHandler.namespace, this.jpaODataGetHandler.jpaMetamodel, postProcessor, this.packageName);
        } else {
            this.postProcessor = postProcessor;
        }
    }

    @Override
    @Deprecated
    public void setOperationConverter(JPAODataDatabaseOperations jpaOperationConverter) {
        this.operationConverter = jpaOperationConverter;
    }

    @Override
    @Deprecated
    public void setPagingProvider(JPAODataPagingProvider provider) {
        this.pagingProvider = provider;
    }

    @Override
    @Deprecated
    public void setReferences(List<EdmxReference> references) {
        this.references = references;
    }

    @Override
    @Deprecated
    public void setTypePackage(String ... packageName) {
        this.packageName = packageName;
    }

    public static class Builder {
        private String namespace;
        private List<EdmxReference> references = new ArrayList<EdmxReference>();
        private JPAODataDatabaseOperations operationConverter = new JPADefaultDatabaseProcessor();
        private JPAODataDatabaseProcessor databaseProcessor;
        private JPAEdmMetadataPostProcessor postProcessor;
        private String[] packageName;
        private ErrorProcessor errorProcessor;
        private JPAODataPagingProvider pagingProvider;
        private Optional<EntityManagerFactory> emf = Optional.empty();
        private DataSource ds;
        private JPAEdmProvider jpaEdm;
        private JPAEdmNameBuilder nameBuilder;
        private String mappingPath;
        private boolean useAbsoluteContextURL = false;

        public JPAODataCRUDContextAccess build() throws ODataException {
            try {
                if (this.nameBuilder == null) {
                    this.nameBuilder = new JPADefaultEdmNameBuilder(this.namespace);
                }
                if (this.packageName == null) {
                    this.packageName = new String[0];
                }
                if (!this.emf.isPresent() && this.ds != null && this.namespace != null) {
                    this.emf = Optional.ofNullable(JPAEntityManagerFactory.getEntityManagerFactory((String)this.namespace, (DataSource)this.ds));
                }
                if (this.emf.isPresent()) {
                    this.jpaEdm = new JPAEdmProvider(this.emf.get().getMetamodel(), this.postProcessor, this.packageName, this.nameBuilder);
                }
                if (this.databaseProcessor == null) {
                    this.databaseProcessor = new JPAODataDatabaseProcessorFactory().create(this.ds);
                }
            }
            catch (SQLException | PersistenceException e) {
                throw new ODataJPAFilterException(e, HttpStatusCode.INTERNAL_SERVER_ERROR);
            }
            return new JPAODataServiceContext(this);
        }

        public Builder setDatabaseProcessor(JPAODataDatabaseProcessor databaseProcessor) {
            this.databaseProcessor = databaseProcessor;
            return this;
        }

        public Builder setDataSource(DataSource ds) {
            this.ds = ds;
            return this;
        }

        public Builder setErrorProcessor(ErrorProcessor errorProcessor) {
            this.errorProcessor = errorProcessor;
            return this;
        }

        public Builder setMetadataPostProcessor(JPAEdmMetadataPostProcessor postProcessor) {
            this.postProcessor = postProcessor;
            return this;
        }

        public Builder setOperationConverter(JPAODataDatabaseOperations jpaOperationConverter) {
            this.operationConverter = jpaOperationConverter;
            return this;
        }

        public Builder setPagingProvider(JPAODataPagingProvider provider) {
            this.pagingProvider = provider;
            return this;
        }

        public Builder setPUnit(String pUnit) {
            this.namespace = pUnit;
            return this;
        }

        public Builder setReferences(List<EdmxReference> references) {
            this.references = references;
            return this;
        }

        public Builder setTypePackage(String ... packageName) {
            this.packageName = packageName;
            return this;
        }

        public Builder setRequestMappingPath(String mappingPath) {
            this.mappingPath = mappingPath;
            return this;
        }

        public Builder setEntityManagerFactory(EntityManagerFactory emf) {
            this.emf = Optional.of(emf);
            return this;
        }

        public Builder setEdmNameBuilder(JPAEdmNameBuilder nameBuilder) {
            this.nameBuilder = nameBuilder;
            return this;
        }

        public Builder setUseAbsoluteContextURL(boolean useAbsoluteContextURL) {
            this.useAbsoluteContextURL = useAbsoluteContextURL;
            return this;
        }
    }

    class JPADebugSupportWrapper
    implements DebugSupport {
        private final DebugSupport debugSupport;
        private JPAServiceDebugger debugger;

        public JPADebugSupportWrapper(DebugSupport debugSupport) {
            this.debugSupport = debugSupport;
        }

        public ODataResponse createDebugResponse(String debugFormat, DebugInformation debugInfo) {
            this.joinRuntimeInfo(debugInfo);
            return this.debugSupport.createDebugResponse(debugFormat, debugInfo);
        }

        public void init(OData odata) {
            this.debugSupport.init(odata);
        }

        public boolean isUserAuthorized() {
            return this.debugSupport.isUserAuthorized();
        }

        void setDebugger(JPAServiceDebugger debugger) {
            this.debugger = debugger;
        }

        private void joinRuntimeInfo(DebugInformation debugInfo) {
            List olingoInfo = debugInfo.getRuntimeInformation();
            int startIndex = 0;
            for (RuntimeMeasurement m : this.debugger.getRuntimeInformation()) {
                while (startIndex < olingoInfo.size() && ((RuntimeMeasurement)olingoInfo.get(startIndex)).getTimeStarted() <= m.getTimeStarted()) {
                    ++startIndex;
                }
                olingoInfo.add(startIndex, m);
                ++startIndex;
            }
        }
    }
}

