/*
 * Decompiled with CFR 0.152.
 */
package com.sap.olingo.jpa.processor.core.api.example;

import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAAssociationPath;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAEntityType;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAStructuredType;
import com.sap.olingo.jpa.metadata.core.edm.mapper.exception.ODataJPAModelException;
import com.sap.olingo.jpa.processor.core.api.JPAAbstractCUDRequestHandler;
import com.sap.olingo.jpa.processor.core.api.example.JPAExampleModifyException;
import com.sap.olingo.jpa.processor.core.exception.ODataJPAInvocationTargetException;
import com.sap.olingo.jpa.processor.core.exception.ODataJPAProcessException;
import com.sap.olingo.jpa.processor.core.exception.ODataJPAProcessorException;
import com.sap.olingo.jpa.processor.core.modify.JPAUpdateResult;
import com.sap.olingo.jpa.processor.core.processor.JPAModifyUtil;
import com.sap.olingo.jpa.processor.core.processor.JPARequestEntity;
import com.sap.olingo.jpa.processor.core.processor.JPARequestLink;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import org.apache.olingo.commons.api.http.HttpMethod;
import org.apache.olingo.commons.api.http.HttpStatusCode;

public class JPAExampleCUDRequestHandler
extends JPAAbstractCUDRequestHandler {
    private final Map<Object, JPARequestEntity> entityBuffer = new HashMap<Object, JPARequestEntity>();

    @Override
    public Object createEntity(JPARequestEntity requestEntity, EntityManager em) throws ODataJPAProcessException {
        Object instance = null;
        if (requestEntity.getKeys().isEmpty()) {
            instance = this.createOneEntity(requestEntity, em, null);
            Object old = em.find(requestEntity.getEntityType().getTypeClass(), requestEntity.getModifyUtil().createPrimaryKey(requestEntity.getEntityType(), instance));
            if (old != null) {
                throw new JPAExampleModifyException(JPAExampleModifyException.MessageKeys.ENTITY_ALREADY_EXISTS, HttpStatusCode.BAD_REQUEST);
            }
        } else {
            instance = this.findEntity(requestEntity, em);
        }
        this.processRelatedEntities(requestEntity.getRelatedEntities(), instance, requestEntity.getModifyUtil(), em);
        em.persist(instance);
        return instance;
    }

    @Override
    public void deleteEntity(JPARequestEntity requestEntity, EntityManager em) throws ODataJPAProcessException {
        Object instance = em.find(requestEntity.getEntityType().getTypeClass(), requestEntity.getModifyUtil().createPrimaryKey(requestEntity.getEntityType(), requestEntity.getKeys(), (JPAStructuredType)requestEntity.getEntityType()));
        if (instance != null) {
            em.remove(instance);
        }
    }

    @Override
    public JPAUpdateResult updateEntity(JPARequestEntity requestEntity, EntityManager em, HttpMethod method) throws ODataJPAProcessException {
        if (method == HttpMethod.PATCH || method == HttpMethod.DELETE) {
            Object instance = em.find(requestEntity.getEntityType().getTypeClass(), requestEntity.getModifyUtil().createPrimaryKey(requestEntity.getEntityType(), requestEntity.getKeys(), (JPAStructuredType)requestEntity.getEntityType()));
            if (instance == null) {
                throw new JPAExampleModifyException(JPAExampleModifyException.MessageKeys.ENTITY_NOT_FOUND, HttpStatusCode.NOT_FOUND);
            }
            requestEntity.getModifyUtil().setAttributesDeep(requestEntity.getData(), instance, (JPAStructuredType)requestEntity.getEntityType());
            this.updateLinks(requestEntity, em, instance);
            return new JPAUpdateResult(false, instance);
        }
        return super.updateEntity(requestEntity, em, method);
    }

    @Override
    public void validateChanges(EntityManager em) throws ODataJPAProcessException {
        for (Map.Entry<Object, JPARequestEntity> entity : this.entityBuffer.entrySet()) {
            this.processBindingLinks(entity.getValue().getRelationLinks(), entity.getKey(), entity.getValue().getModifyUtil(), em);
        }
    }

    private Object createInstance(Constructor<?> cons, Object parent) throws ODataJPAProcessorException {
        try {
            if (cons.getParameterCount() == 1) {
                return cons.newInstance(parent);
            }
            return cons.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            throw new ODataJPAProcessorException(e, HttpStatusCode.INTERNAL_SERVER_ERROR);
        }
    }

    private Object createOneEntity(JPARequestEntity requestEntity, EntityManager em, Object parent) throws ODataJPAProcessException {
        Object instance = this.createInstance(this.getConstructor((JPAStructuredType)requestEntity.getEntityType(), parent), parent);
        requestEntity.getModifyUtil().setAttributesDeep(requestEntity.getData(), instance, (JPAStructuredType)requestEntity.getEntityType());
        this.entityBuffer.put(instance, requestEntity);
        return instance;
    }

    private Object findEntity(JPARequestEntity requestEntity, EntityManager em) throws ODataJPAProcessorException, ODataJPAInvocationTargetException {
        Object key = requestEntity.getModifyUtil().createPrimaryKey(requestEntity.getEntityType(), requestEntity.getKeys(), (JPAStructuredType)requestEntity.getEntityType());
        return em.getReference(requestEntity.getEntityType().getTypeClass(), key);
    }

    private Constructor<?> getConstructor(JPAStructuredType st, Object parentInstance) throws ODataJPAProcessorException {
        if (parentInstance != null) {
            try {
                return st.getTypeClass().getConstructor(parentInstance.getClass());
            }
            catch (NoSuchMethodException | SecurityException exception) {
                // empty catch block
            }
        }
        try {
            return st.getTypeClass().getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new ODataJPAProcessorException(e, HttpStatusCode.INTERNAL_SERVER_ERROR);
        }
    }

    private void processBindingLinks(Map<JPAAssociationPath, List<JPARequestLink>> relationLinks, Object instance, JPAModifyUtil util, EntityManager em) throws ODataJPAProcessException {
        for (Map.Entry<JPAAssociationPath, List<JPARequestLink>> entity : relationLinks.entrySet()) {
            JPAAssociationPath pathInfo = entity.getKey();
            for (JPARequestLink requestLink : entity.getValue()) {
                Object targetKey = util.createPrimaryKey((JPAEntityType)pathInfo.getTargetType(), requestLink.getRelatedKeys(), (JPAStructuredType)((JPAEntityType)pathInfo.getSourceType()));
                Object target = em.find(pathInfo.getTargetType().getTypeClass(), targetKey);
                util.linkEntities(instance, target, pathInfo);
            }
        }
    }

    private void processRelatedEntities(Map<JPAAssociationPath, List<JPARequestEntity>> relatedEntities, Object parentInstance, JPAModifyUtil util, EntityManager em) throws ODataJPAProcessException {
        for (Map.Entry<JPAAssociationPath, List<JPARequestEntity>> entity : relatedEntities.entrySet()) {
            JPAAssociationPath pathInfo = entity.getKey();
            for (JPARequestEntity requestEntity : entity.getValue()) {
                Object newInstance = this.createOneEntity(requestEntity, em, parentInstance);
                util.linkEntities(parentInstance, newInstance, pathInfo);
                if (pathInfo.getPartner() != null) {
                    try {
                        util.linkEntities(newInstance, parentInstance, pathInfo.getPartner().getPath());
                    }
                    catch (ODataJPAModelException e) {
                        throw new ODataJPAProcessorException(e, HttpStatusCode.INTERNAL_SERVER_ERROR);
                    }
                }
                this.processRelatedEntities(requestEntity.getRelatedEntities(), newInstance, util, em);
            }
        }
    }

    private void updateLinks(JPARequestEntity requestEntity, EntityManager em, Object instance) throws ODataJPAProcessorException, ODataJPAInvocationTargetException {
        if (requestEntity.getRelationLinks() != null) {
            for (Map.Entry<JPAAssociationPath, List<JPARequestLink>> links : requestEntity.getRelationLinks().entrySet()) {
                for (JPARequestLink link : links.getValue()) {
                    Object related = em.find(link.getEntityType().getTypeClass(), requestEntity.getModifyUtil().createPrimaryKey(link.getEntityType(), link.getRelatedKeys(), (JPAStructuredType)link.getEntityType()));
                    requestEntity.getModifyUtil().linkEntities(instance, related, links.getKey());
                }
            }
        }
    }
}

