/*
 * Decompiled with CFR 0.152.
 */
package com.sap.olingo.jpa.processor.core.api.example;

import com.sap.olingo.jpa.processor.core.api.JPAODataPage;
import com.sap.olingo.jpa.processor.core.api.JPAODataPagingProvider;
import com.sap.olingo.jpa.processor.core.query.JPACountQuery;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import javax.persistence.EntityManager;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.uri.UriInfo;
import org.apache.olingo.server.api.uri.UriResource;
import org.apache.olingo.server.api.uri.UriResourceEntitySet;

public class JPAExamplePagingProvider
implements JPAODataPagingProvider {
    private static final int DEFAULT_BUFFER_SIZE = 100;
    private final Map<String, Integer> maxPageSizes;
    private final Map<String, CacheEntry> pageCache;
    private final int cacheSize;
    private final Queue<String> index;

    public JPAExamplePagingProvider(Map<String, Integer> pageSizes) {
        this(pageSizes, 100);
    }

    public JPAExamplePagingProvider(Map<String, Integer> pageSizes, int bufferSize) {
        this.maxPageSizes = pageSizes;
        this.pageCache = new HashMap<String, CacheEntry>(bufferSize);
        this.cacheSize = bufferSize;
        this.index = new LinkedList<String>();
    }

    @Override
    public JPAODataPage getNextPage(String skiptoken) {
        CacheEntry privousePage = this.pageCache.get(skiptoken.replaceAll("'", ""));
        if (privousePage != null) {
            Integer skip = privousePage.getPage().getSkip() + privousePage.getPage().getTop();
            String nextToken = null;
            if ((long)(skip + privousePage.getPage().getTop()) < privousePage.getMaxTop()) {
                nextToken = UUID.randomUUID().toString();
            }
            int top = (int)((long)(skip + privousePage.getPage().getTop()) < privousePage.getMaxTop() ? (long)privousePage.getPage().getTop() : privousePage.getMaxTop() - (long)skip.intValue());
            JPAODataPage page = new JPAODataPage(privousePage.getPage().getUriInfo(), skip, top, nextToken);
            if (nextToken != null) {
                this.addToChach(page, privousePage.getMaxTop());
            }
            return page;
        }
        return null;
    }

    @Override
    public JPAODataPage getFirstPage(UriInfo uriInfo, Integer preferedPageSize, JPACountQuery countQuery, EntityManager em) throws ODataApplicationException {
        Integer maxSize;
        UriResource root = (UriResource)uriInfo.getUriResourceParts().get(0);
        if (root instanceof UriResourceEntitySet && (maxSize = this.maxPageSizes.get(((UriResourceEntitySet)root).getEntitySet().getName())) != null) {
            Integer skipValue = uriInfo.getSkipOption() != null ? uriInfo.getSkipOption().getValue() : 0;
            Integer topValue = uriInfo.getTopOption() != null ? Integer.valueOf(uriInfo.getTopOption().getValue()) : null;
            Long count = topValue != null ? (long)(topValue + skipValue) : countQuery.countResults();
            Integer size = preferedPageSize != null && preferedPageSize < maxSize ? preferedPageSize : maxSize;
            String skiptoken = null;
            if ((long)size.intValue() < count) {
                skiptoken = UUID.randomUUID().toString();
            }
            JPAODataPage page = new JPAODataPage(uriInfo, skipValue, topValue != null && topValue < size ? topValue : size, skiptoken);
            if (skiptoken != null) {
                this.addToChach(page, count);
            }
            return page;
        }
        return null;
    }

    private void addToChach(JPAODataPage page, Long count) {
        if (this.pageCache.size() == this.cacheSize) {
            this.pageCache.remove(this.index.poll());
        }
        this.pageCache.put((String)page.getSkiptoken(), new CacheEntry(count, page));
        this.index.add((String)page.getSkiptoken());
    }

    private class CacheEntry {
        private final Long maxTop;
        private final JPAODataPage page;

        CacheEntry(Long count, JPAODataPage page) {
            this.maxTop = count;
            this.page = page;
        }

        public Long getMaxTop() {
            return this.maxTop;
        }

        public JPAODataPage getPage() {
            return this.page;
        }
    }
}

