/*
 * Decompiled with CFR 0.152.
 */
package com.sap.olingo.jpa.processor.core.converter;

import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAServiceDocument;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAStructuredType;
import com.sap.olingo.jpa.metadata.core.edm.mapper.exception.ODataJPAModelException;
import com.sap.olingo.jpa.processor.core.converter.JPAStructuredResultConverter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.data.EntityCollection;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.serializer.SerializerException;
import org.apache.olingo.server.api.uri.UriHelper;

public class JPAEntityResultConverter
extends JPAStructuredResultConverter {
    private final EdmEntityType edmEntityType;
    private final UriHelper odataUriHelper;

    public JPAEntityResultConverter(UriHelper uriHelper, JPAServiceDocument sd, List<?> jpaQueryResult, EdmEntityType returnType) throws ODataJPAModelException {
        super(jpaQueryResult, (JPAStructuredType)sd.getEntity((EdmType)returnType));
        this.edmEntityType = returnType;
        this.odataUriHelper = uriHelper;
    }

    public EntityCollection getResult() throws ODataApplicationException, SerializerException, URISyntaxException {
        EntityCollection odataEntityCollection = new EntityCollection();
        List odataResults = odataEntityCollection.getEntities();
        for (Object row : this.jpaQueryResult) {
            Entity odataEntity = new Entity();
            odataEntity.setType(this.jpaTopLevelType.getExternalFQN().getFullQualifiedNameAsString());
            List properties = odataEntity.getProperties();
            this.convertProperties(row, properties, this.jpaTopLevelType);
            odataEntity.setId(new URI(this.odataUriHelper.buildKeyPredicate(this.edmEntityType, odataEntity)));
            odataResults.add(odataEntity);
        }
        return odataEntityCollection;
    }
}

