/*
 * Decompiled with CFR 0.152.
 */
package com.sap.olingo.jpa.processor.core.converter;

import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAAttribute;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAStructuredType;
import com.sap.olingo.jpa.metadata.core.edm.mapper.exception.ODataJPAModelException;
import com.sap.olingo.jpa.metadata.core.edm.mapper.impl.JPADefaultEdmNameBuilder;
import com.sap.olingo.jpa.processor.core.exception.ODataJPAQueryException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.persistence.AttributeConverter;
import org.apache.olingo.commons.api.data.ComplexValue;
import org.apache.olingo.commons.api.data.Property;
import org.apache.olingo.commons.api.data.ValueType;
import org.apache.olingo.commons.api.http.HttpStatusCode;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.serializer.SerializerException;

public abstract class JPAStructuredResultConverter {
    public static final String ACCESS_MODIFIER_GET = "get";
    public static final String ACCESS_MODIFIER_SET = "set";
    public static final String ACCESS_MODIFIER_IS = "is";
    private static final Map<String, HashMap<String, Method>> METHOD_BUFFER = new HashMap<String, HashMap<String, Method>>();
    protected final List<?> jpaQueryResult;
    protected final JPAStructuredType jpaTopLevelType;

    public JPAStructuredResultConverter(List<?> jpaQueryResult, JPAStructuredType jpaStructuredType) {
        this.jpaQueryResult = jpaQueryResult;
        this.jpaTopLevelType = jpaStructuredType;
    }

    public abstract Object getResult() throws ODataApplicationException, SerializerException, URISyntaxException;

    protected Map<String, Method> getMethods(Class<?> clazz) {
        HashMap<String, Method> methods = METHOD_BUFFER.get(clazz.getName());
        if (methods == null) {
            Method[] allMethods;
            methods = new HashMap();
            for (Method m : allMethods = clazz.getMethods()) {
                if (m.getReturnType().getName() == "void" || !Modifier.isPublic(m.getModifiers())) continue;
                methods.put(m.getName(), m);
            }
            METHOD_BUFFER.put(clazz.getName(), methods);
        }
        return methods;
    }

    protected <T, S> void convertProperties(Object row, List<Property> properties, JPAStructuredType jpaStructuredType) throws ODataJPAQueryException {
        List attributeList;
        Map<String, Method> methodMap = this.getMethods(jpaStructuredType.getTypeClass());
        try {
            attributeList = jpaStructuredType.getAttributes();
        }
        catch (ODataJPAModelException e) {
            throw new ODataJPAQueryException(e, HttpStatusCode.INTERNAL_SERVER_ERROR);
        }
        for (JPAAttribute attribute : attributeList) {
            String attributeName = attribute.getInternalName();
            Method getMethod = this.getGetter(attributeName, methodMap);
            try {
                Object odataValue;
                if (attribute.isCollection()) {
                    odataValue = (Collection)getMethod.invoke(row, new Object[0]);
                    ArrayList<ComplexValue> collection = new ArrayList<ComplexValue>();
                    if (attribute.isComplex() && odataValue != null) {
                        Iterator iterator2 = odataValue.iterator();
                        while (iterator2.hasNext()) {
                            Object element = iterator2.next();
                            ComplexValue values = new ComplexValue();
                            this.convertProperties(element, values.getValue(), attribute.getStructuredType());
                            collection.add(values);
                        }
                    } else if (odataValue != null) {
                        collection.addAll((Collection<ComplexValue>)odataValue);
                    }
                    properties.add(new Property(attribute.getExternalFQN().getFullQualifiedNameAsString(), attribute.getExternalName(), attribute.isComplex() ? ValueType.COLLECTION_COMPLEX : ValueType.COLLECTION_PRIMITIVE, collection));
                    continue;
                }
                if (attribute.isComplex()) {
                    ComplexValue complexValue = new ComplexValue();
                    properties.add(new Property(attribute.getStructuredType().getExternalFQN().getFullQualifiedNameAsString(), attribute.getExternalName(), ValueType.COMPLEX, (Object)complexValue));
                    List values = complexValue.getValue();
                    this.convertProperties(getMethod.invoke(row, new Object[0]), values, attribute.getStructuredType());
                    continue;
                }
                if (row != null) {
                    odataValue = getMethod.invoke(row, new Object[0]);
                    if (attribute.getConverter() != null) {
                        AttributeConverter converter = attribute.getConverter();
                        odataValue = converter.convertToDatabaseColumn(odataValue);
                    }
                    properties.add(new Property(attribute.getExternalFQN().getFullQualifiedNameAsString(), attribute.getExternalName(), ValueType.PRIMITIVE, odataValue));
                    continue;
                }
                properties.add(new Property(attribute.getExternalFQN().getFullQualifiedNameAsString(), attribute.getExternalName(), ValueType.PRIMITIVE, null));
            }
            catch (ODataJPAModelException | IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new ODataJPAQueryException(e, HttpStatusCode.INTERNAL_SERVER_ERROR);
            }
        }
    }

    private Method getGetter(String attributeName, Map<String, Method> methodMap) throws ODataJPAQueryException {
        String getterName = ACCESS_MODIFIER_GET + JPADefaultEdmNameBuilder.firstToUpper((String)attributeName);
        if (methodMap.get(getterName) == null) {
            throw new ODataJPAQueryException(ODataJPAQueryException.MessageKeys.QUERY_RESULT_ACCESS_NOT_FOUND, HttpStatusCode.INTERNAL_SERVER_ERROR, attributeName);
        }
        Method getMethod = methodMap.get(getterName);
        return getMethod;
    }
}

