/*
 * Decompiled with CFR 0.152.
 */
package com.sap.olingo.jpa.processor.core.converter;

import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAAttribute;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPACollectionAttribute;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAElement;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAEntitySet;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAEntityType;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAPath;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAServiceDocument;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAStructuredType;
import com.sap.olingo.jpa.metadata.core.edm.mapper.exception.ODataJPAModelException;
import com.sap.olingo.jpa.processor.core.converter.JPACollectionResult;
import com.sap.olingo.jpa.processor.core.converter.JPAExpandResult;
import com.sap.olingo.jpa.processor.core.converter.JPATuple;
import com.sap.olingo.jpa.processor.core.converter.JPATupleCollectionConverter;
import com.sap.olingo.jpa.processor.core.converter.JPATupleResultConverter;
import com.sap.olingo.jpa.processor.core.exception.ODataJPAQueryException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.persistence.Tuple;
import javax.persistence.TupleElement;
import org.apache.olingo.commons.api.data.ComplexValue;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.data.EntityCollection;
import org.apache.olingo.commons.api.data.Property;
import org.apache.olingo.commons.api.data.ValueType;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.ex.ODataRuntimeException;
import org.apache.olingo.commons.api.http.HttpStatusCode;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.ServiceMetadata;
import org.apache.olingo.server.api.serializer.SerializerException;
import org.apache.olingo.server.api.uri.UriHelper;

public class JPATupleChildConverter
extends JPATupleResultConverter {
    public JPATupleChildConverter(JPAServiceDocument sd, UriHelper uriHelper, ServiceMetadata serviceMetadata) {
        super(sd, uriHelper, serviceMetadata);
    }

    public JPATupleChildConverter(JPATupleChildConverter converter) {
        this(converter.sd, converter.uriHelper, converter.serviceMetadata);
    }

    public Map<String, List<Object>> getCollectionResult(JPACollectionResult jpaResult, Collection<JPAPath> reqestedSelection) throws ODataApplicationException {
        return new JPATupleCollectionConverter(this.sd, this.uriHelper, this.serviceMetadata).getResult((JPAExpandResult)jpaResult, (Collection)reqestedSelection);
    }

    @Override
    public Map<String, EntityCollection> getResult(JPAExpandResult jpaResult, Collection<JPAPath> reqestedSelection) throws ODataApplicationException {
        this.jpaQueryResult = jpaResult;
        this.setName = this.determineSetName(this.jpaQueryResult, this.sd);
        this.jpaConversionTargetEntity = this.jpaQueryResult.getEntityType();
        this.edmType = this.determineEdmType();
        Map<String, List<Tuple>> childResult = jpaResult.getResults();
        HashMap<String, EntityCollection> result = new HashMap<String, EntityCollection>(childResult.size());
        for (Map.Entry<String, List<Tuple>> tuple : childResult.entrySet()) {
            EntityCollection entityCollection = new EntityCollection();
            List entities = entityCollection.getEntities();
            List<Tuple> rows = tuple.getValue();
            for (int i = 0; i < rows.size(); ++i) {
                Tuple row = rows.set(i, null);
                Entity odataEntity = this.convertRow(this.jpaConversionTargetEntity, row, reqestedSelection);
                odataEntity.setMediaContentType(this.determineContentType(this.jpaConversionTargetEntity, row));
                entities.add(odataEntity);
            }
            result.put(tuple.getKey(), entityCollection);
        }
        childResult.replaceAll((k, v) -> null);
        return result;
    }

    protected Entity convertRow(JPAEntityType rowEntity, Tuple row, Collection<JPAPath> reqestedSelection) throws ODataApplicationException {
        HashMap<String, ComplexValue> complexValueBuffer = new HashMap<String, ComplexValue>();
        Entity odataEntity = new Entity();
        odataEntity.setType(this.edmType.getFullQualifiedName().getFullQualifiedNameAsString());
        List properties = odataEntity.getProperties();
        this.createId(rowEntity, row, odataEntity);
        this.createEtag(rowEntity, row, odataEntity);
        if (reqestedSelection.isEmpty()) {
            this.convertRowWithOutSelection(rowEntity, row, complexValueBuffer, odataEntity, properties);
        } else {
            this.convertRowWithSelection(row, reqestedSelection, complexValueBuffer, odataEntity, properties);
        }
        this.createCollectionProperties((JPAStructuredType)rowEntity, row, properties);
        odataEntity.getNavigationLinks().addAll(this.createExpand((JPAStructuredType)rowEntity, row, "", odataEntity.getId().toString()));
        return odataEntity;
    }

    private void convertRowWithOutSelection(JPAEntityType rowEntity, Tuple row, Map<String, ComplexValue> complexValueBuffer, Entity odataEntity, List<Property> properties) throws ODataApplicationException {
        for (TupleElement element : row.getElements()) {
            try {
                if (odataEntity.getProperty(element.getAlias()) != null) continue;
                JPAPath path = rowEntity.getPath(element.getAlias());
                this.convertAttribute(row.get(element.getAlias()), path, complexValueBuffer, properties, row, "", odataEntity);
            }
            catch (ODataJPAModelException e) {
                throw new ODataJPAQueryException(ODataJPAQueryException.MessageKeys.QUERY_RESULT_CONV_ERROR, HttpStatusCode.INTERNAL_SERVER_ERROR, (Throwable)e);
            }
        }
    }

    private void convertRowWithSelection(Tuple row, Collection<JPAPath> reqestedSelection, Map<String, ComplexValue> complexValueBuffer, Entity odataEntity, List<Property> properties) throws ODataApplicationException {
        for (JPAPath p : reqestedSelection) {
            try {
                Object value = row.get(p.getAlias());
                if (odataEntity.getProperty(p.getAlias()) != null) continue;
                this.convertAttribute(value, p, complexValueBuffer, properties, row, "", odataEntity);
            }
            catch (IllegalArgumentException e) {
                JPATuple skipped = new JPATuple();
                skipped.addElement(p.getAlias(), p.getLeaf().getType(), null);
                try {
                    this.convertAttribute(null, p, complexValueBuffer, properties, skipped, "", odataEntity);
                }
                catch (ODataJPAModelException e1) {
                    throw new ODataJPAQueryException(ODataJPAQueryException.MessageKeys.QUERY_RESULT_CONV_ERROR, HttpStatusCode.INTERNAL_SERVER_ERROR, (Throwable)e);
                }
            }
            catch (ODataJPAModelException e) {
                throw new ODataJPAQueryException(ODataJPAQueryException.MessageKeys.QUERY_RESULT_CONV_ERROR, HttpStatusCode.INTERNAL_SERVER_ERROR, (Throwable)e);
            }
        }
    }

    protected void createCollectionProperties(JPAStructuredType jpaStructuredType, Tuple row, List<Property> properties) throws ODataJPAQueryException {
        try {
            for (JPAPath path : jpaStructuredType.getCollectionAttributesPath()) {
                List<Property> result = properties;
                for (JPAElement pathElement : path.getPath()) {
                    result = this.findOrCreateComplexProperty(result, pathElement);
                }
                JPACollectionAttribute collection = (JPACollectionAttribute)path.getLeaf();
                JPAExpandResult child = this.jpaQueryResult.getChild(collection.asAssociation());
                if (child == null) continue;
                this.addCollcetion(row, result, collection, child);
            }
        }
        catch (ODataJPAModelException e) {
            throw new ODataJPAQueryException(ODataJPAQueryException.MessageKeys.QUERY_RESULT_CONV_ERROR, HttpStatusCode.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
    }

    private void addCollcetion(Tuple row, List<Property> result, JPACollectionAttribute collection, JPAExpandResult child) throws ODataJPAModelException {
        Collection<Object> collectionResult = ((JPACollectionResult)child).getPropertyCollection(this.buildConcatenatedKey(row, collection.asAssociation().getLeftColumnsList()));
        result.add(new Property(null, collection.getExternalName(), collection.isComplex() ? ValueType.COLLECTION_COMPLEX : ValueType.COLLECTION_PRIMITIVE, collectionResult != null ? collectionResult : Collections.emptyList()));
    }

    private List<Property> findOrCreateComplexProperty(List<Property> result, JPAElement pathElement) throws ODataJPAModelException {
        boolean found = false;
        for (Property p : result) {
            if (!p.getName().equals(pathElement.getExternalName())) continue;
            result = ((ComplexValue)p.getValue()).getValue();
            found = true;
            break;
        }
        if (!found && pathElement instanceof JPAAttribute && ((JPAAttribute)pathElement).isComplex() && !((JPAAttribute)pathElement).isCollection()) {
            Property p;
            JPAAttribute a = (JPAAttribute)pathElement;
            p = new Property(a.getStructuredType().getExternalFQN().getFullQualifiedNameAsString(), a.getExternalName(), ValueType.COMPLEX, (Object)new ComplexValue());
            result.add(p);
            result = ((ComplexValue)p.getValue()).getValue();
        }
        return result;
    }

    protected URI createId(Entity entity) {
        try {
            StringBuilder uriString = new StringBuilder(this.setName);
            uriString.append("(");
            uriString.append(this.uriHelper.buildKeyPredicate(this.edmType, entity));
            uriString.append(")");
            return new URI(uriString.toString());
        }
        catch (URISyntaxException e) {
            throw new ODataRuntimeException("Unable to create id for entity: " + this.edmType.getName(), (Exception)e);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        catch (SerializerException e) {
            throw new ODataRuntimeException((Exception)((Object)e));
        }
    }

    protected void createId(JPAEntityType rowEntity, Tuple row, Entity odataEntity) throws ODataApplicationException {
        Map<String, ComplexValue> complexValueBuffer = Collections.emptyMap();
        try {
            for (JPAAttribute path : rowEntity.getKey()) {
                this.convertAttribute(row.get(path.getExternalName()), rowEntity.getPath(path.getExternalName()), complexValueBuffer, odataEntity.getProperties(), row, "", null);
            }
        }
        catch (ODataJPAModelException e) {
            throw new ODataJPAQueryException(ODataJPAQueryException.MessageKeys.QUERY_RESULT_CONV_ERROR, HttpStatusCode.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
        odataEntity.setId(this.createId(odataEntity));
    }

    private void createEtag(@Nonnull JPAEntityType rowEntity, Tuple row, Entity odataEntity) throws ODataJPAQueryException {
        try {
            String etagAlias;
            Object etag;
            if (rowEntity.hasEtag() && (etag = row.get(etagAlias = rowEntity.getEtagPath().getAlias())) != null) {
                odataEntity.setETag(etag.toString());
            }
        }
        catch (ODataJPAModelException e) {
            throw new ODataJPAQueryException(ODataJPAQueryException.MessageKeys.QUERY_RESULT_CONV_ERROR, HttpStatusCode.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
    }

    protected EdmEntityType determineEdmType() {
        try {
            JPAEntitySet es = this.sd.getEntitySet(this.jpaQueryResult.getEntityType());
            return this.serviceMetadata.getEdm().getEntityType(es.getODataEntityType().getExternalFQN());
        }
        catch (ODataJPAModelException e) {
            throw new ODataRuntimeException((Exception)((Object)e));
        }
    }

    protected String determineSetName(JPAExpandResult jpaQueryResult, JPAServiceDocument sd) throws ODataJPAQueryException {
        try {
            return sd.getEntitySet(jpaQueryResult.getEntityType()).getExternalName();
        }
        catch (ODataJPAModelException e) {
            throw new ODataJPAQueryException(ODataJPAQueryException.MessageKeys.QUERY_RESULT_ENTITY_SET_ERROR, HttpStatusCode.INTERNAL_SERVER_ERROR, jpaQueryResult.getEntityType().getExternalFQN().getFullQualifiedNameAsString());
        }
    }

    private String determineContentType(JPAEntityType jpaEntity, Tuple row) throws ODataJPAQueryException {
        try {
            if (jpaEntity.hasStream()) {
                if (jpaEntity.getContentType() != null && !jpaEntity.getContentType().isEmpty()) {
                    return jpaEntity.getContentType();
                }
                Object rowElement = null;
                for (JPAElement element : jpaEntity.getContentTypeAttributePath().getPath()) {
                    rowElement = row.get(element.getExternalName());
                }
                return rowElement != null ? rowElement.toString() : null;
            }
            return null;
        }
        catch (ODataJPAModelException e) {
            throw new ODataJPAQueryException(e, HttpStatusCode.INTERNAL_SERVER_ERROR);
        }
    }
}

