/*
 * Decompiled with CFR 0.152.
 */
package com.sap.olingo.jpa.processor.core.converter;

import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAAssociationAttribute;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAAttribute;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPACollectionAttribute;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAPath;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAServiceDocument;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAStructuredType;
import com.sap.olingo.jpa.metadata.core.edm.mapper.exception.ODataJPAModelException;
import com.sap.olingo.jpa.processor.core.converter.JPACollectionResult;
import com.sap.olingo.jpa.processor.core.converter.JPAExpandResult;
import com.sap.olingo.jpa.processor.core.converter.JPATupleResultConverter;
import com.sap.olingo.jpa.processor.core.exception.ODataJPAQueryException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.AttributeConverter;
import javax.persistence.Tuple;
import javax.persistence.TupleElement;
import org.apache.olingo.commons.api.data.ComplexValue;
import org.apache.olingo.commons.api.http.HttpStatusCode;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.ServiceMetadata;
import org.apache.olingo.server.api.uri.UriHelper;

public class JPATupleCollectionConverter
extends JPATupleResultConverter {
    public JPATupleCollectionConverter(JPAServiceDocument sd, UriHelper uriHelper, ServiceMetadata serviceMetadata) {
        super(sd, uriHelper, serviceMetadata);
    }

    @Override
    public Map<String, List<Object>> getResult(JPAExpandResult dbResult, Collection<JPAPath> reqestedSelection) throws ODataApplicationException {
        this.jpaQueryResult = dbResult;
        JPACollectionResult jpaResult = (JPACollectionResult)dbResult;
        JPAAssociationAttribute attribute = jpaResult.getAssoziation().getLeaf();
        boolean isComplex = attribute.isComplex();
        Map<String, List<Tuple>> childResult = jpaResult.getResults();
        HashMap<String, List<Object>> result = new HashMap<String, List<Object>>(childResult.size());
        try {
            JPAStructuredType st = this.determineCollectionRoot(jpaResult.getEntityType(), jpaResult.getAssoziation().getPath());
            String prefix = this.determinePrefix(jpaResult.getAssoziation().getAlias());
            for (Map.Entry<String, List<Tuple>> tuple : childResult.entrySet()) {
                ArrayList<Object> collection = new ArrayList<Object>();
                List<Tuple> rows = tuple.getValue();
                for (int i = 0; i < rows.size(); ++i) {
                    Tuple row = rows.set(i, null);
                    if (isComplex) {
                        ComplexValue value = new ComplexValue();
                        HashMap<String, ComplexValue> complexValueBuffer = new HashMap<String, ComplexValue>();
                        complexValueBuffer.put(jpaResult.getAssoziation().getAlias(), value);
                        for (TupleElement element : row.getElements()) {
                            JPAPath path = st.getPath(this.determineAlias(element.getAlias(), prefix));
                            this.convertAttribute(row.get(element.getAlias()), path, complexValueBuffer, value.getValue(), row, prefix, null);
                        }
                        collection.add(value);
                        continue;
                    }
                    collection.add(this.convertPrimitiveCollectionAttribute(row.get(jpaResult.getAssoziation().getAlias()), (JPAAttribute)((JPACollectionAttribute)attribute)));
                }
                result.put(tuple.getKey(), collection);
            }
        }
        catch (ODataJPAModelException e) {
            throw new ODataJPAQueryException(ODataJPAQueryException.MessageKeys.QUERY_RESULT_CONV_ERROR, HttpStatusCode.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
        finally {
            childResult.replaceAll((k, v) -> null);
        }
        return result;
    }

    private <T, S> S convertPrimitiveCollectionAttribute(Object value, JPAAttribute attribute) {
        if (attribute.getConverter() != null) {
            AttributeConverter converter = attribute.getConverter();
            return (S)converter.convertToDatabaseColumn(value);
        }
        return (S)value;
    }
}

