/*
 * Decompiled with CFR 0.152.
 */
package com.sap.olingo.jpa.processor.core.converter;

import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAAssociationAttribute;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAAssociationPath;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAAttribute;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAElement;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAEntityType;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAPath;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAServiceDocument;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAStructuredType;
import com.sap.olingo.jpa.metadata.core.edm.mapper.exception.ODataJPAModelException;
import com.sap.olingo.jpa.processor.core.converter.JPAExpandResult;
import com.sap.olingo.jpa.processor.core.converter.JPAResultConverter;
import com.sap.olingo.jpa.processor.core.exception.ODataJPAQueryException;
import com.sap.olingo.jpa.processor.core.query.JPAConvertableResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.persistence.AttributeConverter;
import javax.persistence.Tuple;
import org.apache.olingo.commons.api.Constants;
import org.apache.olingo.commons.api.data.ComplexValue;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.data.EntityCollection;
import org.apache.olingo.commons.api.data.Link;
import org.apache.olingo.commons.api.data.Property;
import org.apache.olingo.commons.api.data.ValueType;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.http.HttpStatusCode;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.ServiceMetadata;
import org.apache.olingo.server.api.uri.UriHelper;

abstract class JPATupleResultConverter
implements JPAResultConverter {
    protected static final String EMPTY_PREFIX = "";
    protected JPAEntityType jpaConversionTargetEntity;
    protected JPAExpandResult jpaQueryResult;
    protected final UriHelper uriHelper;
    protected String setName;
    protected final JPAServiceDocument sd;
    protected final ServiceMetadata serviceMetadata;
    protected EdmEntityType edmType;

    public JPATupleResultConverter(JPAServiceDocument sd, UriHelper uriHelper, ServiceMetadata serviceMetadata) {
        this.uriHelper = uriHelper;
        this.sd = sd;
        this.serviceMetadata = serviceMetadata;
    }

    protected String buildConcatenatedKey(Tuple row, List<JPAPath> leftColumns) {
        StringBuilder buffer = new StringBuilder();
        for (JPAPath item : leftColumns) {
            buffer.append("/");
            buffer.append(row.get(item.getAlias()));
        }
        buffer.deleteCharAt(0);
        return buffer.toString();
    }

    protected String buildPath(String prefix, JPAAssociationAttribute association) {
        return EMPTY_PREFIX.equals(prefix) ? association.getExternalName() : prefix + "/" + association.getExternalName();
    }

    protected void convertAttribute(Object value, JPAPath jpaPath, Map<String, ComplexValue> complexValueBuffer, List<Property> properties, Tuple parentRow, String prefix, @Nullable Entity odataEntity) throws ODataJPAModelException, ODataApplicationException {
        if (jpaPath != null) {
            JPAAttribute attribute = (JPAAttribute)jpaPath.getPath().get(0);
            if (attribute != null && !attribute.isKey() && attribute.isComplex()) {
                this.convertComplexAttribute(value, jpaPath.getAlias(), complexValueBuffer, properties, attribute, parentRow, prefix, odataEntity);
            } else if (attribute != null) {
                this.convertPrimitiveAttribute(value, properties, jpaPath, attribute, odataEntity);
            }
        }
    }

    protected void createComplexValue(Map<String, ComplexValue> complexValueBuffer, List<Property> properties, JPAAttribute attribute, Tuple parentRow, String bufferKey, String rootURI) throws ODataJPAModelException, ODataApplicationException {
        ComplexValue complexValue = new ComplexValue();
        complexValueBuffer.put(bufferKey, complexValue);
        properties.add(new Property(attribute.getStructuredType().getExternalFQN().getFullQualifiedNameAsString(), attribute.getExternalName(), ValueType.COMPLEX, (Object)complexValue));
        complexValue.getNavigationLinks().addAll(this.createExpand(attribute.getStructuredType(), parentRow, bufferKey, rootURI));
    }

    protected Collection<Link> createExpand(JPAStructuredType jpaStructuredType, Tuple row, String prefix, String rootURI) throws ODataApplicationException {
        ArrayList<Link> entityExpandLinks = new ArrayList<Link>();
        JPAAssociationPath path = null;
        try {
            for (JPAAssociationAttribute a : jpaStructuredType.getDeclaredAssociations()) {
                path = this.jpaConversionTargetEntity.getAssociationPath(this.buildPath(prefix, a));
                JPAExpandResult child = this.jpaQueryResult.getChild(path);
                String linkURI = rootURI + "/" + path.getAlias();
                if (child != null) {
                    entityExpandLinks.add(this.getLink(path, row, child, linkURI));
                    continue;
                }
                entityExpandLinks.add(this.getLink(path, linkURI));
            }
        }
        catch (ODataJPAModelException e) {
            throw new ODataJPAQueryException(ODataJPAQueryException.MessageKeys.QUERY_RESULT_NAVI_PROPERTY_ERROR, HttpStatusCode.INTERNAL_SERVER_ERROR, path != null ? path.getAlias() : EMPTY_PREFIX);
        }
        return entityExpandLinks;
    }

    protected final String determineAlias(String alias, String prefix) {
        if (EMPTY_PREFIX.equals(prefix)) {
            return alias;
        }
        return alias.substring(alias.indexOf(prefix) + prefix.length() + 1);
    }

    protected final JPAStructuredType determineCollectionRoot(JPAEntityType et, List<JPAElement> pathList) throws ODataJPAModelException {
        if (pathList.size() > 1) {
            return ((JPAAttribute)pathList.get(pathList.size() - 2)).getStructuredType();
        }
        return et;
    }

    protected final String determinePrefix(String alias) {
        String prefix = alias;
        int index = prefix.lastIndexOf("/");
        if (index < 0) {
            return EMPTY_PREFIX;
        }
        return prefix.substring(0, index);
    }

    String buildPath(JPAAttribute attribute, String prefix) {
        return EMPTY_PREFIX.equals(prefix) ? attribute.getExternalName() : prefix + "/" + attribute.getExternalName();
    }

    void convertComplexAttribute(Object value, String externalName, Map<String, ComplexValue> complexValueBuffer, List<Property> properties, JPAAttribute attribute, Tuple parentRow, String prefix, Entity odataEntity) throws ODataJPAModelException, ODataApplicationException {
        String bufferKey = this.buildPath(attribute, prefix);
        if (!complexValueBuffer.containsKey(bufferKey)) {
            this.createComplexValue(complexValueBuffer, properties, attribute, parentRow, bufferKey, odataEntity == null ? EMPTY_PREFIX : odataEntity.getId().toString());
        }
        List values = complexValueBuffer.get(bufferKey).getValue();
        int splitIndex = attribute.getExternalName().length() + "/".length();
        String attributeName = splitIndex < externalName.length() ? externalName.substring(splitIndex) : externalName;
        this.convertAttribute(value, attribute.getStructuredType().getPath(attributeName), complexValueBuffer, values, parentRow, this.buildPath(attribute, prefix), odataEntity);
    }

    <T, S> void convertPrimitiveAttribute(Object value, List<Property> properties, JPAPath jpaPath, JPAAttribute attribute, @Nullable Entity odataEntity) {
        Object odataValue;
        if (attribute != null && attribute.getConverter() != null) {
            AttributeConverter converter = attribute.getConverter();
            odataValue = converter.convertToDatabaseColumn(value);
        } else if (attribute != null && value != null && attribute.isEnum()) {
            odataValue = ((Enum)value).ordinal();
        } else {
            if (attribute != null && value != null && attribute.isCollection()) {
                return;
            }
            odataValue = value;
        }
        if (attribute != null && attribute.isKey() && attribute.isComplex()) {
            properties.add(new Property(null, jpaPath.getLeaf().getExternalName(), attribute.isEnum() ? ValueType.ENUM : ValueType.PRIMITIVE, odataValue));
        } else if (attribute != null) {
            properties.add(new Property(null, attribute.getExternalName(), attribute.isEnum() ? ValueType.ENUM : ValueType.PRIMITIVE, odataValue));
        }
    }

    Integer determineCount(JPAAssociationPath assoziation, Tuple parentRow, JPAExpandResult child) throws ODataJPAQueryException {
        try {
            Long count = child.getCount(this.buildConcatenatedKey(parentRow, assoziation.getLeftColumnsList()));
            return count != null ? Integer.valueOf(count.intValue()) : null;
        }
        catch (ODataJPAModelException e) {
            throw new ODataJPAQueryException(ODataJPAQueryException.MessageKeys.QUERY_RESULT_CONV_ERROR, HttpStatusCode.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
    }

    private Link getLink(JPAAssociationPath assoziation, Tuple parentRow, JPAExpandResult child, String linkURI) throws ODataApplicationException {
        Link link = new Link();
        link.setTitle(assoziation.getLeaf().getExternalName());
        link.setRel("http://docs.oasis-open.org/odata/ns/related/" + link.getTitle());
        link.setType(Constants.ENTITY_NAVIGATION_LINK_TYPE);
        try {
            EntityCollection expandCollection = ((JPAConvertableResult)((Object)child)).getEntityCollection(this.buildConcatenatedKey(parentRow, assoziation.getLeftColumnsList()));
            expandCollection.setCount(this.determineCount(assoziation, parentRow, child));
            if (assoziation.getLeaf().isCollection()) {
                link.setInlineEntitySet(expandCollection);
                link.setHref(linkURI);
            } else if (expandCollection.getEntities() != null && !expandCollection.getEntities().isEmpty()) {
                Entity expandEntity = (Entity)expandCollection.getEntities().get(0);
                link.setInlineEntity(expandEntity);
                link.setHref(linkURI);
            }
        }
        catch (ODataJPAModelException e) {
            throw new ODataJPAQueryException(ODataJPAQueryException.MessageKeys.QUERY_RESULT_CONV_ERROR, HttpStatusCode.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
        return link;
    }

    private Link getLink(JPAAssociationPath assoziation, String linkURI) {
        Link link = new Link();
        link.setTitle(assoziation.getLeaf().getExternalName());
        link.setRel("http://docs.oasis-open.org/odata/ns/related/" + link.getTitle());
        link.setType(Constants.ENTITY_NAVIGATION_LINK_TYPE);
        link.setHref(linkURI);
        return link;
    }
}

