/*
 * Decompiled with CFR 0.152.
 */
package com.sap.olingo.jpa.processor.core.database;

import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPADataBaseFunction;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAParameter;
import com.sap.olingo.jpa.metadata.core.edm.mapper.exception.ODataJPAModelException;
import com.sap.olingo.jpa.processor.core.api.JPAODataDatabaseProcessor;
import com.sap.olingo.jpa.processor.core.exception.ODataJPADBAdaptorException;
import com.sap.olingo.jpa.processor.core.exception.ODataJPAProcessorException;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.olingo.commons.api.edm.EdmElement;
import org.apache.olingo.commons.api.edm.EdmFunction;
import org.apache.olingo.commons.api.edm.EdmPrimitiveType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.api.http.HttpStatusCode;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.uri.UriParameter;
import org.apache.olingo.server.api.uri.UriResource;
import org.apache.olingo.server.api.uri.UriResourceEntitySet;
import org.apache.olingo.server.api.uri.UriResourceFunction;
import org.apache.olingo.server.api.uri.UriResourceKind;

public abstract class JPAAbstractDatabaseProcessor
implements JPAODataDatabaseProcessor {
    static final String FUNC_NAME_PLACEHOLDER = "$FUNCTIONNAME$";
    static final String PARAMETER_PLACEHOLDER = "$PARAMETER$";

    protected UriResourceEntitySet determineTargetEntitySet(List<UriResource> uriParts) {
        for (int i = uriParts.size() - 1; i >= 0; --i) {
            if (uriParts.get(i).getKind() != UriResourceKind.entitySet) continue;
            return (UriResourceEntitySet)uriParts.get(i);
        }
        return null;
    }

    protected <T> List<T> executeQuery(List<UriResource> uriParts, JPADataBaseFunction jpaFunction, EntityManager em, String pattern) throws ODataApplicationException {
        UriResourceFunction uriFunction = (UriResourceFunction)uriParts.get(uriParts.size() - 1);
        String queryString = this.generateQueryString(pattern, jpaFunction);
        Query functionQuery = em.createNativeQuery(queryString, jpaFunction.getResultParameter().getType());
        this.fillParameter(this.determineTargetEntitySet(uriParts), jpaFunction, uriFunction, functionQuery);
        return functionQuery.getResultList();
    }

    protected void fillParameter(UriResourceEntitySet es, JPADataBaseFunction jpaFunction, UriResourceFunction uriResourceFunction, Query functionQuery) throws ODataApplicationException {
        try {
            if (jpaFunction.isBound() && uriResourceFunction.getParameters().isEmpty()) {
                this.fillParameterFromEntity(jpaFunction, es, functionQuery);
            } else {
                this.fillParameterFromFunction(jpaFunction, uriResourceFunction, functionQuery);
            }
        }
        catch (ODataJPAModelException e) {
            throw new ODataJPAProcessorException(e, HttpStatusCode.INTERNAL_SERVER_ERROR);
        }
    }

    protected String generateQueryString(String queryPattern, JPADataBaseFunction jpaFunction) throws ODataJPAProcessorException {
        StringBuilder parameterList = new StringBuilder();
        String queryString = queryPattern.replace(FUNC_NAME_PLACEHOLDER, jpaFunction.getDBName());
        try {
            for (int i = 1; i <= jpaFunction.getParameter().size(); ++i) {
                parameterList.append(',');
                parameterList.append('?');
                parameterList.append(i);
            }
        }
        catch (ODataJPAModelException e) {
            throw new ODataJPAProcessorException(e, HttpStatusCode.INTERNAL_SERVER_ERROR);
        }
        parameterList.deleteCharAt(0);
        return queryString.replace(PARAMETER_PLACEHOLDER, parameterList.toString());
    }

    protected UriParameter findParameterByExternalName(JPAParameter parameter, List<UriParameter> uriParameters) throws ODataApplicationException {
        for (UriParameter uriParameter : uriParameters) {
            if (!uriParameter.getName().equals(parameter.getName())) continue;
            return uriParameter;
        }
        throw new ODataJPADBAdaptorException(ODataJPADBAdaptorException.MessageKeys.PARAMETER_MISSING, HttpStatusCode.BAD_REQUEST, parameter.getName());
    }

    protected void fillParameterFromEntity(JPADataBaseFunction jpaFunction, UriResourceEntitySet es, Query functionQuery) throws ODataApplicationException {
        int count = 1;
        try {
            for (JPAParameter parameter : jpaFunction.getParameter()) {
                UriParameter uriParameter = this.findParameterByExternalName(parameter, es.getKeyPredicates());
                Object value = this.getValue(es.getEntityType().getProperty(parameter.getName()), parameter, uriParameter.getText());
                functionQuery.setParameter(count, value);
                ++count;
            }
        }
        catch (ODataJPAModelException e) {
            throw new ODataJPAProcessorException(e, HttpStatusCode.INTERNAL_SERVER_ERROR);
        }
    }

    protected Long executeCountQuery(List<UriResource> uriParts, JPADataBaseFunction jpaFunction, EntityManager em, String pattern) throws ODataApplicationException {
        UriResourceFunction uriFunction = (UriResourceFunction)uriParts.get(uriParts.size() - 2);
        String queryString = this.generateQueryString(pattern, jpaFunction);
        Query functionQuery = em.createNativeQuery(queryString);
        this.fillParameter(this.determineTargetEntitySet(uriParts), jpaFunction, uriFunction, functionQuery);
        return (Long)functionQuery.getSingleResult();
    }

    protected void fillParameterFromFunction(JPADataBaseFunction jpaFunction, UriResourceFunction uriResourceFunction, Query functionQuery) throws ODataApplicationException {
        EdmFunction edmFunction = uriResourceFunction.getFunction();
        int count = 1;
        try {
            for (JPAParameter parameter : jpaFunction.getParameter()) {
                UriParameter uriParameter = this.findParameterByExternalName(parameter, uriResourceFunction.getParameters());
                Object value = this.getValue((EdmElement)edmFunction.getParameter(parameter.getName()), parameter, uriParameter.getText());
                functionQuery.setParameter(count, value);
                ++count;
            }
        }
        catch (ODataJPAModelException e) {
            throw new ODataJPAProcessorException(e, HttpStatusCode.INTERNAL_SERVER_ERROR);
        }
    }

    private Object getValue(EdmElement edmElement, JPAParameter parameter, String uriValue) throws ODataApplicationException {
        String value = uriValue.replaceAll("'", "");
        try {
            return ((EdmPrimitiveType)edmElement.getType()).valueOfString(value, Boolean.valueOf(false), parameter.getMaxLength(), parameter.getPrecision(), parameter.getScale(), Boolean.valueOf(true), parameter.getType());
        }
        catch (EdmPrimitiveTypeException e) {
            throw new ODataJPADBAdaptorException(ODataJPADBAdaptorException.MessageKeys.PARAMETER_CONVERSION_ERROR, HttpStatusCode.INTERNAL_SERVER_ERROR, uriValue, parameter.getName());
        }
    }
}

