/*
 * Decompiled with CFR 0.152.
 */
package com.sap.olingo.jpa.processor.core.database;

import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPADataBaseFunction;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAEntityType;
import com.sap.olingo.jpa.processor.core.database.JPAAbstractDatabaseProcessor;
import com.sap.olingo.jpa.processor.core.database.JPAODataDatabaseOperations;
import com.sap.olingo.jpa.processor.core.exception.ODataJPADBAdaptorException;
import com.sap.olingo.jpa.processor.core.exception.ODataJPAFilterException;
import com.sap.olingo.jpa.processor.core.exception.ODataJPAProcessorException;
import com.sap.olingo.jpa.processor.core.filter.JPAAggregationOperation;
import com.sap.olingo.jpa.processor.core.filter.JPAArithmeticOperator;
import com.sap.olingo.jpa.processor.core.filter.JPABooleanOperator;
import com.sap.olingo.jpa.processor.core.filter.JPAComparisonOperator;
import com.sap.olingo.jpa.processor.core.filter.JPAEnumerationBasedOperator;
import com.sap.olingo.jpa.processor.core.filter.JPAMethodCall;
import com.sap.olingo.jpa.processor.core.filter.JPAUnaryBooleanOperator;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.From;
import org.apache.olingo.commons.api.http.HttpStatusCode;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.uri.UriResource;
import org.apache.olingo.server.api.uri.UriResourceKind;
import org.apache.olingo.server.api.uri.queryoption.SearchOption;
import org.apache.olingo.server.api.uri.queryoption.expression.BinaryOperatorKind;

public class JPADefaultDatabaseProcessor
extends JPAAbstractDatabaseProcessor
implements JPAODataDatabaseOperations {
    private static final String SELECT_BASE_PATTERN = "SELECT * FROM $FUNCTIONNAME$($PARAMETER$)";
    private static final String SELECT_COUNT_PATTERN = "SELECT COUNT(*) FROM $FUNCTIONNAME$($PARAMETER$)";
    private CriteriaBuilder cb;

    @Override
    public Expression<Long> convert(JPAAggregationOperation jpaOperator) throws ODataApplicationException {
        throw new ODataJPAFilterException(ODataJPAFilterException.MessageKeys.NOT_SUPPORTED_OPERATOR, HttpStatusCode.NOT_IMPLEMENTED, jpaOperator.getName());
    }

    @Override
    public <T extends Number> Expression<T> convert(JPAArithmeticOperator jpaOperator) throws ODataApplicationException {
        throw new ODataJPAFilterException(ODataJPAFilterException.MessageKeys.NOT_SUPPORTED_OPERATOR, HttpStatusCode.NOT_IMPLEMENTED, jpaOperator.getName());
    }

    @Override
    public Expression<Boolean> convert(JPABooleanOperator jpaOperator) throws ODataApplicationException {
        throw new ODataJPAFilterException(ODataJPAFilterException.MessageKeys.NOT_SUPPORTED_OPERATOR, HttpStatusCode.NOT_IMPLEMENTED, jpaOperator.getName());
    }

    public Expression<Boolean> convert(JPAComparisonOperator jpaOperator) throws ODataApplicationException {
        if (jpaOperator.getOperator().equals(BinaryOperatorKind.HAS)) {
            Long n = ((JPAEnumerationBasedOperator)jpaOperator.getRight()).getValue().longValue();
            Expression div = this.cb.quot(jpaOperator.getLeft(), (Number)n);
            Expression mod = this.cb.mod(div, Integer.valueOf(2));
            return this.cb.equal(mod, (Object)1);
        }
        throw new ODataJPAFilterException(ODataJPAFilterException.MessageKeys.NOT_SUPPORTED_OPERATOR, HttpStatusCode.NOT_IMPLEMENTED, jpaOperator.getName());
    }

    @Override
    public <T> Expression<T> convert(JPAMethodCall jpaFunction) throws ODataApplicationException {
        throw new ODataJPAFilterException(ODataJPAFilterException.MessageKeys.NOT_SUPPORTED_OPERATOR, HttpStatusCode.NOT_IMPLEMENTED, jpaFunction.getName());
    }

    @Override
    public Expression<Boolean> convert(JPAUnaryBooleanOperator jpaOperator) throws ODataApplicationException {
        throw new ODataJPAFilterException(ODataJPAFilterException.MessageKeys.NOT_SUPPORTED_OPERATOR, HttpStatusCode.NOT_IMPLEMENTED, jpaOperator.getName());
    }

    @Override
    public Expression<Boolean> createSearchWhereClause(CriteriaBuilder cb, CriteriaQuery<?> cq, From<?, ?> root, JPAEntityType entityType, SearchOption searchOption) throws ODataApplicationException {
        throw new ODataJPADBAdaptorException(ODataJPADBAdaptorException.MessageKeys.NOT_SUPPORTED_SEARCH, HttpStatusCode.NOT_IMPLEMENTED);
    }

    @Override
    public <T> List<T> executeFunctionQuery(List<UriResource> uriResourceParts, JPADataBaseFunction jpaFunction, EntityManager em) throws ODataApplicationException {
        UriResource last = uriResourceParts.get(uriResourceParts.size() - 1);
        if (last.getKind() == UriResourceKind.count) {
            ArrayList<Long> countResult = new ArrayList<Long>();
            countResult.add(this.executeCountQuery(uriResourceParts, jpaFunction, em, SELECT_COUNT_PATTERN));
            return countResult;
        }
        if (last.getKind() == UriResourceKind.function) {
            return this.executeQuery(uriResourceParts, jpaFunction, em, SELECT_BASE_PATTERN);
        }
        throw new ODataJPAProcessorException(ODataJPAProcessorException.MessageKeys.NOT_SUPPORTED_FUNC_WITH_NAVI, HttpStatusCode.NOT_IMPLEMENTED);
    }

    @Override
    public void setCriterialBuilder(CriteriaBuilder cb) {
        this.cb = cb;
    }
}

