/*
 * Decompiled with CFR 0.152.
 */
package com.sap.olingo.jpa.processor.core.database;

import com.sap.olingo.jpa.processor.core.api.JPAODataDatabaseProcessor;
import com.sap.olingo.jpa.processor.core.database.JPADefaultDatabaseProcessor;
import com.sap.olingo.jpa.processor.core.database.JPA_HANA_DatabaseProcessor;
import com.sap.olingo.jpa.processor.core.database.JPA_HSQLDB_DatabaseProcessor;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import javax.sql.DataSource;

public class JPAODataDatabaseProcessorFactory {
    private static final String PRODUCT_NAME_H2 = "H2";
    private static final String PRODUCT_NAME_HSQLDB = "HSQL Database Engine";
    private static final String PRODUCT_NAME_SAP_HANA = "HDB";

    public JPAODataDatabaseProcessor create(DataSource ds) throws SQLException {
        if (ds != null) {
            try (Connection connection = ds.getConnection();){
                DatabaseMetaData dbMetadata = connection.getMetaData();
                if (dbMetadata.getDatabaseProductName().equals(PRODUCT_NAME_SAP_HANA)) {
                    JPA_HANA_DatabaseProcessor jPA_HANA_DatabaseProcessor = new JPA_HANA_DatabaseProcessor();
                    return jPA_HANA_DatabaseProcessor;
                }
                if (dbMetadata.getDatabaseProductName().equals(PRODUCT_NAME_HSQLDB)) {
                    JPA_HSQLDB_DatabaseProcessor jPA_HSQLDB_DatabaseProcessor = new JPA_HSQLDB_DatabaseProcessor();
                    return jPA_HSQLDB_DatabaseProcessor;
                }
                if (dbMetadata.getDatabaseProductName().equals(PRODUCT_NAME_H2)) {
                    JPA_HSQLDB_DatabaseProcessor jPA_HSQLDB_DatabaseProcessor = new JPA_HSQLDB_DatabaseProcessor();
                    return jPA_HSQLDB_DatabaseProcessor;
                }
                JPADefaultDatabaseProcessor jPADefaultDatabaseProcessor = new JPADefaultDatabaseProcessor();
                return jPADefaultDatabaseProcessor;
            }
        }
        return new JPADefaultDatabaseProcessor();
    }
}

