/*
 * Decompiled with CFR 0.152.
 */
package com.sap.olingo.jpa.processor.core.database;

import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPADataBaseFunction;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAElement;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAEntityType;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAParameter;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAPath;
import com.sap.olingo.jpa.metadata.core.edm.mapper.exception.ODataJPAModelException;
import com.sap.olingo.jpa.processor.core.api.JPAODataDatabaseProcessor;
import com.sap.olingo.jpa.processor.core.exception.ODataJPADBAdaptorException;
import com.sap.olingo.jpa.processor.core.exception.ODataJPAProcessorException;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Subquery;
import org.apache.olingo.commons.api.edm.EdmFunction;
import org.apache.olingo.commons.api.edm.EdmParameter;
import org.apache.olingo.commons.api.edm.EdmPrimitiveType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.api.http.HttpStatusCode;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.uri.UriParameter;
import org.apache.olingo.server.api.uri.UriResource;
import org.apache.olingo.server.api.uri.UriResourceFunction;
import org.apache.olingo.server.api.uri.queryoption.SearchOption;
import org.apache.olingo.server.api.uri.queryoption.search.SearchTerm;

@Deprecated
final class JPA_HANA_DatabaseProcessor
implements JPAODataDatabaseProcessor {
    private static final String SELECT_BASE_PATTERN = "SELECT * FROM $FUNCTIONNAME$($PARAMETER$)";
    private static final String SELECT_COUNT_PATTERN = "SELECT COUNT(*) FROM $FUNCTIONNAME$($PARAMETER$)";
    private static final String FUNC_NAME_PLACEHOLDER = "$FUNCTIONNAME$";
    private static final String PARAMETER_PLACEHOLDER = "$PARAMETER$";

    JPA_HANA_DatabaseProcessor() {
    }

    @Override
    public <T> List<T> executeFunctionQuery(List<UriResource> uriResourceParts, JPADataBaseFunction jpaFunction, EntityManager em) throws ODataApplicationException {
        UriResourceFunction uriResourceFunction = (UriResourceFunction)uriResourceParts.get(uriResourceParts.size() - 1);
        String queryString = this.generateQueryString(jpaFunction);
        Query functionQuery = em.createNativeQuery(queryString, jpaFunction.getResultParameter().getType());
        int count = 1;
        try {
            for (JPAParameter parameter : jpaFunction.getParameter()) {
                UriParameter uriParameter = this.findParameterByExternalName(parameter, uriResourceFunction.getParameters());
                Object value = this.getValue(uriResourceFunction.getFunction(), parameter, uriParameter.getText());
                functionQuery.setParameter(count, value);
                ++count;
            }
        }
        catch (ODataJPAModelException e) {
            throw new ODataJPAProcessorException(e, HttpStatusCode.INTERNAL_SERVER_ERROR);
        }
        return functionQuery.getResultList();
    }

    @Override
    public Expression<Boolean> createSearchWhereClause(CriteriaBuilder cb, CriteriaQuery<?> cq, From<?, ?> root, JPAEntityType entityType, SearchOption searchOption) throws ODataApplicationException {
        List searchableAttributes = null;
        JPAPath keyPath = null;
        try {
            searchableAttributes = entityType.getSearchablePath();
            List keyPathList = entityType.getKeyPath();
            if (keyPathList.size() != 1) {
                throw new ODataJPADBAdaptorException(ODataJPADBAdaptorException.MessageKeys.WRONG_NO_KEY_PROP, HttpStatusCode.INTERNAL_SERVER_ERROR);
            }
            keyPath = (JPAPath)keyPathList.get(0);
        }
        catch (ODataJPAModelException e) {
            throw new ODataJPADBAdaptorException(e, HttpStatusCode.INTERNAL_SERVER_ERROR);
        }
        if (!searchableAttributes.isEmpty()) {
            SearchTerm term = searchOption.getSearchExpression().asSearchTerm();
            Subquery sq = cq.subquery(entityType.getKeyType());
            Root sr = sq.from(root.getJavaType());
            Path sel = sr.get(((JPAElement)keyPath.getPath().get(0)).getInternalName());
            sq.select((Expression)sel);
            Root attributePath = sr;
            for (JPAPath searchableAttribute : searchableAttributes) {
                for (JPAElement pathItem : searchableAttribute.getPath()) {
                    attributePath = attributePath.get(pathItem.getInternalName());
                }
            }
            sq.where(cb.function("CONTAINS", Boolean.class, new Expression[]{attributePath, cb.literal((Object)term.getSearchTerm())}));
            return cb.in((Expression)root.get(((JPAElement)keyPath.getPath().get(0)).getInternalName())).value((Expression)sq);
        }
        return null;
    }

    private String generateQueryString(JPADataBaseFunction jpaFunction) throws ODataJPAProcessorException {
        StringBuilder parameterList = new StringBuilder();
        String queryString = SELECT_BASE_PATTERN;
        queryString = queryString.replace(FUNC_NAME_PLACEHOLDER, jpaFunction.getDBName());
        try {
            for (int i = 1; i <= jpaFunction.getParameter().size(); ++i) {
                parameterList.append(',');
                parameterList.append('?');
                parameterList.append(i);
            }
        }
        catch (ODataJPAModelException e) {
            throw new ODataJPAProcessorException(e, HttpStatusCode.INTERNAL_SERVER_ERROR);
        }
        parameterList.deleteCharAt(0);
        return queryString.replace(PARAMETER_PLACEHOLDER, parameterList.toString());
    }

    private UriParameter findParameterByExternalName(JPAParameter parameter, List<UriParameter> uriParameters) throws ODataApplicationException {
        for (UriParameter uriParameter : uriParameters) {
            if (!uriParameter.getName().equals(parameter.getName())) continue;
            return uriParameter;
        }
        throw new ODataJPADBAdaptorException(ODataJPADBAdaptorException.MessageKeys.PARAMETER_MISSING, HttpStatusCode.BAD_REQUEST, parameter.getName());
    }

    private Object getValue(EdmFunction edmFunction, JPAParameter parameter, String uriValue) throws ODataApplicationException {
        String value = uriValue.replaceAll("'", "");
        EdmParameter edmParam = edmFunction.getParameter(parameter.getName());
        try {
            return ((EdmPrimitiveType)edmParam.getType()).valueOfString(value, Boolean.valueOf(false), parameter.getMaxLength(), parameter.getPrecision(), parameter.getScale(), Boolean.valueOf(true), parameter.getType());
        }
        catch (EdmPrimitiveTypeException e) {
            throw new ODataJPADBAdaptorException(ODataJPADBAdaptorException.MessageKeys.PARAMETER_CONVERSION_ERROR, HttpStatusCode.NOT_IMPLEMENTED, uriValue, parameter.getName());
        }
    }
}

