/*
 * Decompiled with CFR 0.152.
 */
package com.sap.olingo.jpa.processor.core.exception;

import com.sap.olingo.jpa.metadata.core.edm.mapper.exception.ODataJPAMessageTextBuffer;
import java.util.Enumeration;
import java.util.Locale;
import org.apache.olingo.commons.api.http.HttpStatusCode;
import org.apache.olingo.server.api.ODataApplicationException;

public abstract class ODataJPAProcessException
extends ODataApplicationException {
    private static final long serialVersionUID = -3178033271311091314L;
    private static final String UNKNOWN_MESSAGE = "No message text found";
    private static Enumeration<Locale> locales;
    protected final String id;
    protected final String[] parameter;
    protected final String messageText;

    public ODataJPAProcessException(String id, HttpStatusCode statusCode) {
        this(id, null, statusCode, new String[0]);
    }

    public ODataJPAProcessException(Throwable cause, HttpStatusCode statusCode) {
        this(null, null, statusCode, cause, new String[0]);
    }

    public ODataJPAProcessException(String id, HttpStatusCode statusCode, Throwable cause) {
        this(id, null, statusCode, cause, new String[0]);
    }

    public ODataJPAProcessException(String id, HttpStatusCode statusCode, Throwable cause, String[] params) {
        this(id, null, statusCode, cause, params);
    }

    public ODataJPAProcessException(String id, HttpStatusCode statusCode, String[] params) {
        this(id, null, statusCode, params);
    }

    public ODataJPAProcessException(String id, String messageText, HttpStatusCode statusCode, String[] params) {
        this(id, messageText, statusCode, null, params);
    }

    public ODataJPAProcessException(String id, String messageText, HttpStatusCode statusCode, Throwable cause, String[] params) {
        super("", statusCode.getStatusCode(), Locale.ENGLISH, cause);
        this.id = id;
        this.parameter = params;
        this.messageText = messageText;
    }

    protected ODataJPAMessageTextBuffer getTextBundle() {
        if (this.getBundleName() != null) {
            return new ODataJPAMessageTextBuffer(this.getBundleName(), locales);
        }
        return null;
    }

    public String getLocalizedMessage() {
        return this.getMessage();
    }

    public String getMessage() {
        ODataJPAMessageTextBuffer messageBuffer = this.getTextBundle();
        if (messageBuffer != null && this.id != null) {
            String message = messageBuffer.getText((Object)this, this.id, this.parameter);
            if (message != null) {
                return message;
            }
            return this.messageText;
        }
        if (this.getCause() != null) {
            return this.getCause().getLocalizedMessage();
        }
        if (this.messageText != null && !this.messageText.isEmpty()) {
            return this.messageText;
        }
        return UNKNOWN_MESSAGE;
    }

    public String[] getParameter() {
        return this.parameter;
    }

    public String getId() {
        return this.id;
    }

    public static Enumeration<Locale> getLocales() {
        return locales;
    }

    public static void setLocales(Enumeration<Locale> locales) {
        ODataJPAProcessException.locales = locales;
    }

    protected abstract String getBundleName();
}

