/*
 * Decompiled with CFR 0.152.
 */
package com.sap.olingo.jpa.processor.core.filter;

import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAAssociationPath;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAEntityType;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAPath;
import com.sap.olingo.jpa.processor.core.exception.ODataJPAQueryException;
import com.sap.olingo.jpa.processor.core.filter.JPAFilterComplier;
import com.sap.olingo.jpa.processor.core.filter.JPAFilterComplierAccess;
import com.sap.olingo.jpa.processor.core.filter.JPAMemberVisitor;
import java.util.Collections;
import java.util.List;
import org.apache.olingo.commons.api.http.HttpStatusCode;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.uri.UriInfoResource;
import org.apache.olingo.server.api.uri.queryoption.expression.ExpressionVisitException;
import org.apache.olingo.server.api.uri.queryoption.expression.ExpressionVisitor;
import org.apache.olingo.server.api.uri.queryoption.expression.VisitableExpression;

public abstract class JPAAbstractFilter
implements JPAFilterComplier,
JPAFilterComplierAccess {
    final JPAEntityType jpaEntityType;
    final VisitableExpression expression;
    final JPAAssociationPath assoziation;

    public JPAAbstractFilter(JPAEntityType jpaEntityType, VisitableExpression expression) {
        this(jpaEntityType, expression, null);
    }

    public JPAAbstractFilter(JPAEntityType jpaEntityType, UriInfoResource uriResource, JPAAssociationPath assoziation) {
        this.jpaEntityType = jpaEntityType;
        this.expression = uriResource != null && uriResource.getFilterOption() != null ? uriResource.getFilterOption().getExpression() : null;
        this.assoziation = assoziation;
    }

    public JPAAbstractFilter(JPAEntityType jpaEntityType, VisitableExpression expression, JPAAssociationPath association) {
        this.jpaEntityType = jpaEntityType;
        this.expression = expression;
        this.assoziation = association;
    }

    @Override
    public List<JPAPath> getMember() throws ODataApplicationException {
        JPAMemberVisitor visitor = new JPAMemberVisitor(this.jpaEntityType);
        if (this.expression != null) {
            try {
                this.expression.accept((ExpressionVisitor)visitor);
            }
            catch (ExpressionVisitException e) {
                throw new ODataJPAQueryException(e, HttpStatusCode.INTERNAL_SERVER_ERROR);
            }
            return Collections.unmodifiableList(visitor.get());
        }
        return Collections.emptyList();
    }

    @Override
    public JPAAssociationPath getAssoziation() {
        return this.assoziation;
    }
}

