/*
 * Decompiled with CFR 0.152.
 */
package com.sap.olingo.jpa.processor.core.filter;

import com.sap.olingo.jpa.processor.core.exception.ODataJPAFilterException;
import com.sap.olingo.jpa.processor.core.filter.JPAArithmeticOperator;
import com.sap.olingo.jpa.processor.core.filter.JPAFunctionOperator;
import com.sap.olingo.jpa.processor.core.filter.JPALiteralOperator;
import com.sap.olingo.jpa.processor.core.filter.JPAMemberOperator;
import com.sap.olingo.jpa.processor.core.filter.JPAOperationConverter;
import com.sap.olingo.jpa.processor.core.filter.JPAOperator;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import org.apache.olingo.commons.api.http.HttpStatusCode;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.uri.queryoption.expression.BinaryOperatorKind;

class JPAArithmeticOperatorImp
implements JPAArithmeticOperator {
    private final JPAOperationConverter converter;
    private final BinaryOperatorKind operator;
    private final JPAOperator left;
    private final JPAOperator right;

    public JPAArithmeticOperatorImp(JPAOperationConverter converter, BinaryOperatorKind operator, JPAOperator left, JPAOperator right) {
        this.converter = converter;
        this.operator = operator;
        this.left = left;
        this.right = right;
    }

    @Override
    public Expression<Number> get() throws ODataApplicationException {
        return this.converter.convert(this);
    }

    @Override
    public BinaryOperatorKind getOperator() {
        return this.operator;
    }

    @Override
    public Object getRight() {
        if (this.left instanceof JPALiteralOperator) {
            return this.left;
        }
        return this.right;
    }

    @Override
    public Expression<Number> getLeft(CriteriaBuilder cb) throws ODataApplicationException {
        if (this.left instanceof JPALiteralOperator) {
            if (this.right instanceof JPALiteralOperator) {
                return cb.literal((Object)((Number)this.left.get()));
            }
            return (Expression)this.right.get();
        }
        return (Expression)this.left.get();
    }

    @Override
    public Number getRightAsNumber(CriteriaBuilder cb) throws ODataApplicationException {
        if (this.left instanceof JPALiteralOperator) {
            if (this.right instanceof JPALiteralOperator) {
                return (Number)this.right.get();
            }
            if (this.right instanceof JPAMemberOperator) {
                return (Number)((JPALiteralOperator)this.left).get(((JPAMemberOperator)this.right).determineAttribute());
            }
            throw new ODataJPAFilterException(ODataJPAFilterException.MessageKeys.NOT_SUPPORTED_OPERATOR_TYPE, HttpStatusCode.NOT_IMPLEMENTED);
        }
        if (this.left instanceof JPAMemberOperator) {
            if (this.right instanceof JPALiteralOperator) {
                return (Number)((JPALiteralOperator)this.right).get(((JPAMemberOperator)this.left).determineAttribute());
            }
            throw new ODataJPAFilterException(ODataJPAFilterException.MessageKeys.NOT_SUPPORTED_OPERATOR_TYPE, HttpStatusCode.NOT_IMPLEMENTED);
        }
        if (this.left instanceof JPAFunctionOperator) {
            if (this.right instanceof JPALiteralOperator) {
                return (Number)((JPALiteralOperator)this.right).get(((JPAFunctionOperator)this.left).getReturnType());
            }
            throw new ODataJPAFilterException(ODataJPAFilterException.MessageKeys.NOT_SUPPORTED_OPERATOR_TYPE, HttpStatusCode.NOT_IMPLEMENTED);
        }
        throw new ODataJPAFilterException(ODataJPAFilterException.MessageKeys.NOT_SUPPORTED_OPERATOR_TYPE, HttpStatusCode.NOT_IMPLEMENTED);
    }

    @Override
    public Expression<Number> getRightAsExpression() throws ODataApplicationException {
        return ((JPAMemberOperator)this.right).get();
    }

    @Override
    public Expression<Integer> getLeftAsIntExpression() throws ODataApplicationException {
        if (this.left instanceof JPALiteralOperator) {
            return (Expression)this.right.get();
        }
        return (Expression)this.left.get();
    }

    @Override
    public Expression<Integer> getRightAsIntExpression() throws ODataApplicationException {
        return ((JPAMemberOperator)this.right).get();
    }

    @Override
    public String getName() {
        return this.operator.name();
    }
}

