/*
 * Decompiled with CFR 0.152.
 */
package com.sap.olingo.jpa.processor.core.filter;

import com.sap.olingo.jpa.processor.core.filter.JPAComparisonOperator;
import com.sap.olingo.jpa.processor.core.filter.JPALiteralOperator;
import com.sap.olingo.jpa.processor.core.filter.JPAMemberOperator;
import com.sap.olingo.jpa.processor.core.filter.JPAOperationConverter;
import com.sap.olingo.jpa.processor.core.filter.JPAOperator;
import javax.persistence.criteria.Expression;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.uri.queryoption.expression.BinaryOperatorKind;

public class JPAComparisonOperatorImp<T extends Comparable<T>>
implements JPAComparisonOperator<T> {
    private final JPAOperationConverter converter;
    private final BinaryOperatorKind operator;
    private final JPAOperator left;
    private final JPAOperator right;

    public JPAComparisonOperatorImp(JPAOperationConverter converter, BinaryOperatorKind operator, JPAOperator left, JPAOperator right) {
        this.converter = converter;
        this.operator = operator;
        this.left = left;
        this.right = right;
    }

    @Override
    public Expression<Boolean> get() throws ODataApplicationException {
        return this.converter.convert(this);
    }

    public BinaryOperatorKind getOperator() {
        return this.operator;
    }

    @Override
    public Expression<T> getLeft() throws ODataApplicationException {
        if (this.left instanceof JPALiteralOperator) {
            return (Expression)this.right.get();
        }
        return (Expression)this.left.get();
    }

    @Override
    public Object getRight() {
        if (this.left instanceof JPALiteralOperator) {
            return this.left;
        }
        return this.right;
    }

    @Override
    public Comparable<T> getRightAsComparable() throws ODataApplicationException {
        if (this.left instanceof JPALiteralOperator) {
            if (this.right instanceof JPAMemberOperator) {
                return (Comparable)((JPALiteralOperator)this.left).get(((JPAMemberOperator)this.right).determineAttribute());
            }
            return (Comparable)this.left.get();
        }
        if (this.right instanceof JPALiteralOperator) {
            if (this.left instanceof JPAMemberOperator) {
                return (Comparable)((JPALiteralOperator)this.right).get(((JPAMemberOperator)this.left).determineAttribute());
            }
            return (Comparable)this.right.get();
        }
        return (Comparable)this.right.get();
    }

    @Override
    public Expression<T> getRightAsExpression() throws ODataApplicationException {
        return (Expression)this.right.get();
    }

    @Override
    public String getName() {
        return this.operator.name();
    }
}

