/*
 * Decompiled with CFR 0.152.
 */
package com.sap.olingo.jpa.processor.core.filter;

import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAEnumerationAttribute;
import com.sap.olingo.jpa.metadata.core.edm.mapper.exception.ODataJPAModelException;
import com.sap.olingo.jpa.processor.core.exception.ODataJPAFilterException;
import com.sap.olingo.jpa.processor.core.filter.JPAEnumerationBasedOperator;
import java.util.List;
import org.apache.olingo.commons.api.http.HttpStatusCode;
import org.apache.olingo.server.api.ODataApplicationException;

public final class JPAEnumerationOperator
implements JPAEnumerationBasedOperator {
    private final JPAEnumerationAttribute jpaAttribute;
    private final List<String> value;

    JPAEnumerationOperator(JPAEnumerationAttribute jpaEnumerationAttribute, List<String> enumValues) {
        this.jpaAttribute = jpaEnumerationAttribute;
        this.value = enumValues;
    }

    @Override
    public Object get() throws ODataApplicationException {
        try {
            return this.jpaAttribute.convert(this.value);
        }
        catch (ODataJPAModelException e) {
            throw new ODataJPAFilterException(e, HttpStatusCode.INTERNAL_SERVER_ERROR);
        }
    }

    @Override
    public boolean isNull() {
        return this.value == null;
    }

    @Override
    public Number getValue() throws ODataJPAFilterException {
        try {
            return this.jpaAttribute.valueOf(this.value);
        }
        catch (ODataJPAModelException e) {
            throw new ODataJPAFilterException(e, HttpStatusCode.INTERNAL_SERVER_ERROR);
        }
    }

    @Override
    public String getName() {
        return "";
    }
}

