/*
 * Decompiled with CFR 0.152.
 */
package com.sap.olingo.jpa.processor.core.filter;

import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAServiceDocument;
import com.sap.olingo.jpa.processor.core.api.JPAODataClaimProvider;
import com.sap.olingo.jpa.processor.core.filter.JPAFilterComplierAccess;
import com.sap.olingo.jpa.processor.core.filter.JPAOperationConverter;
import com.sap.olingo.jpa.processor.core.filter.JPAOperator;
import com.sap.olingo.jpa.processor.core.query.JPAAbstractQuery;
import com.sap.olingo.jpa.processor.core.query.JPANavigationProptertyInfo;
import com.sap.olingo.jpa.processor.core.query.Util;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.persistence.EntityManager;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Subquery;
import org.apache.olingo.server.api.OData;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.uri.UriResource;
import org.apache.olingo.server.api.uri.UriResourceComplexProperty;
import org.apache.olingo.server.api.uri.UriResourceEntitySet;
import org.apache.olingo.server.api.uri.UriResourceNavigation;
import org.apache.olingo.server.api.uri.UriResourcePartTyped;
import org.apache.olingo.server.api.uri.UriResourceProperty;

abstract class JPAExistsOperation
implements JPAOperator {
    protected final JPAOperationConverter converter;
    protected final List<UriResource> uriResourceParts;
    protected final JPAAbstractQuery root;
    protected final JPAServiceDocument sd;
    protected final EntityManager em;
    protected final OData odata;
    protected final From<?, ?> from;
    protected final Optional<JPAODataClaimProvider> claimsProvider;
    protected final List<String> groups;

    JPAExistsOperation(JPAFilterComplierAccess jpaComplier) {
        this.uriResourceParts = jpaComplier.getUriResourceParts();
        this.root = jpaComplier.getParent();
        this.sd = jpaComplier.getSd();
        this.em = jpaComplier.getEntityManager();
        this.converter = jpaComplier.getConverter();
        this.odata = jpaComplier.getOdata();
        this.from = jpaComplier.getRoot();
        this.claimsProvider = jpaComplier.getClaimsProvider();
        this.groups = jpaComplier.getGroups();
    }

    public Expression<Boolean> get() throws ODataApplicationException {
        return this.converter.cb.exists(this.getExistsQuery());
    }

    abstract Subquery<?> getExistsQuery() throws ODataApplicationException;

    protected List<JPANavigationProptertyInfo> determineAssoziations(JPAServiceDocument sd, List<UriResource> resourceParts) throws ODataApplicationException {
        ArrayList<JPANavigationProptertyInfo> pathList;
        block8: {
            UriResourceNavigation navigation;
            StringBuilder associationName;
            block7: {
                pathList = new ArrayList<JPANavigationProptertyInfo>();
                associationName = null;
                navigation = null;
                if (resourceParts == null || !Util.hasNavigation(resourceParts)) break block7;
                for (int i = resourceParts.size() - 1; i >= 0; --i) {
                    UriResource resourcePart = resourceParts.get(i);
                    if (resourcePart instanceof UriResourceNavigation) {
                        if (navigation != null) {
                            pathList.add(new JPANavigationProptertyInfo(sd, (UriResourcePartTyped)navigation, Util.determineAssoziationPath(sd, (UriResourcePartTyped)resourceParts.get(i), associationName), null));
                        }
                        navigation = (UriResourceNavigation)resourceParts.get(i);
                        associationName = new StringBuilder();
                        associationName.insert(0, navigation.getProperty().getName());
                    }
                    if (navigation == null) continue;
                    if (resourceParts.get(i) instanceof UriResourceComplexProperty) {
                        associationName.insert(0, "/");
                        associationName.insert(0, ((UriResourceComplexProperty)resourceParts.get(i)).getProperty().getName());
                    }
                    if (!(resourcePart instanceof UriResourceEntitySet)) continue;
                    pathList.add(new JPANavigationProptertyInfo(sd, (UriResourcePartTyped)navigation, Util.determineAssoziationPath(sd, (UriResourcePartTyped)resourceParts.get(i), associationName), null));
                }
                break block8;
            }
            if (resourceParts == null || !this.hasCollection(resourceParts)) break block8;
            for (int i = resourceParts.size() - 1; i >= 0; --i) {
                UriResource resourcePart = resourceParts.get(i);
                if (this.isCollection(resourcePart)) {
                    navigation = (UriResourcePartTyped)resourceParts.get(i);
                    associationName = new StringBuilder();
                    associationName.insert(0, ((UriResourceProperty)navigation).getProperty().getName());
                    continue;
                }
                if (navigation == null) continue;
                if (resourceParts.get(i) instanceof UriResourceComplexProperty) {
                    associationName.insert(0, "/");
                    associationName.insert(0, ((UriResourceComplexProperty)resourceParts.get(i)).getProperty().getName());
                }
                if (!(resourcePart instanceof UriResourceEntitySet)) continue;
                pathList.add(new JPANavigationProptertyInfo(sd, (UriResourcePartTyped)navigation, Util.determineAssoziationPath(sd, (UriResourcePartTyped)resourceParts.get(i), associationName), null));
            }
        }
        return pathList;
    }

    public boolean hasCollection(List<UriResource> resourceParts) {
        if (resourceParts != null) {
            for (int i = resourceParts.size() - 1; i >= 0; --i) {
                if (!this.isCollection(resourceParts.get(i))) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isCollection(UriResource resourcePart) {
        return resourcePart instanceof UriResourceProperty && ((UriResourceProperty)resourcePart).isCollection();
    }
}

