/*
 * Decompiled with CFR 0.152.
 */
package com.sap.olingo.jpa.processor.core.filter;

import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAAssociationPath;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAEntityType;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAServiceDocument;
import com.sap.olingo.jpa.processor.core.api.JPAODataClaimProvider;
import com.sap.olingo.jpa.processor.core.api.JPAODataGroupProvider;
import com.sap.olingo.jpa.processor.core.api.JPAODataRequestContextAccess;
import com.sap.olingo.jpa.processor.core.api.JPAServiceDebugger;
import com.sap.olingo.jpa.processor.core.filter.JPAAbstractFilter;
import com.sap.olingo.jpa.processor.core.filter.JPAOperationConverter;
import com.sap.olingo.jpa.processor.core.filter.JPAOperator;
import com.sap.olingo.jpa.processor.core.filter.JPAVisitor;
import com.sap.olingo.jpa.processor.core.query.JPAAbstractQuery;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.persistence.EntityManager;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.From;
import org.apache.olingo.server.api.OData;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.uri.UriResource;
import org.apache.olingo.server.api.uri.queryoption.expression.ExpressionVisitException;
import org.apache.olingo.server.api.uri.queryoption.expression.ExpressionVisitor;

public final class JPAFilterCrossComplier
extends JPAAbstractFilter {
    final JPAOperationConverter converter;
    final EntityManager em;
    final OData odata;
    final JPAServiceDocument sd;
    final List<UriResource> uriResourceParts;
    final JPAAbstractQuery parent;
    final Optional<JPAODataClaimProvider> claimsProvider;
    final List<String> groups;
    private From<?, ?> root;

    public JPAFilterCrossComplier(OData odata, JPAServiceDocument sd, JPAEntityType jpaEntityType, JPAOperationConverter converter, JPAAbstractQuery parent, From<?, ?> from, JPAAssociationPath assization, JPAODataRequestContextAccess requestContext) {
        this(odata, sd, jpaEntityType, converter, parent, assization, requestContext);
        this.root = from;
    }

    public JPAFilterCrossComplier(OData odata, JPAServiceDocument sd, JPAEntityType jpaEntityType, JPAOperationConverter converter, JPAAbstractQuery parent, JPAAssociationPath assization, JPAODataRequestContextAccess requestContext) {
        super(jpaEntityType, requestContext.getUriInfo(), assization);
        Optional<JPAODataGroupProvider> groupsProvider = requestContext.getGroupsProvider();
        this.uriResourceParts = requestContext.getUriInfo().getUriResourceParts();
        this.converter = converter;
        this.em = requestContext.getEntityManager();
        this.odata = odata;
        this.sd = sd;
        this.parent = parent;
        this.claimsProvider = requestContext.getClaimsProvider();
        this.groups = groupsProvider.isPresent() ? groupsProvider.get().getGroups() : Collections.emptyList();
    }

    @Override
    public Expression<Boolean> compile() throws ExpressionVisitException, ODataApplicationException {
        int handle = this.parent.getDebugger().startRuntimeMeasurement("JPAFilterCrossComplier", "compile");
        if (this.expression == null) {
            this.parent.getDebugger().stopRuntimeMeasurement(handle);
            return null;
        }
        JPAVisitor visitor = new JPAVisitor(this);
        Expression finalExpression = (Expression)((JPAOperator)this.expression.accept((ExpressionVisitor)visitor)).get();
        this.parent.getDebugger().stopRuntimeMeasurement(handle);
        return finalExpression;
    }

    @Override
    public Optional<JPAODataClaimProvider> getClaimsProvider() {
        return this.claimsProvider;
    }

    @Override
    public JPAOperationConverter getConverter() {
        return this.converter;
    }

    @Override
    public JPAServiceDebugger getDebugger() {
        return this.parent.getDebugger();
    }

    @Override
    public EntityManager getEntityManager() {
        return this.em;
    }

    @Override
    public JPAEntityType getJpaEntityType() {
        return this.jpaEntityType;
    }

    @Override
    public OData getOdata() {
        return this.odata;
    }

    @Override
    public JPAAbstractQuery getParent() {
        return this.parent;
    }

    @Override
    public From<?, ?> getRoot() {
        if (this.root == null) {
            return this.parent.getRoot();
        }
        return this.root;
    }

    @Override
    public JPAServiceDocument getSd() {
        return this.sd;
    }

    @Override
    public List<UriResource> getUriResourceParts() {
        return this.uriResourceParts;
    }

    @Override
    public List<String> getGroups() {
        return this.groups;
    }
}

