/*
 * Decompiled with CFR 0.152.
 */
package com.sap.olingo.jpa.processor.core.filter;

import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAAssociationPath;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAEntityType;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAServiceDocument;
import com.sap.olingo.jpa.processor.core.api.JPAODataClaimProvider;
import com.sap.olingo.jpa.processor.core.api.JPAServiceDebugger;
import com.sap.olingo.jpa.processor.core.filter.JPAAbstractFilter;
import com.sap.olingo.jpa.processor.core.filter.JPAOperationConverter;
import com.sap.olingo.jpa.processor.core.filter.JPAOperator;
import com.sap.olingo.jpa.processor.core.filter.JPAVisitor;
import com.sap.olingo.jpa.processor.core.query.JPAAbstractQuery;
import java.util.List;
import java.util.Optional;
import javax.persistence.EntityManager;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.From;
import org.apache.olingo.server.api.OData;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.uri.UriResource;
import org.apache.olingo.server.api.uri.queryoption.expression.ExpressionVisitException;
import org.apache.olingo.server.api.uri.queryoption.expression.ExpressionVisitor;
import org.apache.olingo.server.api.uri.queryoption.expression.VisitableExpression;

public final class JPAFilterElementComplier
extends JPAAbstractFilter {
    final JPAOperationConverter converter;
    final EntityManager em;
    final OData odata;
    final JPAServiceDocument sd;
    final List<UriResource> uriResourceParts;
    final JPAAbstractQuery parent;
    final List<String> groups;

    public JPAFilterElementComplier(OData odata, JPAServiceDocument sd, EntityManager em, JPAEntityType jpaEntityType, JPAOperationConverter converter, List<UriResource> uriResourceParts, JPAAbstractQuery parent, VisitableExpression expression, JPAAssociationPath association, List<String> groups) {
        super(jpaEntityType, expression, association);
        this.converter = converter;
        this.em = em;
        this.odata = odata;
        this.sd = sd;
        this.uriResourceParts = uriResourceParts;
        this.parent = parent;
        this.groups = groups;
    }

    @Override
    public Expression<Boolean> compile() throws ExpressionVisitException, ODataApplicationException {
        int handle = this.parent.getDebugger().startRuntimeMeasurement("JPAFilterCrossComplier", "compile");
        JPAVisitor visitor = new JPAVisitor(this);
        Expression finalExpression = (Expression)((JPAOperator)this.expression.accept((ExpressionVisitor)visitor)).get();
        this.parent.getDebugger().stopRuntimeMeasurement(handle);
        return finalExpression;
    }

    @Override
    public JPAOperationConverter getConverter() {
        return this.converter;
    }

    @Override
    public JPAEntityType getJpaEntityType() {
        return this.jpaEntityType;
    }

    @Override
    public EntityManager getEntityManager() {
        return this.em;
    }

    @Override
    public OData getOdata() {
        return this.odata;
    }

    @Override
    public JPAServiceDocument getSd() {
        return this.sd;
    }

    @Override
    public List<UriResource> getUriResourceParts() {
        return this.uriResourceParts;
    }

    @Override
    public JPAAbstractQuery getParent() {
        return this.parent;
    }

    public VisitableExpression getExpressionMember() {
        return this.expression;
    }

    @Override
    public From<?, ?> getRoot() {
        return this.parent.getRoot();
    }

    @Override
    public JPAServiceDebugger getDebugger() {
        return this.parent.getDebugger();
    }

    @Override
    public Optional<JPAODataClaimProvider> getClaimsProvider() {
        return Optional.empty();
    }

    @Override
    public List<String> getGroups() {
        return this.groups;
    }
}

