/*
 * Decompiled with CFR 0.152.
 */
package com.sap.olingo.jpa.processor.core.filter;

import com.sap.olingo.jpa.processor.core.filter.JPAVisitableExpression;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.uri.UriInfoResource;
import org.apache.olingo.server.api.uri.queryoption.expression.BinaryOperatorKind;
import org.apache.olingo.server.api.uri.queryoption.expression.ExpressionVisitException;
import org.apache.olingo.server.api.uri.queryoption.expression.ExpressionVisitor;
import org.apache.olingo.server.api.uri.queryoption.expression.Literal;
import org.apache.olingo.server.api.uri.queryoption.expression.Member;

public final class JPAFilterExpression
implements JPAVisitableExpression {
    private Literal literal;
    private BinaryOperatorKind operator;
    private final Member member;

    public JPAFilterExpression(Member member, Literal literal, BinaryOperatorKind operator) {
        this.literal = literal;
        this.operator = operator;
        this.member = member;
    }

    public <T> T accept(ExpressionVisitor<T> visitor) throws ExpressionVisitException, ODataApplicationException {
        Object left = visitor.visitMember(this.member);
        Object right = visitor.visitLiteral(this.literal);
        return (T)visitor.visitBinaryOperator(this.operator, left, right);
    }

    @Override
    public UriInfoResource getMember() {
        return this.member.getResourcePath();
    }

    public String toString() {
        return "JPAFilterExpression [literal=" + this.literal + ", operator=" + this.operator + ", member=[resourcePath=" + this.member.getResourcePath().getUriResourceParts() + ", startTypeFilter= " + this.member.getStartTypeFilter() + ", type= " + this.member.getType() + "]]";
    }
}

