/*
 * Decompiled with CFR 0.152.
 */
package com.sap.olingo.jpa.processor.core.filter;

import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPADataBaseFunction;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAOperationResultParameter;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAParameter;
import com.sap.olingo.jpa.metadata.core.edm.mapper.exception.ODataJPAModelException;
import com.sap.olingo.jpa.metadata.core.edm.mapper.impl.JPATypeConvertor;
import com.sap.olingo.jpa.processor.core.exception.ODataJPAFilterException;
import com.sap.olingo.jpa.processor.core.exception.ODataJPAProcessorException;
import com.sap.olingo.jpa.processor.core.filter.JPALiteralOperator;
import com.sap.olingo.jpa.processor.core.filter.JPAOperator;
import com.sap.olingo.jpa.processor.core.filter.JPAVisitor;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.commons.api.http.HttpStatusCode;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.uri.UriParameter;
import org.apache.olingo.server.api.uri.queryoption.expression.ExpressionVisitException;
import org.apache.olingo.server.api.uri.queryoption.expression.ExpressionVisitor;
import org.apache.olingo.server.api.uri.queryoption.expression.Literal;

final class JPAFunctionOperator
implements JPAOperator {
    private final JPADataBaseFunction jpaFunction;
    private final JPAVisitor visitor;
    private final List<UriParameter> uriParams;

    public JPAFunctionOperator(JPAVisitor jpaVisitor, List<UriParameter> uriParams, JPADataBaseFunction jpaFunction) {
        this.uriParams = uriParams;
        this.visitor = jpaVisitor;
        this.jpaFunction = jpaFunction;
    }

    public Expression<?> get() throws ODataApplicationException {
        List parameters;
        if (this.jpaFunction.getResultParameter().isCollection()) {
            throw new ODataJPAFilterException(ODataJPAFilterException.MessageKeys.NOT_SUPPORTED_FUNCTION_COLLECTION, HttpStatusCode.NOT_IMPLEMENTED);
        }
        if (!JPATypeConvertor.isScalarType((Class)this.jpaFunction.getResultParameter().getType())) {
            throw new ODataJPAFilterException(ODataJPAFilterException.MessageKeys.NOT_SUPPORTED_FUNCTION_NOT_SCALAR, HttpStatusCode.NOT_IMPLEMENTED);
        }
        CriteriaBuilder cb = this.visitor.getCriteriaBuilder();
        try {
            parameters = this.jpaFunction.getParameter();
        }
        catch (ODataJPAModelException e) {
            throw new ODataJPAProcessorException(e, HttpStatusCode.INTERNAL_SERVER_ERROR);
        }
        Expression[] jpaParameter = new Expression[parameters.size()];
        for (int i = 0; i < parameters.size(); ++i) {
            UriParameter p = this.findUriParameter((JPAParameter)parameters.get(i));
            if (p != null && p.getText() != null) {
                JPALiteralOperator operator = new JPALiteralOperator(this.visitor.getOdata(), new ParameterLiteral(p.getText()));
                jpaParameter[i] = cb.literal(operator.get((JPAParameter)parameters.get(i)));
                continue;
            }
            try {
                jpaParameter[i] = (Expression)((JPAOperator)p.getExpression().accept((ExpressionVisitor)this.visitor)).get();
                continue;
            }
            catch (ExpressionVisitException e) {
                throw new ODataJPAFilterException(e, HttpStatusCode.NOT_IMPLEMENTED);
            }
        }
        return cb.function(this.jpaFunction.getDBName(), this.jpaFunction.getResultParameter().getType(), jpaParameter);
    }

    private UriParameter findUriParameter(JPAParameter jpaFunctionParam) {
        for (UriParameter uriParam : this.uriParams) {
            if (!uriParam.getName().equals(jpaFunctionParam.getName())) continue;
            return uriParam;
        }
        return null;
    }

    public JPAOperationResultParameter getReturnType() {
        return this.jpaFunction.getResultParameter();
    }

    @Override
    public String getName() {
        return this.jpaFunction.getDBName();
    }

    private class ParameterLiteral
    implements Literal {
        private final String text;

        public ParameterLiteral(String text) {
            this.text = text;
        }

        public <T> T accept(ExpressionVisitor<T> visitor) throws ExpressionVisitException, ODataApplicationException {
            return null;
        }

        public String getText() {
            return this.text;
        }

        public EdmType getType() {
            return null;
        }
    }
}

