/*
 * Decompiled with CFR 0.152.
 */
package com.sap.olingo.jpa.processor.core.filter;

import com.sap.olingo.jpa.processor.core.api.JPAODataClaimProvider;
import com.sap.olingo.jpa.processor.core.filter.JPAExistsOperation;
import com.sap.olingo.jpa.processor.core.filter.JPAFilterComplierAccess;
import com.sap.olingo.jpa.processor.core.query.JPAAbstractQuery;
import com.sap.olingo.jpa.processor.core.query.JPACollectionFilterQuery;
import com.sap.olingo.jpa.processor.core.query.JPANavigationFilterQuery;
import com.sap.olingo.jpa.processor.core.query.JPANavigationProptertyInfo;
import com.sap.olingo.jpa.processor.core.query.JPANavigationQuery;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.persistence.criteria.Subquery;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.uri.UriInfoResource;
import org.apache.olingo.server.api.uri.UriResource;
import org.apache.olingo.server.api.uri.UriResourceKind;
import org.apache.olingo.server.api.uri.UriResourceLambdaAll;
import org.apache.olingo.server.api.uri.UriResourceLambdaAny;
import org.apache.olingo.server.api.uri.UriResourceProperty;
import org.apache.olingo.server.api.uri.queryoption.expression.Expression;
import org.apache.olingo.server.api.uri.queryoption.expression.Member;
import org.apache.olingo.server.api.uri.queryoption.expression.VisitableExpression;

abstract class JPALambdaOperation
extends JPAExistsOperation {
    protected final UriInfoResource member;

    JPALambdaOperation(JPAFilterComplierAccess jpaComplier, UriInfoResource member) {
        super(jpaComplier);
        this.member = member;
    }

    public JPALambdaOperation(JPAFilterComplierAccess jpaComplier, Member member) {
        super(jpaComplier);
        this.member = member.getResourcePath();
    }

    @Override
    protected Subquery<?> getExistsQuery() throws ODataApplicationException {
        return this.getSubQuery(this.determineExpression());
    }

    protected final Subquery<?> getSubQuery(Expression expression) throws ODataApplicationException {
        ArrayList<UriResource> allUriResourceParts = new ArrayList<UriResource>(this.uriResourceParts);
        allUriResourceParts.addAll(this.member.getUriResourceParts());
        List<JPANavigationProptertyInfo> naviPathList = this.determineAssoziations(this.sd, allUriResourceParts);
        JPAAbstractQuery parent = this.root;
        ArrayList<JPANavigationQuery> queryList = new ArrayList<JPANavigationQuery>();
        for (int i = naviPathList.size() - 1; i >= 0; --i) {
            JPANavigationProptertyInfo naviInfo = naviPathList.get(i);
            if (i == 0) {
                if (naviInfo.getUriResiource() instanceof UriResourceProperty) {
                    queryList.add(new JPACollectionFilterQuery(this.odata, this.sd, this.em, parent, this.member.getUriResourceParts(), (VisitableExpression)expression, this.from, (List<String>)this.groups));
                } else {
                    queryList.add(new JPANavigationFilterQuery(this.odata, this.sd, (UriResource)naviInfo.getUriResiource(), parent, this.em, naviInfo.getAssociationPath(), (VisitableExpression)expression, this.from, this.claimsProvider, this.groups));
                }
            } else {
                queryList.add(new JPANavigationFilterQuery(this.odata, this.sd, (UriResource)naviInfo.getUriResiource(), parent, this.em, naviInfo.getAssociationPath(), this.from, (Optional<JPAODataClaimProvider>)this.claimsProvider));
            }
            parent = (JPAAbstractQuery)queryList.get(queryList.size() - 1);
        }
        Subquery childQuery = null;
        for (int i = queryList.size() - 1; i >= 0; --i) {
            childQuery = ((JPANavigationQuery)queryList.get(i)).getSubQueryExists(childQuery);
        }
        return childQuery;
    }

    Expression determineExpression() {
        for (UriResource uriResource : this.member.getUriResourceParts()) {
            if (uriResource.getKind() == UriResourceKind.lambdaAny) {
                return ((UriResourceLambdaAny)uriResource).getExpression();
            }
            if (uriResource.getKind() != UriResourceKind.lambdaAll) continue;
            return ((UriResourceLambdaAll)uriResource).getExpression();
        }
        return null;
    }
}

