/*
 * Decompiled with CFR 0.152.
 */
package com.sap.olingo.jpa.processor.core.filter;

import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAAttribute;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAOperationResultParameter;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAParamaterFacet;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAParameter;
import com.sap.olingo.jpa.processor.core.exception.ODataJPAFilterException;
import com.sap.olingo.jpa.processor.core.filter.JPAPrimitiveTypeOperator;
import com.sap.olingo.jpa.processor.core.query.ExpressionUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.UUID;
import org.apache.olingo.commons.api.edm.EdmPrimitiveType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.api.http.HttpStatusCode;
import org.apache.olingo.server.api.OData;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.uri.queryoption.expression.Literal;

public class JPALiteralOperator
implements JPAPrimitiveTypeOperator {
    private final Literal literal;
    private final OData odata;
    private final String literalText;

    public JPALiteralOperator(OData odata, Literal literal) {
        this(odata, literal, literal.getText());
    }

    private JPALiteralOperator(OData odata, Literal literal, String literalText) {
        this.literal = literal;
        this.odata = odata;
        this.literalText = literalText;
    }

    @Override
    public Object get() throws ODataApplicationException {
        EdmPrimitiveType edmType = (EdmPrimitiveType)this.literal.getType();
        try {
            Class defaultType = edmType.getDefaultType();
            if (defaultType.isInstance(UUID.class)) {
                return UUID.fromString(this.literal.toString());
            }
            Constructor c = defaultType.getConstructor(String.class);
            return c.newInstance(edmType.fromUriLiteral(this.literalText));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException | EdmPrimitiveTypeException e) {
            throw new ODataJPAFilterException(e, HttpStatusCode.INTERNAL_SERVER_ERROR);
        }
    }

    public Object get(JPAAttribute attribute) throws ODataApplicationException {
        return ExpressionUtil.convertValueOnAttribute(this.odata, attribute, this.literalText);
    }

    public Object get(JPAOperationResultParameter returnType) throws ODataApplicationException {
        return ExpressionUtil.convertValueOnFacet(this.odata, (JPAParamaterFacet)returnType, this.literalText);
    }

    public Object get(JPAParameter jpaParameter) throws ODataApplicationException {
        return ExpressionUtil.convertValueOnFacet(this.odata, (JPAParamaterFacet)jpaParameter, this.literalText);
    }

    @Override
    public boolean isNull() {
        return this.literal.getText().equals("null");
    }

    JPALiteralOperator clone(String prefix, String postfix) {
        return new JPALiteralOperator(this.odata, this.literal, "'" + prefix + this.literal.getText().replaceAll("'", "") + postfix + "'");
    }

    Literal getLiteral() {
        return this.literal;
    }

    @Override
    public String getName() {
        return this.literal.getText();
    }
}

