/*
 * Decompiled with CFR 0.152.
 */
package com.sap.olingo.jpa.processor.core.filter;

import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAAssociationPath;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAAttribute;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPACollectionAttribute;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPADescriptionAttribute;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAElement;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAEntityType;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAPath;
import com.sap.olingo.jpa.metadata.core.edm.mapper.exception.ODataJPAModelException;
import com.sap.olingo.jpa.processor.core.exception.ODataJPAFilterException;
import com.sap.olingo.jpa.processor.core.filter.JPAOperator;
import com.sap.olingo.jpa.processor.core.query.Util;
import java.util.List;
import java.util.Set;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Path;
import org.apache.olingo.commons.api.http.HttpStatusCode;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.uri.queryoption.expression.Member;

public class JPAMemberOperator
implements JPAOperator {
    private final Member member;
    private final JPAEntityType jpaEntityType;
    private final From<?, ?> root;
    private final JPAAssociationPath association;

    JPAMemberOperator(JPAEntityType jpaEntityType, From<?, ?> parent, Member member, JPAAssociationPath association, List<String> list) throws ODataApplicationException {
        this.member = member;
        this.jpaEntityType = jpaEntityType;
        this.root = parent;
        this.association = association;
        this.checkGroup(this.determineAttributePath(), list);
    }

    public JPAAttribute determineAttribute() throws ODataApplicationException {
        JPAPath path = this.determineAttributePath();
        return path == null ? null : path.getLeaf();
    }

    public Path<?> get() throws ODataApplicationException {
        JPAPath selectItemPath = this.determineAttributePath();
        return selectItemPath == null ? null : this.determineCriteriaPath(selectItemPath);
    }

    public Member getMember() {
        return this.member;
    }

    @Override
    public String getName() {
        return this.member.toString();
    }

    private JPAPath determineAttributePath() throws ODataApplicationException {
        String attributePath = Util.determineProptertyNavigationPath(this.member.getResourcePath().getUriResourceParts());
        JPAPath selectItemPath = null;
        try {
            selectItemPath = this.jpaEntityType.getPath(attributePath);
            if (selectItemPath == null && this.association != null) {
                selectItemPath = this.jpaEntityType.getPath((String)(attributePath.isEmpty() ? this.association.getAlias() : this.association.getAlias() + "/" + attributePath));
            }
        }
        catch (ODataJPAModelException e) {
            throw new ODataJPAFilterException(e, HttpStatusCode.INTERNAL_SERVER_ERROR);
        }
        return selectItemPath;
    }

    private Path<?> determineCriteriaPath(JPAPath selectItemPath) throws ODataJPAFilterException {
        Path p = this.root;
        for (JPAElement jpaPathElement : selectItemPath.getPath()) {
            if (jpaPathElement instanceof JPADescriptionAttribute) {
                p = this.determineDescriptionCriteraPath(selectItemPath, p, jpaPathElement);
                continue;
            }
            if (jpaPathElement instanceof JPACollectionAttribute) {
                if (((JPACollectionAttribute)jpaPathElement).isComplex()) continue;
                try {
                    p = p.get(((JPACollectionAttribute)jpaPathElement).getTargetAttribute().getInternalName());
                    continue;
                }
                catch (ODataJPAModelException e) {
                    throw new ODataJPAFilterException(e, HttpStatusCode.INTERNAL_SERVER_ERROR);
                }
            }
            p = p.get(jpaPathElement.getInternalName());
        }
        return p;
    }

    private Path<?> determineDescriptionCriteraPath(JPAPath selectItemPath, Path<?> p, JPAElement jpaPathElement) {
        Set allJoins = this.root.getJoins();
        for (Join join : allJoins) {
            if (join.getAlias() == null || !join.getAlias().equals(selectItemPath.getAlias())) continue;
            Set subJoins = join.getJoins();
            for (Object sub : subJoins) {
                if (((Join)sub).getAlias() == null || !((Join)sub).getAlias().equals(jpaPathElement.getExternalName())) continue;
                join = (Join)sub;
            }
            p = join.get(((JPADescriptionAttribute)jpaPathElement).getDescriptionAttribute().getInternalName());
            break;
        }
        return p;
    }

    private void checkGroup(JPAPath path, List<String> groups) throws ODataJPAFilterException {
        JPAAttribute st;
        JPAPath orgPath = path;
        if (this.association != null && this.association.getPath() != null && (st = (JPAAttribute)this.association.getPath().get(0)).isComplex()) {
            try {
                orgPath = st.getStructuredType().getPath(path.getLeaf().getExternalName());
            }
            catch (ODataJPAModelException oDataJPAModelException) {
                // empty catch block
            }
        }
        if (orgPath != null && !orgPath.isPartOfGroups(groups)) {
            throw new ODataJPAFilterException(ODataJPAFilterException.MessageKeys.NOT_ALLOWED_MEMBER, HttpStatusCode.FORBIDDEN, orgPath.getAlias());
        }
    }
}

