/*
 * Decompiled with CFR 0.152.
 */
package com.sap.olingo.jpa.processor.core.filter;

import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAEntityType;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAPath;
import com.sap.olingo.jpa.metadata.core.edm.mapper.exception.ODataJPAModelException;
import com.sap.olingo.jpa.processor.core.exception.ODataJPAFilterException;
import com.sap.olingo.jpa.processor.core.query.Util;
import java.util.ArrayList;
import java.util.List;
import org.apache.olingo.commons.api.edm.EdmEnumType;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.commons.api.http.HttpStatusCode;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.uri.UriResource;
import org.apache.olingo.server.api.uri.UriResourceKind;
import org.apache.olingo.server.api.uri.queryoption.expression.BinaryOperatorKind;
import org.apache.olingo.server.api.uri.queryoption.expression.Expression;
import org.apache.olingo.server.api.uri.queryoption.expression.ExpressionVisitException;
import org.apache.olingo.server.api.uri.queryoption.expression.ExpressionVisitor;
import org.apache.olingo.server.api.uri.queryoption.expression.Literal;
import org.apache.olingo.server.api.uri.queryoption.expression.Member;
import org.apache.olingo.server.api.uri.queryoption.expression.MethodKind;
import org.apache.olingo.server.api.uri.queryoption.expression.UnaryOperatorKind;

final class JPAMemberVisitor
implements ExpressionVisitor<JPAPath> {
    private final ArrayList<JPAPath> pathList = new ArrayList();
    private final JPAEntityType jpaEntityType;

    public JPAMemberVisitor(JPAEntityType jpaEntityType) {
        this.jpaEntityType = jpaEntityType;
    }

    public List<JPAPath> get() {
        return this.pathList;
    }

    public JPAPath visitBinaryOperator(BinaryOperatorKind operator, JPAPath left, JPAPath right) throws ExpressionVisitException, ODataApplicationException {
        return null;
    }

    public JPAPath visitBinaryOperator(BinaryOperatorKind operator, JPAPath left, List<JPAPath> right) throws ExpressionVisitException, ODataApplicationException {
        return null;
    }

    public JPAPath visitUnaryOperator(UnaryOperatorKind operator, JPAPath operand) throws ExpressionVisitException, ODataApplicationException {
        return null;
    }

    public JPAPath visitMethodCall(MethodKind methodCall, List<JPAPath> parameters) throws ExpressionVisitException, ODataApplicationException {
        return null;
    }

    public JPAPath visitLambdaExpression(String lambdaFunction, String lambdaVariable, Expression expression) throws ExpressionVisitException, ODataApplicationException {
        return null;
    }

    public JPAPath visitLiteral(Literal literal) throws ExpressionVisitException, ODataApplicationException {
        return null;
    }

    public JPAPath visitMember(Member member) throws ExpressionVisitException, ODataApplicationException {
        UriResourceKind uriResourceKind = ((UriResource)member.getResourcePath().getUriResourceParts().get(0)).getKind();
        if (!(uriResourceKind != UriResourceKind.primitiveProperty && uriResourceKind != UriResourceKind.complexProperty || Util.hasNavigation(member.getResourcePath().getUriResourceParts()))) {
            String path = Util.determineProptertyNavigationPath(member.getResourcePath().getUriResourceParts());
            JPAPath selectItemPath = null;
            try {
                selectItemPath = this.jpaEntityType.getPath(path);
            }
            catch (ODataJPAModelException e) {
                throw new ODataJPAFilterException(e, HttpStatusCode.INTERNAL_SERVER_ERROR);
            }
            if (selectItemPath != null) {
                this.pathList.add(selectItemPath);
                return selectItemPath;
            }
        }
        return null;
    }

    public JPAPath visitAlias(String aliasName) throws ExpressionVisitException, ODataApplicationException {
        return null;
    }

    public JPAPath visitTypeLiteral(EdmType type) throws ExpressionVisitException, ODataApplicationException {
        return null;
    }

    public JPAPath visitLambdaReference(String variableName) throws ExpressionVisitException, ODataApplicationException {
        return null;
    }

    public JPAPath visitEnum(EdmEnumType type, List<String> enumValues) throws ExpressionVisitException, ODataApplicationException {
        return null;
    }
}

