/*
 * Decompiled with CFR 0.152.
 */
package com.sap.olingo.jpa.processor.core.filter;

import com.sap.olingo.jpa.processor.core.filter.JPALiteralOperator;
import com.sap.olingo.jpa.processor.core.filter.JPAMethodCall;
import com.sap.olingo.jpa.processor.core.filter.JPAOperationConverter;
import com.sap.olingo.jpa.processor.core.filter.JPAOperator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.persistence.criteria.Expression;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.uri.queryoption.expression.MethodKind;

class JPAMethodCallImp
implements JPAMethodCall {
    private final MethodKind methodCall;
    private final List<JPAOperator> parameters;
    private final JPAOperationConverter converter;

    public JPAMethodCallImp(JPAOperationConverter converter, MethodKind methodCall, List<JPAOperator> parameters) {
        this.methodCall = methodCall;
        this.parameters = parameters;
        this.converter = converter;
    }

    @Override
    public Object get() throws ODataApplicationException {
        return this.converter.convert(this);
    }

    @Override
    public Object get(String prefix, String suffix) throws ODataApplicationException {
        ArrayList<JPAOperator> paramCopy = new ArrayList<JPAOperator>(this.parameters);
        if (!this.parameters.isEmpty() && this.parameters.get(0) instanceof JPALiteralOperator) {
            this.parameters.add(((JPALiteralOperator)this.parameters.get(0)).clone(prefix, suffix));
            this.parameters.remove(0);
        }
        Expression<?> result = this.converter.convert(this);
        Collections.copy(this.parameters, paramCopy);
        return result;
    }

    @Override
    public MethodKind getFunction() {
        return this.methodCall;
    }

    @Override
    public JPAOperator getParameter(int index) {
        return this.parameters.get(index);
    }

    @Override
    public int noParameters() {
        return this.parameters.size();
    }

    @Override
    public String getName() {
        return this.methodCall.name();
    }
}

