/*
 * Decompiled with CFR 0.152.
 */
package com.sap.olingo.jpa.processor.core.filter;

import com.sap.olingo.jpa.processor.core.filter.JPALiteralOperator;
import com.sap.olingo.jpa.processor.core.filter.JPAVisitableExpression;
import java.util.ArrayList;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.uri.UriInfoResource;
import org.apache.olingo.server.api.uri.queryoption.expression.ExpressionVisitException;
import org.apache.olingo.server.api.uri.queryoption.expression.ExpressionVisitor;
import org.apache.olingo.server.api.uri.queryoption.expression.Literal;
import org.apache.olingo.server.api.uri.queryoption.expression.Member;
import org.apache.olingo.server.api.uri.queryoption.expression.MethodKind;

public final class JPAMethodExpression
implements JPAVisitableExpression {
    private final MethodKind methodCall;
    private final Member member;
    private final Literal literal;

    public JPAMethodExpression(Member member, JPALiteralOperator operand, MethodKind methodCall) {
        this.methodCall = methodCall;
        this.member = member;
        this.literal = operand != null ? operand.getLiteral() : null;
    }

    public <T> T accept(ExpressionVisitor<T> visitor) throws ExpressionVisitException, ODataApplicationException {
        ArrayList<Object> parameters = new ArrayList<Object>(2);
        parameters.add(visitor.visitMember(this.member));
        if (this.literal != null) {
            parameters.add(visitor.visitLiteral(this.literal));
        }
        return (T)visitor.visitMethodCall(this.methodCall, parameters);
    }

    @Override
    public UriInfoResource getMember() {
        return this.member.getResourcePath();
    }
}

