/*
 * Decompiled with CFR 0.152.
 */
package com.sap.olingo.jpa.processor.core.filter;

import com.sap.olingo.jpa.processor.core.api.JPAODataClaimProvider;
import com.sap.olingo.jpa.processor.core.filter.JPABinaryExpression;
import com.sap.olingo.jpa.processor.core.filter.JPAExistsOperation;
import com.sap.olingo.jpa.processor.core.filter.JPAExpressionOperator;
import com.sap.olingo.jpa.processor.core.filter.JPAFilterComplierAccess;
import com.sap.olingo.jpa.processor.core.filter.JPAFilterExpression;
import com.sap.olingo.jpa.processor.core.filter.JPALiteralOperator;
import com.sap.olingo.jpa.processor.core.filter.JPAMemberOperator;
import com.sap.olingo.jpa.processor.core.filter.JPAMethodExpression;
import com.sap.olingo.jpa.processor.core.filter.JPAOperator;
import com.sap.olingo.jpa.processor.core.query.JPAAbstractQuery;
import com.sap.olingo.jpa.processor.core.query.JPACollectionFilterQuery;
import com.sap.olingo.jpa.processor.core.query.JPANavigationFilterQuery;
import com.sap.olingo.jpa.processor.core.query.JPANavigationProptertyInfo;
import com.sap.olingo.jpa.processor.core.query.JPANavigationQuery;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Subquery;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.uri.UriInfoResource;
import org.apache.olingo.server.api.uri.UriResource;
import org.apache.olingo.server.api.uri.UriResourceKind;
import org.apache.olingo.server.api.uri.UriResourceProperty;
import org.apache.olingo.server.api.uri.queryoption.ApplyOption;
import org.apache.olingo.server.api.uri.queryoption.CountOption;
import org.apache.olingo.server.api.uri.queryoption.CustomQueryOption;
import org.apache.olingo.server.api.uri.queryoption.DeltaTokenOption;
import org.apache.olingo.server.api.uri.queryoption.ExpandOption;
import org.apache.olingo.server.api.uri.queryoption.FilterOption;
import org.apache.olingo.server.api.uri.queryoption.FormatOption;
import org.apache.olingo.server.api.uri.queryoption.IdOption;
import org.apache.olingo.server.api.uri.queryoption.OrderByOption;
import org.apache.olingo.server.api.uri.queryoption.SearchOption;
import org.apache.olingo.server.api.uri.queryoption.SelectOption;
import org.apache.olingo.server.api.uri.queryoption.SkipOption;
import org.apache.olingo.server.api.uri.queryoption.SkipTokenOption;
import org.apache.olingo.server.api.uri.queryoption.TopOption;
import org.apache.olingo.server.api.uri.queryoption.expression.BinaryOperatorKind;
import org.apache.olingo.server.api.uri.queryoption.expression.ExpressionVisitor;
import org.apache.olingo.server.api.uri.queryoption.expression.Member;
import org.apache.olingo.server.api.uri.queryoption.expression.MethodKind;
import org.apache.olingo.server.api.uri.queryoption.expression.VisitableExpression;

final class JPANavigationOperation
extends JPAExistsOperation
implements JPAExpressionOperator {
    final BinaryOperatorKind operator;
    final JPAMemberOperator jpaMember;
    final JPALiteralOperator operand;
    final MethodKind methodCall;

    public JPANavigationOperation(BinaryOperatorKind operator, JPANavigationOperation jpaNavigationOperation, JPALiteralOperator operand, JPAFilterComplierAccess jpaComplier) {
        super(jpaComplier);
        this.operator = operator;
        this.methodCall = jpaNavigationOperation.methodCall;
        this.jpaMember = jpaNavigationOperation.jpaMember;
        this.operand = operand;
    }

    JPANavigationOperation(JPAFilterComplierAccess jpaComplier, BinaryOperatorKind operator, JPAOperator left, JPAOperator right) {
        super(jpaComplier);
        this.operator = operator;
        this.methodCall = null;
        if (left instanceof JPAMemberOperator) {
            this.jpaMember = (JPAMemberOperator)left;
            this.operand = (JPALiteralOperator)right;
        } else {
            this.jpaMember = (JPAMemberOperator)right;
            this.operand = (JPALiteralOperator)left;
        }
    }

    public JPANavigationOperation(JPAFilterComplierAccess jpaComplier, MethodKind methodCall, List<JPAOperator> parameters) {
        super(jpaComplier);
        this.operator = null;
        this.methodCall = methodCall;
        if (parameters.get(0) instanceof JPAMemberOperator) {
            this.jpaMember = (JPAMemberOperator)parameters.get(0);
            this.operand = parameters.size() > 1 ? (JPALiteralOperator)parameters.get(1) : null;
        } else {
            this.jpaMember = (JPAMemberOperator)parameters.get(1);
            this.operand = (JPALiteralOperator)parameters.get(0);
        }
    }

    @Override
    public Expression<Boolean> get() throws ODataApplicationException {
        return this.converter.cb.exists(this.getExistsQuery());
    }

    public Enum<?> getOperator() {
        return null;
    }

    @Override
    public String getName() {
        return this.operator != null ? this.operator.name() : this.methodCall.name();
    }

    @Override
    Subquery<?> getExistsQuery() throws ODataApplicationException {
        ArrayList<UriResource> allUriResourceParts = new ArrayList<UriResource>(this.uriResourceParts);
        allUriResourceParts.addAll(this.jpaMember.getMember().getResourcePath().getUriResourceParts());
        List<JPANavigationProptertyInfo> naviPathList = this.determineAssoziations(this.sd, allUriResourceParts);
        JPAAbstractQuery parent = this.root;
        ArrayList<JPANavigationQuery> queryList = new ArrayList<JPANavigationQuery>();
        for (int i = naviPathList.size() - 1; i >= 0; --i) {
            JPANavigationProptertyInfo naviInfo = naviPathList.get(i);
            if (i == 0) {
                VisitableExpression expression = this.createExpression();
                if (naviInfo.getUriResiource() instanceof UriResourceProperty) {
                    queryList.add(new JPACollectionFilterQuery(this.odata, this.sd, this.em, parent, naviInfo.getAssociationPath(), expression, this.determineFrom(i, naviPathList.size(), parent), (List<String>)this.groups));
                } else {
                    queryList.add(new JPANavigationFilterQuery(this.odata, this.sd, (UriResource)naviInfo.getUriResiource(), parent, this.em, naviInfo.getAssociationPath(), expression, this.determineFrom(i, naviPathList.size(), parent), this.claimsProvider, this.groups));
                }
            } else {
                queryList.add(new JPANavigationFilterQuery(this.odata, this.sd, (UriResource)naviInfo.getUriResiource(), parent, this.em, naviInfo.getAssociationPath(), this.determineFrom(i, naviPathList.size(), parent), (Optional<JPAODataClaimProvider>)this.claimsProvider));
            }
            parent = (JPAAbstractQuery)queryList.get(queryList.size() - 1);
        }
        Subquery childQuery = null;
        for (int i = queryList.size() - 1; i >= 0; --i) {
            childQuery = ((JPANavigationQuery)queryList.get(i)).getSubQueryExists(childQuery);
        }
        return childQuery;
    }

    private VisitableExpression createExpression() {
        if (this.operator != null && this.methodCall == null) {
            return new JPAFilterExpression(new SubMember(this.jpaMember), this.operand.getLiteral(), this.operator);
        }
        if (this.operator == null && this.methodCall != null) {
            return new JPAMethodExpression(new SubMember(this.jpaMember), this.operand, this.methodCall);
        }
        JPAMethodExpression expression = new JPAMethodExpression(new SubMember(this.jpaMember), this.operand, this.methodCall);
        return new JPABinaryExpression(expression, this.operand.getLiteral(), this.operator);
    }

    private From<?, ?> determineFrom(int i, int size, JPAAbstractQuery parent) {
        return i == size - 1 ? this.from : parent.getRoot();
    }

    public String toString() {
        return "JPANavigationOperation [operator=" + this.operator + ", jpaMember=" + this.jpaMember + ", operand=" + this.operand + ", methodCall=" + this.methodCall + "]";
    }

    private class SubMember
    implements Member {
        private final JPAMemberOperator parentMember;

        public SubMember(JPAMemberOperator parentMember) {
            this.parentMember = parentMember;
        }

        public <T> T accept(ExpressionVisitor<T> visitor) throws ODataApplicationException {
            return null;
        }

        public UriInfoResource getResourcePath() {
            return new SubResource(this.parentMember);
        }

        public EdmType getStartTypeFilter() {
            return null;
        }

        public EdmType getType() {
            return null;
        }

        public boolean isCollection() {
            return false;
        }
    }

    private class SubResource
    implements UriInfoResource {
        private final JPAMemberOperator parentMember;

        public SubResource(JPAMemberOperator member) {
            this.parentMember = member;
        }

        public ApplyOption getApplyOption() {
            return null;
        }

        public CountOption getCountOption() {
            return null;
        }

        public List<CustomQueryOption> getCustomQueryOptions() {
            return new ArrayList<CustomQueryOption>(0);
        }

        public DeltaTokenOption getDeltaTokenOption() {
            return null;
        }

        public ExpandOption getExpandOption() {
            return null;
        }

        public FilterOption getFilterOption() {
            return null;
        }

        public FormatOption getFormatOption() {
            return null;
        }

        public IdOption getIdOption() {
            return null;
        }

        public OrderByOption getOrderByOption() {
            return null;
        }

        public SearchOption getSearchOption() {
            return null;
        }

        public SelectOption getSelectOption() {
            return null;
        }

        public SkipOption getSkipOption() {
            return null;
        }

        public SkipTokenOption getSkipTokenOption() {
            return null;
        }

        public TopOption getTopOption() {
            return null;
        }

        public List<UriResource> getUriResourceParts() {
            ArrayList<UriResource> result = new ArrayList<UriResource>();
            List source = this.parentMember.getMember().getResourcePath().getUriResourceParts();
            for (int i = source.size() - 1; !(i <= 0 || ((UriResource)source.get(i)).getKind() == UriResourceKind.navigationProperty || ((UriResource)source.get(i)).getKind() == UriResourceKind.entitySet || source.get(i) instanceof UriResourceProperty && ((UriResourceProperty)source.get(i)).isCollection()); --i) {
                result.add(0, (UriResource)source.get(i));
            }
            return result;
        }

        public String getValueForAlias(String alias) {
            return null;
        }
    }
}

