/*
 * Decompiled with CFR 0.152.
 */
package com.sap.olingo.jpa.processor.core.filter;

import com.sap.olingo.jpa.processor.core.database.JPAODataDatabaseOperations;
import com.sap.olingo.jpa.processor.core.filter.JPAAggregationOperationImp;
import com.sap.olingo.jpa.processor.core.filter.JPAArithmeticOperator;
import com.sap.olingo.jpa.processor.core.filter.JPAArithmeticOperatorImp;
import com.sap.olingo.jpa.processor.core.filter.JPABooleanOperatorImp;
import com.sap.olingo.jpa.processor.core.filter.JPAComparisonOperator;
import com.sap.olingo.jpa.processor.core.filter.JPAComparisonOperatorImp;
import com.sap.olingo.jpa.processor.core.filter.JPAFilterAggregationType;
import com.sap.olingo.jpa.processor.core.filter.JPALiteralOperator;
import com.sap.olingo.jpa.processor.core.filter.JPAMethodCall;
import com.sap.olingo.jpa.processor.core.filter.JPAOperator;
import com.sap.olingo.jpa.processor.core.filter.JPAPrimitiveTypeOperator;
import com.sap.olingo.jpa.processor.core.filter.JPAUnaryBooleanOperatorImp;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.uri.queryoption.expression.UnaryOperatorKind;

public class JPAOperationConverter {
    protected final CriteriaBuilder cb;
    private final JPAODataDatabaseOperations dbConverter;

    public JPAOperationConverter(CriteriaBuilder cb, JPAODataDatabaseOperations converterExtension) {
        this.cb = cb;
        this.dbConverter = converterExtension;
        this.dbConverter.setCriterialBuilder(cb);
    }

    public final Expression<Long> convert(JPAAggregationOperationImp jpaOperator) throws ODataApplicationException {
        if (jpaOperator.getAggregation() == JPAFilterAggregationType.COUNT) {
            return this.cb.count(jpaOperator.getPath());
        }
        return this.dbConverter.convert(jpaOperator);
    }

    public final <T extends Number> Expression<T> convert(JPAArithmeticOperator jpaOperator) throws ODataApplicationException {
        switch (jpaOperator.getOperator()) {
            case ADD: {
                if (jpaOperator.getRight() instanceof JPALiteralOperator) {
                    return this.cb.sum(jpaOperator.getLeft(this.cb), jpaOperator.getRightAsNumber(this.cb));
                }
                return this.cb.sum(jpaOperator.getLeft(this.cb), jpaOperator.getRightAsExpression());
            }
            case SUB: {
                if (jpaOperator.getRight() instanceof JPALiteralOperator) {
                    return this.cb.diff(jpaOperator.getLeft(this.cb), jpaOperator.getRightAsNumber(this.cb));
                }
                return this.cb.diff(jpaOperator.getLeft(this.cb), jpaOperator.getRightAsExpression());
            }
            case DIV: {
                if (jpaOperator.getRight() instanceof JPALiteralOperator) {
                    return this.cb.quot(jpaOperator.getLeft(this.cb), jpaOperator.getRightAsNumber(this.cb));
                }
                return this.cb.quot(jpaOperator.getLeft(this.cb), jpaOperator.getRightAsExpression());
            }
            case MUL: {
                if (jpaOperator.getRight() instanceof JPALiteralOperator) {
                    return this.cb.prod(jpaOperator.getLeft(this.cb), jpaOperator.getRightAsNumber(this.cb));
                }
                return this.cb.prod(jpaOperator.getLeft(this.cb), jpaOperator.getRightAsExpression());
            }
            case MOD: {
                if (jpaOperator.getRight() instanceof JPALiteralOperator) {
                    return this.cb.mod(jpaOperator.getLeftAsIntExpression(), new Integer(jpaOperator.getRightAsNumber(this.cb).toString()));
                }
                return this.cb.mod(jpaOperator.getLeftAsIntExpression(), jpaOperator.getRightAsIntExpression());
            }
        }
        return this.dbConverter.convert(jpaOperator);
    }

    public final Expression<Boolean> convert(JPABooleanOperatorImp jpaOperator) throws ODataApplicationException {
        switch (jpaOperator.getOperator()) {
            case AND: {
                return this.cb.and(jpaOperator.getLeft(), jpaOperator.getRight());
            }
            case OR: {
                return this.cb.or(jpaOperator.getLeft(), jpaOperator.getRight());
            }
        }
        return this.dbConverter.convert(jpaOperator);
    }

    public final Expression<Boolean> convert(JPAComparisonOperatorImp jpaOperator) throws ODataApplicationException {
        switch (jpaOperator.getOperator()) {
            case EQ: {
                return this.equalExpression((l, r) -> this.cb.equal(l, r), (l, r) -> this.cb.equal(l, r), l -> this.cb.isNull(l), jpaOperator);
            }
            case NE: {
                return this.equalExpression((l, r) -> this.cb.notEqual(l, r), (l, r) -> this.cb.notEqual(l, r), l -> this.cb.isNotNull(l), jpaOperator);
            }
            case GE: {
                return this.comparisonExpression((l, r) -> this.cb.greaterThanOrEqualTo(l, r), (l, r) -> this.cb.greaterThanOrEqualTo(l, r), jpaOperator);
            }
            case GT: {
                return this.comparisonExpression((l, r) -> this.cb.greaterThan(l, r), (l, r) -> this.cb.greaterThan(l, r), jpaOperator);
            }
            case LT: {
                return this.comparisonExpression((l, r) -> this.cb.lessThan(l, r), (l, r) -> this.cb.lessThan(l, r), jpaOperator);
            }
            case LE: {
                return this.comparisonExpression((l, r) -> this.cb.lessThanOrEqualTo(l, r), (l, r) -> this.cb.lessThanOrEqualTo(l, r), jpaOperator);
            }
        }
        return this.dbConverter.convert(jpaOperator);
    }

    public Expression<?> convert(JPAMethodCall jpaFunction) throws ODataApplicationException {
        switch (jpaFunction.getFunction()) {
            case LENGTH: {
                return this.cb.length((Expression)jpaFunction.getParameter(0).get());
            }
            case CONTAINS: {
                if (jpaFunction.getParameter(1) instanceof JPALiteralOperator) {
                    StringBuilder contains = new StringBuilder();
                    contains.append('%');
                    contains.append((String)((JPALiteralOperator)jpaFunction.getParameter(1)).get());
                    contains.append('%');
                    return this.cb.like((Expression)jpaFunction.getParameter(0).get(), contains.toString());
                }
                return this.cb.like((Expression)jpaFunction.getParameter(0).get(), (Expression)((JPAMethodCall)jpaFunction.getParameter(1)).get("%", "%"));
            }
            case ENDSWITH: {
                if (jpaFunction.getParameter(1) instanceof JPALiteralOperator) {
                    StringBuilder ends = new StringBuilder();
                    ends.append('%');
                    ends.append((String)((JPALiteralOperator)jpaFunction.getParameter(1)).get());
                    return this.cb.like((Expression)jpaFunction.getParameter(0).get(), ends.toString());
                }
                return this.cb.like((Expression)jpaFunction.getParameter(0).get(), (Expression)((JPAMethodCall)jpaFunction.getParameter(1)).get("%", ""));
            }
            case STARTSWITH: {
                if (jpaFunction.getParameter(1) instanceof JPALiteralOperator) {
                    StringBuilder starts = new StringBuilder();
                    starts.append((String)((JPALiteralOperator)jpaFunction.getParameter(1)).get());
                    starts.append('%');
                    return this.cb.like((Expression)jpaFunction.getParameter(0).get(), starts.toString());
                }
                return this.cb.like((Expression)jpaFunction.getParameter(0).get(), (Expression)((JPAMethodCall)jpaFunction.getParameter(1)).get("", "%"));
            }
            case INDEXOF: {
                String searchString = (String)((JPALiteralOperator)jpaFunction.getParameter(1)).get();
                return this.cb.locate((Expression)jpaFunction.getParameter(0).get(), searchString);
            }
            case SUBSTRING: {
                Expression<Integer> start = this.convertLiteralToExpression(jpaFunction, 1, 1);
                if (jpaFunction.noParameters() == 3) {
                    Expression<Integer> length = this.convertLiteralToExpression(jpaFunction, 2, 0);
                    return this.cb.substring((Expression)jpaFunction.getParameter(0).get(), start, length);
                }
                return this.cb.substring((Expression)jpaFunction.getParameter(0).get(), start);
            }
            case TOLOWER: {
                if (jpaFunction.getParameter(0).get() instanceof String) {
                    return this.cb.literal((Object)jpaFunction.getParameter(0).get().toString().toLowerCase());
                }
                return this.cb.lower((Expression)jpaFunction.getParameter(0).get());
            }
            case TOUPPER: {
                if (jpaFunction.getParameter(0).get() instanceof String) {
                    return this.cb.literal((Object)jpaFunction.getParameter(0).get().toString().toUpperCase());
                }
                return this.cb.upper((Expression)jpaFunction.getParameter(0).get());
            }
            case TRIM: {
                return this.cb.trim((Expression)jpaFunction.getParameter(0).get());
            }
            case CONCAT: {
                if (jpaFunction.getParameter(0).get() instanceof String) {
                    return this.cb.concat((String)jpaFunction.getParameter(0).get(), (Expression)jpaFunction.getParameter(1).get());
                }
                if (jpaFunction.getParameter(1).get() instanceof String) {
                    return this.cb.concat((Expression)jpaFunction.getParameter(0).get(), (String)jpaFunction.getParameter(1).get());
                }
                return this.cb.concat((Expression)jpaFunction.getParameter(0).get(), (Expression)jpaFunction.getParameter(1).get());
            }
            case NOW: {
                return this.cb.currentTimestamp();
            }
        }
        return this.dbConverter.convert(jpaFunction);
    }

    public final Expression<Boolean> convert(JPAUnaryBooleanOperatorImp jpaOperator) throws ODataApplicationException {
        if (jpaOperator.getOperator() == UnaryOperatorKind.NOT) {
            return this.cb.not(jpaOperator.getLeft());
        }
        return this.dbConverter.convert(jpaOperator);
    }

    private <Y extends Comparable<? super Y>> Expression<Boolean> comparisonExpression(BiFunction<Expression<? extends Y>, Expression<? extends Y>, Expression<Boolean>> allExpressionFunction, BiFunction<Expression<? extends Y>, Y, Expression<Boolean>> expressionObjectFunction, JPAComparisonOperator<? extends Y> jpaOperator) throws ODataApplicationException {
        if (jpaOperator.getRight() instanceof JPAPrimitiveTypeOperator) {
            return expressionObjectFunction.apply(jpaOperator.getLeft(), jpaOperator.getRightAsComparable());
        }
        return allExpressionFunction.apply(jpaOperator.getLeft(), jpaOperator.getRightAsExpression());
    }

    private Expression<Integer> convertLiteralToExpression(JPAMethodCall jpaFunction, int parameterIndex, int offset) throws ODataApplicationException {
        JPAOperator parameter = jpaFunction.getParameter(parameterIndex);
        if (parameter instanceof JPAArithmeticOperatorImp) {
            if (offset != 0) {
                return this.cb.sum((Expression)jpaFunction.getParameter(parameterIndex).get(), (Number)offset);
            }
            return (Expression)jpaFunction.getParameter(parameterIndex).get();
        }
        return this.cb.literal((Object)(new Integer(parameter.get().toString()) + offset));
    }

    private Expression<Boolean> equalExpression(BiFunction<Expression<?>, Expression<?>, Expression<Boolean>> allExpressionFunction, BiFunction<Expression<?>, Object, Expression<Boolean>> expressionObjectFunction, Function<Expression<?>, Expression<Boolean>> nullFunction, JPAComparisonOperator<?> jpaOperator) throws ODataApplicationException {
        if (jpaOperator.getRight() instanceof JPAPrimitiveTypeOperator) {
            if (((JPAPrimitiveTypeOperator)jpaOperator.getRight()).isNull()) {
                return nullFunction.apply(jpaOperator.getLeft());
            }
            return expressionObjectFunction.apply(jpaOperator.getLeft(), ((JPAOperator)jpaOperator.getRight()).get());
        }
        return allExpressionFunction.apply(jpaOperator.getLeft(), jpaOperator.getRightAsExpression());
    }
}

