/*
 * Decompiled with CFR 0.152.
 */
package com.sap.olingo.jpa.processor.core.filter;

import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPADataBaseFunction;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAEnumerationAttribute;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAServiceDocument;
import com.sap.olingo.jpa.metadata.core.edm.mapper.exception.ODataJPAModelException;
import com.sap.olingo.jpa.processor.core.api.JPAServiceDebugger;
import com.sap.olingo.jpa.processor.core.exception.ODataJPAFilterException;
import com.sap.olingo.jpa.processor.core.filter.JPAAggregationOperationImp;
import com.sap.olingo.jpa.processor.core.filter.JPAArithmeticOperatorImp;
import com.sap.olingo.jpa.processor.core.filter.JPABooleanOperatorImp;
import com.sap.olingo.jpa.processor.core.filter.JPAComparisonOperatorImp;
import com.sap.olingo.jpa.processor.core.filter.JPAEnumerationOperator;
import com.sap.olingo.jpa.processor.core.filter.JPAExpression;
import com.sap.olingo.jpa.processor.core.filter.JPAExpressionOperator;
import com.sap.olingo.jpa.processor.core.filter.JPAExpressionVisitor;
import com.sap.olingo.jpa.processor.core.filter.JPAFilterComplierAccess;
import com.sap.olingo.jpa.processor.core.filter.JPAFunctionOperator;
import com.sap.olingo.jpa.processor.core.filter.JPALambdaAllOperation;
import com.sap.olingo.jpa.processor.core.filter.JPALambdaAnyOperation;
import com.sap.olingo.jpa.processor.core.filter.JPALiteralOperator;
import com.sap.olingo.jpa.processor.core.filter.JPAMemberOperator;
import com.sap.olingo.jpa.processor.core.filter.JPAMethodBasedExpression;
import com.sap.olingo.jpa.processor.core.filter.JPAMethodCallImp;
import com.sap.olingo.jpa.processor.core.filter.JPANavigationOperation;
import com.sap.olingo.jpa.processor.core.filter.JPAOperator;
import com.sap.olingo.jpa.processor.core.filter.JPAUnaryBooleanOperatorImp;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Predicate;
import org.apache.olingo.commons.api.edm.EdmEnumType;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.commons.api.http.HttpStatusCode;
import org.apache.olingo.server.api.OData;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.uri.UriInfoResource;
import org.apache.olingo.server.api.uri.UriResource;
import org.apache.olingo.server.api.uri.UriResourceFunction;
import org.apache.olingo.server.api.uri.UriResourceKind;
import org.apache.olingo.server.api.uri.UriResourceNavigation;
import org.apache.olingo.server.api.uri.UriResourceProperty;
import org.apache.olingo.server.api.uri.queryoption.expression.BinaryOperatorKind;
import org.apache.olingo.server.api.uri.queryoption.expression.Expression;
import org.apache.olingo.server.api.uri.queryoption.expression.ExpressionVisitException;
import org.apache.olingo.server.api.uri.queryoption.expression.Literal;
import org.apache.olingo.server.api.uri.queryoption.expression.Member;
import org.apache.olingo.server.api.uri.queryoption.expression.MethodKind;
import org.apache.olingo.server.api.uri.queryoption.expression.UnaryOperatorKind;

class JPAVisitor
implements JPAExpressionVisitor {
    private final JPAFilterComplierAccess jpaComplier;
    private final JPAServiceDebugger debugger;

    JPAVisitor(JPAFilterComplierAccess jpaFilterCrossComplier) {
        this.jpaComplier = jpaFilterCrossComplier;
        this.debugger = this.jpaComplier.getDebugger();
    }

    @Override
    public OData getOdata() {
        return this.jpaComplier.getOdata();
    }

    @Override
    public From<?, ?> getRoot() {
        return this.jpaComplier.getRoot();
    }

    public JPAOperator visitAlias(String aliasName) throws ExpressionVisitException, ODataApplicationException {
        throw new ODataJPAFilterException(ODataJPAFilterException.MessageKeys.NOT_SUPPORTED_FILTER, HttpStatusCode.NOT_IMPLEMENTED, "Alias");
    }

    public JPAOperator visitBinaryOperator(BinaryOperatorKind operator, JPAOperator left, JPAOperator right) throws ExpressionVisitException, ODataApplicationException {
        int handle = this.debugger.startRuntimeMeasurement(this, "visitBinaryOperator");
        if (operator == BinaryOperatorKind.AND || operator == BinaryOperatorKind.OR) {
            this.debugger.stopRuntimeMeasurement(handle);
            return new JPABooleanOperatorImp(this.jpaComplier.getConverter(), operator, (JPAExpression)left, (JPAExpression)right);
        }
        if (left instanceof JPANavigationOperation || right instanceof JPANavigationOperation) {
            return this.handleBinaryWithNavigation(operator, left, right);
        }
        if (this.hasNavigation(left) || this.hasNavigation(right)) {
            return new JPANavigationOperation(this.jpaComplier, operator, left, right);
        }
        if (operator == BinaryOperatorKind.EQ || operator == BinaryOperatorKind.NE || operator == BinaryOperatorKind.GE || operator == BinaryOperatorKind.GT || operator == BinaryOperatorKind.LT || operator == BinaryOperatorKind.LE || operator == BinaryOperatorKind.HAS) {
            this.debugger.stopRuntimeMeasurement(handle);
            return new JPAComparisonOperatorImp(this.jpaComplier.getConverter(), operator, left, right);
        }
        if (operator == BinaryOperatorKind.ADD || operator == BinaryOperatorKind.SUB || operator == BinaryOperatorKind.MUL || operator == BinaryOperatorKind.DIV || operator == BinaryOperatorKind.MOD) {
            this.debugger.stopRuntimeMeasurement(handle);
            return new JPAArithmeticOperatorImp(this.jpaComplier.getConverter(), operator, left, right);
        }
        this.debugger.stopRuntimeMeasurement(handle);
        throw new ODataJPAFilterException(ODataJPAFilterException.MessageKeys.NOT_SUPPORTED_OPERATOR, HttpStatusCode.NOT_IMPLEMENTED, operator.name());
    }

    public JPAOperator visitBinaryOperator(BinaryOperatorKind operator, JPAOperator left, List<JPAOperator> right) throws ExpressionVisitException, ODataApplicationException {
        throw new ODataJPAFilterException(ODataJPAFilterException.MessageKeys.NOT_SUPPORTED_OPERATOR, HttpStatusCode.NOT_IMPLEMENTED, operator.name());
    }

    public JPAEnumerationOperator visitEnum(EdmEnumType type, List<String> enumValues) throws ExpressionVisitException, ODataApplicationException {
        int handle = this.debugger.startRuntimeMeasurement(this, "visitEnum");
        JPAEnumerationAttribute jpaEnumerationAttribute = this.jpaComplier.getSd().getEnumType(type);
        try {
            if (!jpaEnumerationAttribute.isFlags() && enumValues.size() > 1) {
                throw new ODataJPAFilterException(ODataJPAFilterException.MessageKeys.NOT_SUPPORTED_FILTER, HttpStatusCode.NOT_IMPLEMENTED, "Collection of Enumerations if not flags");
            }
        }
        catch (ODataJPAModelException e) {
            throw new ODataJPAFilterException(e, HttpStatusCode.INTERNAL_SERVER_ERROR);
        }
        this.debugger.stopRuntimeMeasurement(handle);
        return new JPAEnumerationOperator(this.jpaComplier.getSd().getEnumType(type), enumValues);
    }

    public JPAOperator visitLambdaExpression(String lambdaFunction, String lambdaVariable, Expression expression) throws ExpressionVisitException, ODataApplicationException {
        throw new ODataJPAFilterException(ODataJPAFilterException.MessageKeys.NOT_SUPPORTED_FILTER, HttpStatusCode.NOT_IMPLEMENTED, "Lambda Expression");
    }

    public JPAOperator visitLambdaReference(String variableName) throws ExpressionVisitException, ODataApplicationException {
        throw new ODataJPAFilterException(ODataJPAFilterException.MessageKeys.NOT_SUPPORTED_FILTER, HttpStatusCode.NOT_IMPLEMENTED, "Lambda Reference");
    }

    public JPAOperator visitLiteral(Literal literal) throws ExpressionVisitException, ODataApplicationException {
        int handle = this.debugger.startRuntimeMeasurement(this, "visitBinaryOperator");
        this.debugger.stopRuntimeMeasurement(handle);
        return new JPALiteralOperator(this.jpaComplier.getOdata(), literal);
    }

    public JPAOperator visitMember(Member member) throws ExpressionVisitException, ODataApplicationException {
        int handle = this.debugger.startRuntimeMeasurement(this, "visitMember");
        if (this.getLambdaType(member.getResourcePath()) == UriResourceKind.lambdaAny) {
            this.debugger.stopRuntimeMeasurement(handle);
            return new JPALambdaAnyOperation(this.jpaComplier, member);
        }
        if (this.getLambdaType(member.getResourcePath()) == UriResourceKind.lambdaAll) {
            this.debugger.stopRuntimeMeasurement(handle);
            return new JPALambdaAllOperation(this.jpaComplier, member);
        }
        if (this.isAggregation(member.getResourcePath())) {
            this.debugger.stopRuntimeMeasurement(handle);
            return new JPAAggregationOperationImp(this.jpaComplier.getRoot(), this.jpaComplier.getConverter());
        }
        if (this.isCustomFunction(member.getResourcePath())) {
            UriResource resource = (UriResource)member.getResourcePath().getUriResourceParts().get(0);
            JPADataBaseFunction jpaFunction = (JPADataBaseFunction)this.jpaComplier.getSd().getFunction(((UriResourceFunction)resource).getFunction());
            List odataParams = ((UriResourceFunction)resource).getParameters();
            this.debugger.stopRuntimeMeasurement(handle);
            return new JPAFunctionOperator(this, odataParams, jpaFunction);
        }
        this.debugger.stopRuntimeMeasurement(handle);
        return new JPAMemberOperator(this.jpaComplier.getJpaEntityType(), this.jpaComplier.getRoot(), member, this.jpaComplier.getAssoziation(), this.jpaComplier.getGroups());
    }

    public JPAOperator visitMethodCall(MethodKind methodCall, List<JPAOperator> parameters) throws ExpressionVisitException, ODataApplicationException {
        JPAMethodCallImp method;
        int handle = this.debugger.startRuntimeMeasurement(this, "visitMethodCall");
        if (!parameters.isEmpty()) {
            if (parameters.get(0) instanceof JPANavigationOperation || parameters.size() == 2 && parameters.get(1) instanceof JPANavigationOperation) {
                throw new ODataJPAFilterException(ODataJPAFilterException.MessageKeys.NOT_SUPPORTED_FILTER, HttpStatusCode.NOT_IMPLEMENTED, "Nested method calls together with navigation");
            }
            if (this.hasNavigation(parameters.get(0)) || parameters.size() == 2 && this.hasNavigation(parameters.get(1))) {
                return new JPANavigationOperation(this.jpaComplier, methodCall, parameters);
            }
        }
        if ((method = new JPAMethodCallImp(this.jpaComplier.getConverter(), methodCall, parameters)).get() instanceof Predicate) {
            method = new JPAMethodBasedExpression(this.jpaComplier.getConverter(), methodCall, parameters);
        }
        this.debugger.stopRuntimeMeasurement(handle);
        return method;
    }

    public JPAOperator visitTypeLiteral(EdmType type) throws ExpressionVisitException, ODataApplicationException {
        throw new ODataJPAFilterException(ODataJPAFilterException.MessageKeys.NOT_SUPPORTED_FILTER, HttpStatusCode.NOT_IMPLEMENTED, "Type Literal");
    }

    public JPAOperator visitUnaryOperator(UnaryOperatorKind operator, JPAOperator operand) throws ExpressionVisitException, ODataApplicationException {
        int handle = this.debugger.startRuntimeMeasurement(this, "visitBinaryOperator");
        if (operator == UnaryOperatorKind.NOT) {
            this.debugger.stopRuntimeMeasurement(handle);
            return new JPAUnaryBooleanOperatorImp(this.jpaComplier.getConverter(), operator, (JPAExpressionOperator)operand);
        }
        this.debugger.stopRuntimeMeasurement(handle);
        throw new ODataJPAFilterException(ODataJPAFilterException.MessageKeys.NOT_SUPPORTED_OPERATOR, HttpStatusCode.NOT_IMPLEMENTED, operator.name());
    }

    CriteriaBuilder getCriteriaBuilder() {
        return this.jpaComplier.getConverter().cb;
    }

    UriResourceKind getLambdaType(UriInfoResource member) {
        for (UriResource r : member.getUriResourceParts()) {
            if (r.getKind() != UriResourceKind.lambdaAny && r.getKind() != UriResourceKind.lambdaAll) continue;
            return r.getKind();
        }
        return null;
    }

    JPAServiceDocument getSd() {
        return this.jpaComplier.getSd();
    }

    boolean hasNavigation(JPAOperator operand) {
        if (operand instanceof JPAMemberOperator) {
            List uriResourceParts = ((JPAMemberOperator)operand).getMember().getResourcePath().getUriResourceParts();
            for (int i = uriResourceParts.size() - 1; i >= 0; --i) {
                if (!(uriResourceParts.get(i) instanceof UriResourceNavigation) && (!(uriResourceParts.get(i) instanceof UriResourceProperty) || !((UriResourceProperty)uriResourceParts.get(i)).isCollection())) continue;
                return true;
            }
        }
        return false;
    }

    private JPAOperator handleBinaryWithNavigation(BinaryOperatorKind operator, JPAOperator left, JPAOperator right) throws ODataJPAFilterException {
        if (left instanceof JPANavigationOperation && right instanceof JPANavigationOperation) {
            throw new ODataJPAFilterException(ODataJPAFilterException.MessageKeys.NOT_SUPPORTED_FILTER, HttpStatusCode.NOT_IMPLEMENTED, "Binary operations comparing two navigations");
        }
        if (left instanceof JPANavigationOperation) {
            return new JPANavigationOperation(operator, (JPANavigationOperation)left, (JPALiteralOperator)right, this.jpaComplier);
        }
        return new JPANavigationOperation(operator, (JPANavigationOperation)right, (JPALiteralOperator)left, this.jpaComplier);
    }

    private boolean isAggregation(UriInfoResource resourcePath) {
        return resourcePath.getUriResourceParts().size() == 1 && ((UriResource)resourcePath.getUriResourceParts().get(0)).getKind() == UriResourceKind.count;
    }

    private boolean isCustomFunction(UriInfoResource resourcePath) {
        return !resourcePath.getUriResourceParts().isEmpty() && resourcePath.getUriResourceParts().get(0) instanceof UriResourceFunction;
    }
}

