/*
 * Decompiled with CFR 0.152.
 */
package com.sap.olingo.jpa.processor.core.modify;

import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAAttribute;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAElement;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAEntityType;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAEnumerationAttribute;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAPath;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAServiceDocument;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAStructuredType;
import com.sap.olingo.jpa.metadata.core.edm.mapper.exception.ODataJPAModelException;
import com.sap.olingo.jpa.processor.core.exception.ODataJPAFilterException;
import com.sap.olingo.jpa.processor.core.exception.ODataJPAProcessException;
import com.sap.olingo.jpa.processor.core.exception.ODataJPAProcessorException;
import com.sap.olingo.jpa.processor.core.query.EdmEntitySetInfo;
import com.sap.olingo.jpa.processor.core.query.ExpressionUtil;
import com.sap.olingo.jpa.processor.core.query.Util;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.AttributeConverter;
import org.apache.olingo.commons.api.data.ComplexValue;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.data.Parameter;
import org.apache.olingo.commons.api.data.Property;
import org.apache.olingo.commons.api.data.ValueType;
import org.apache.olingo.commons.api.edm.EdmEntitySet;
import org.apache.olingo.commons.api.edm.EdmProperty;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.commons.api.http.HttpStatusCode;
import org.apache.olingo.server.api.OData;
import org.apache.olingo.server.api.ODataRequest;
import org.apache.olingo.server.api.deserializer.DeserializerException;
import org.apache.olingo.server.api.deserializer.ODataDeserializer;
import org.apache.olingo.server.api.serializer.SerializerException;
import org.apache.olingo.server.api.uri.UriParameter;
import org.apache.olingo.server.api.uri.UriResource;
import org.apache.olingo.server.api.uri.UriResourceProperty;

public class JPAConversionHelper {
    private final Map<Object, Map<String, Object>> getterBuffer = new HashMap<Object, Map<String, Object>>();

    public static Object convertParameter(Parameter param, JPAServiceDocument sd) throws ODataJPAModelException {
        switch (param.getValueType()) {
            case ENUM: {
                JPAEnumerationAttribute enumType = sd.getEnumType(param.getType());
                return enumType.enumOf((Number)param.getValue());
            }
        }
        return param.getValue();
    }

    public Map<String, Object> buildGetterMap(Object instance) throws ODataJPAProcessorException {
        if (instance != null) {
            ODataJPAProcessorException[] exception = new ODataJPAProcessorException[]{null};
            Map getterMap = this.getterBuffer.computeIfAbsent(instance, k -> {
                try {
                    return this.determineGetter(instance);
                }
                catch (ODataJPAProcessorException e) {
                    exception[0] = e;
                    return new HashMap(1);
                }
            });
            if (exception[0] == null) {
                return getterMap;
            }
            throw exception[0];
        }
        throw new ODataJPAProcessorException(ODataJPAProcessorException.MessageKeys.PARAMETER_NULL, HttpStatusCode.INTERNAL_SERVER_ERROR);
    }

    public Entity convertInputStream(OData odata, ODataRequest request, ContentType requestFormat, List<UriResource> uriResourceParts) throws ODataJPAProcessorException {
        InputStream requestInputStream = request.getBody();
        EdmEntitySetInfo targetEntityInfo = Util.determineModifyEntitySetAndKeys(uriResourceParts);
        try {
            ODataDeserializer deserializer = this.createDeserrializer(odata, requestFormat, request.getHeaders("OData-Version"));
            UriResource lastPart = uriResourceParts.get(uriResourceParts.size() - 1);
            if (lastPart instanceof UriResourceProperty) {
                int i;
                Entity requestEntity = new Entity();
                String startProperty = targetEntityInfo.getNavigationPath().split("/")[0];
                for (i = uriResourceParts.size() - 1; !(i <= 0 || uriResourceParts.get(i) instanceof UriResourceProperty && ((UriResourceProperty)uriResourceParts.get(i)).getProperty().getName().equals(startProperty)); --i) {
                }
                List properties = requestEntity.getProperties();
                for (int j = i; j < uriResourceParts.size() - 1 && uriResourceParts.get(i) instanceof UriResourceProperty; ++j) {
                    EdmProperty edmProperty = ((UriResourceProperty)uriResourceParts.get(i)).getProperty();
                    Property intermediateProperty = new Property();
                    intermediateProperty.setType(edmProperty.getType().getFullQualifiedName().getFullQualifiedNameAsString());
                    intermediateProperty.setName(edmProperty.getName());
                    intermediateProperty.setValue(ValueType.COMPLEX, (Object)new ComplexValue());
                    properties.add(intermediateProperty);
                    properties = ((ComplexValue)intermediateProperty.getValue()).getValue();
                }
                properties.add(deserializer.property(requestInputStream, ((UriResourceProperty)lastPart).getProperty()).getProperty());
                return requestEntity;
            }
            return deserializer.entity(requestInputStream, targetEntityInfo.getTargetEdmEntitySet().getEntityType()).getEntity();
        }
        catch (DeserializerException e) {
            throw new ODataJPAProcessorException(e, HttpStatusCode.BAD_REQUEST);
        }
    }

    public String convertKeyToLocal(OData odata, ODataRequest request, EdmEntitySet edmEntitySet, JPAEntityType et, Object newPOJO) throws SerializerException, ODataJPAProcessorException {
        if (newPOJO instanceof Map) {
            return this.convertKeyToLocalMap(odata, request, edmEntitySet, et, (Map)newPOJO);
        }
        return this.convertKeyToLocalEntity(odata, request, edmEntitySet, et, newPOJO);
    }

    public Map<String, Object> convertProperties(OData odata, JPAStructuredType st, List<Property> odataProperties) throws ODataJPAProcessException {
        HashMap<String, Object> jpaAttributes = new HashMap<String, Object>();
        String internalName = null;
        Map<String, Object> jpaAttribute = null;
        for (Property odataProperty : odataProperties) {
            JPAPath path;
            try {
                path = st.getPath(odataProperty.getName());
            }
            catch (ODataJPAModelException e) {
                throw new ODataJPAProcessorException(e, HttpStatusCode.INTERNAL_SERVER_ERROR);
            }
            switch (odataProperty.getValueType()) {
                case COMPLEX: {
                    internalName = ((JPAElement)path.getPath().get(0)).getInternalName();
                    try {
                        JPAStructuredType a = st.getAttribute(internalName).getStructuredType();
                        jpaAttribute = this.convertProperties(odata, a, ((ComplexValue)odataProperty.getValue()).getValue());
                        break;
                    }
                    catch (ODataJPAModelException e) {
                        throw new ODataJPAProcessorException(e, HttpStatusCode.INTERNAL_SERVER_ERROR);
                    }
                }
                case ENUM: 
                case PRIMITIVE: {
                    JPAAttribute attribute = path.getLeaf();
                    internalName = attribute.getInternalName();
                    jpaAttribute = this.processAttributeConverter(odataProperty.getValue(), attribute);
                    break;
                }
                case COLLECTION_PRIMITIVE: 
                case COLLECTION_ENUM: {
                    JPAAttribute attribute2 = path.getLeaf();
                    internalName = attribute2.getInternalName();
                    jpaAttribute = new ArrayList();
                    for (Object property : (List)odataProperty.getValue()) {
                        ((List)((Object)jpaAttribute)).add(this.processAttributeConverter(property, attribute2));
                    }
                    break;
                }
                case COLLECTION_COMPLEX: {
                    internalName = ((JPAElement)path.getPath().get(0)).getInternalName();
                    jpaAttribute = new ArrayList();
                    try {
                        JPAStructuredType a = st.getAttribute(internalName).getStructuredType();
                        for (ComplexValue property : (List)odataProperty.getValue()) {
                            ((List)((Object)jpaAttribute)).add(this.convertProperties(odata, a, property.getValue()));
                        }
                        break;
                    }
                    catch (ODataJPAModelException e) {
                        throw new ODataJPAProcessorException(e, HttpStatusCode.INTERNAL_SERVER_ERROR);
                    }
                }
                default: {
                    throw new ODataJPAProcessorException(ODataJPAProcessorException.MessageKeys.NOT_SUPPORTED_PROP_TYPE, HttpStatusCode.NOT_IMPLEMENTED, odataProperty.getValueType().name());
                }
            }
            jpaAttributes.put(internalName, jpaAttribute);
        }
        return jpaAttributes;
    }

    public Map<String, Object> convertUriKeys(OData odata, JPAStructuredType st, List<UriParameter> keyPredicates) throws ODataJPAFilterException, ODataJPAProcessorException {
        HashMap<String, Object> result = new HashMap<String, Object>(keyPredicates.size());
        for (UriParameter key : keyPredicates) {
            try {
                JPAAttribute attribute = st.getPath(key.getName()).getLeaf();
                String internalName = attribute.getInternalName();
                Object jpaAttribute = ExpressionUtil.convertValueOnAttribute(odata, attribute, key.getText(), true);
                result.put(internalName, jpaAttribute);
            }
            catch (ODataJPAModelException e) {
                throw new ODataJPAProcessorException(e, HttpStatusCode.INTERNAL_SERVER_ERROR);
            }
        }
        return result;
    }

    public Map<String, Object> determineGetter(Object instance) throws ODataJPAProcessorException {
        Method[] methods;
        HashMap<String, Object> getterMap = new HashMap<String, Object>();
        for (Method meth : methods = instance.getClass().getMethods()) {
            String methodName = meth.getName();
            if (!methodName.substring(0, 3).equals("get") || methodName.length() <= 3) continue;
            String attributeName = methodName.substring(3, 4).toLowerCase() + methodName.substring(4);
            try {
                Object value = meth.invoke(instance, new Object[0]);
                getterMap.put(attributeName, value);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new ODataJPAProcessorException(ODataJPAProcessorException.MessageKeys.ATTRIBUTE_RETRIVAL_FAILED, HttpStatusCode.INTERNAL_SERVER_ERROR, (Throwable)e, attributeName);
            }
        }
        return getterMap;
    }

    public <S, T> Object processAttributeConverter(Object value, JPAAttribute attribute) {
        Object jpaAttribute;
        if (attribute.getConverter() != null) {
            AttributeConverter converter = attribute.getConverter();
            jpaAttribute = converter.convertToEntityAttribute(value);
        } else {
            jpaAttribute = attribute.isEnum() ? this.findEnumConstantsByOrdinal(attribute.getType().getEnumConstants(), value) : value;
        }
        return jpaAttribute;
    }

    private void collectKeyProperties(Map<String, Object> newPOJO, List<JPAPath> keyPath, List<Property> properties) throws ODataJPAProcessorException, ODataJPAModelException {
        if (keyPath.size() > 1) {
            for (JPAPath key : keyPath) {
                Object keyElement = newPOJO.get(key.getLeaf().getInternalName());
                Property property = new Property(null, key.getLeaf().getExternalName());
                property.setValue(ValueType.PRIMITIVE, keyElement);
                properties.add(property);
            }
        } else {
            JPAPath key = keyPath.get(0);
            if (key.getLeaf().isComplex()) {
                Map embeddedId = (Map)newPOJO.get(key.getLeaf().getInternalName());
                this.collectKeyProperties(embeddedId, (List<JPAPath>)key.getLeaf().getStructuredType().getPathList(), properties);
            } else {
                Property property = new Property(null, key.getLeaf().getExternalName());
                property.setValue(ValueType.PRIMITIVE, newPOJO.get(key.getLeaf().getInternalName()));
                properties.add(property);
            }
        }
    }

    private void collectKeyProperties(Object newPOJO, List<JPAPath> keyPath, List<Property> properties) throws ODataJPAProcessorException, ODataJPAModelException {
        Map<String, Object> getter = this.buildGetterMap(newPOJO);
        if (keyPath.size() > 1) {
            for (JPAPath key : keyPath) {
                Property property = new Property(null, key.getLeaf().getExternalName());
                property.setValue(ValueType.PRIMITIVE, getter.get(key.getLeaf().getInternalName()));
                properties.add(property);
            }
        } else {
            JPAPath key = keyPath.get(0);
            if (key.getLeaf().isComplex()) {
                Object embeddedId = getter.get(key.getLeaf().getInternalName());
                this.collectKeyProperties(embeddedId, (List<JPAPath>)key.getLeaf().getStructuredType().getPathList(), properties);
            } else {
                Property property = new Property(null, key.getLeaf().getExternalName());
                property.setValue(ValueType.PRIMITIVE, getter.get(key.getLeaf().getInternalName()));
                properties.add(property);
            }
        }
    }

    private String convertKeyToLocalEntity(OData odata, ODataRequest request, EdmEntitySet edmEntitySet, JPAEntityType et, Object newPOJO) throws SerializerException, ODataJPAProcessorException {
        Entity createdEntity = new Entity();
        try {
            List keyPath = et.getKeyPath();
            List properties = createdEntity.getProperties();
            this.collectKeyProperties(newPOJO, (List<JPAPath>)keyPath, (List<Property>)properties);
        }
        catch (ODataJPAModelException e) {
            throw new ODataJPAProcessorException(e, HttpStatusCode.BAD_REQUEST);
        }
        return request.getRawBaseUri() + "/" + odata.createUriHelper().buildCanonicalURL(edmEntitySet, createdEntity);
    }

    private String convertKeyToLocalMap(OData odata, ODataRequest request, EdmEntitySet edmEntitySet, JPAEntityType et, Map<String, Object> newPOJO) throws SerializerException, ODataJPAProcessorException {
        Entity createdEntity = new Entity();
        try {
            List properties = createdEntity.getProperties();
            List keyPath = et.getKeyPath();
            this.collectKeyProperties(newPOJO, (List<JPAPath>)keyPath, (List<Property>)properties);
        }
        catch (ODataJPAModelException e) {
            throw new ODataJPAProcessorException(e, HttpStatusCode.BAD_REQUEST);
        }
        return request.getRawBaseUri() + "/" + odata.createUriHelper().buildCanonicalURL(edmEntitySet, createdEntity);
    }

    private ODataDeserializer createDeserrializer(OData odata, ContentType requestFormat, List<String> version) throws DeserializerException {
        return odata.createDeserializer(requestFormat, version);
    }

    private <T> Object findEnumConstantsByOrdinal(T[] enumConstants, Object value) {
        for (int i = 0; i < enumConstants.length; ++i) {
            if (((Enum)enumConstants[i]).ordinal() != ((Integer)value).intValue()) continue;
            return enumConstants[i];
        }
        return null;
    }
}

