/*
 * Decompiled with CFR 0.152.
 */
package com.sap.olingo.jpa.processor.core.modify;

import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAAssociationPath;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAAttribute;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPADescriptionAttribute;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAElement;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAEntityType;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAPath;
import com.sap.olingo.jpa.metadata.core.edm.mapper.exception.ODataJPAModelException;
import com.sap.olingo.jpa.processor.core.converter.JPAExpandResult;
import com.sap.olingo.jpa.processor.core.converter.JPATuple;
import com.sap.olingo.jpa.processor.core.converter.JPATupleChildConverter;
import com.sap.olingo.jpa.processor.core.exception.ODataJPAProcessorException;
import com.sap.olingo.jpa.processor.core.modify.JPAConversionHelper;
import com.sap.olingo.jpa.processor.core.query.ExpressionUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.olingo.server.api.ODataApplicationException;

abstract class JPACreateResult
implements JPAExpandResult {
    protected final JPAEntityType et;
    protected final Map<JPAAssociationPath, JPAExpandResult> children;
    protected final List<JPAPath> pathList;
    protected final Locale locale;
    protected final JPAConversionHelper helper;
    protected final Map<String, List<String>> requestHeaders;

    public JPACreateResult(JPAEntityType et, Map<String, List<String>> requestHeaders) throws ODataJPAModelException {
        this.et = et;
        this.helper = new JPAConversionHelper();
        this.children = new HashMap<JPAAssociationPath, JPAExpandResult>(0);
        this.pathList = et.getPathList();
        this.locale = ExpressionUtil.determineLocale(requestHeaders);
        this.requestHeaders = requestHeaders;
    }

    @Override
    public void convert(JPATupleChildConverter converter) throws ODataApplicationException {
    }

    @Override
    public JPAExpandResult getChild(JPAAssociationPath associationPath) {
        return this.children.get(associationPath);
    }

    @Override
    public Map<JPAAssociationPath, JPAExpandResult> getChildren() {
        return this.children;
    }

    @Override
    public Long getCount(String key) {
        return null;
    }

    @Override
    public JPAEntityType getEntityType() {
        return this.et;
    }

    @Override
    public boolean hasCount() {
        return false;
    }

    protected void addValueToTuple(JPATuple tuple, JPAPath path, int index, Object value) throws ODataJPAProcessorException {
        if (path.getPath().get(index) instanceof JPADescriptionAttribute) {
            Collection desc = (Collection)value;
            if (desc != null) {
                for (Object entry : desc) {
                    Map<String, Object> descGetterMap = this.entryAsMap(entry);
                    JPADescriptionAttribute jpaAttribute = (JPADescriptionAttribute)path.getPath().get(index);
                    String providedLocale = this.determineLocale(descGetterMap, jpaAttribute);
                    if (!this.locale.getLanguage().equals(providedLocale) && !this.locale.toString().equals(providedLocale)) continue;
                    Object desciption = descGetterMap.get(jpaAttribute.getDescriptionAttribute().getInternalName());
                    tuple.addElement(path.getAlias(), path.getLeaf().getType(), desciption);
                    break;
                }
            } else {
                tuple.addElement(path.getAlias(), path.getLeaf().getType(), null);
            }
        } else {
            tuple.addElement(path.getAlias(), path.getLeaf().getType(), value);
        }
    }

    protected void convertPathToTuple(JPATuple tuple, Map<String, Object> jpaEntity, JPAPath path, int index) throws ODataJPAProcessorException {
        Object value = jpaEntity.get(((JPAElement)path.getPath().get(index)).getInternalName());
        if (path.getPath().size() == index + 1 || value == null) {
            this.addValueToTuple(tuple, path, index, value);
        } else {
            Map<String, Object> embeddedGetterMap = this.entryAsMap(value);
            this.convertPathToTuple(tuple, embeddedGetterMap, path, index + 1);
        }
    }

    protected abstract String determineLocale(Map<String, Object> var1, JPAPath var2, int var3) throws ODataJPAProcessorException;

    protected abstract Map<String, Object> entryAsMap(Object var1) throws ODataJPAProcessorException;

    protected boolean notContainsCollection(JPAPath path) {
        for (JPAElement e : path.getPath()) {
            if (!(e instanceof JPAAttribute) || !((JPAAttribute)e).isCollection()) continue;
            return false;
        }
        return true;
    }

    private String determineLocale(Map<String, Object> descGetterMap, JPADescriptionAttribute descAttribute) throws ODataJPAProcessorException {
        return this.determineLocale(descGetterMap, descAttribute.getLocaleFieldName(), 0);
    }
}

