/*
 * Decompiled with CFR 0.152.
 */
package com.sap.olingo.jpa.processor.core.modify;

import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAAssociationPath;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPACollectionAttribute;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAEntityType;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAPath;
import com.sap.olingo.jpa.metadata.core.edm.mapper.exception.ODataJPAModelException;
import com.sap.olingo.jpa.processor.core.converter.JPACollectionResult;
import com.sap.olingo.jpa.processor.core.converter.JPATuple;
import com.sap.olingo.jpa.processor.core.converter.JPATupleChildConverter;
import com.sap.olingo.jpa.processor.core.exception.ODataJPAProcessorException;
import com.sap.olingo.jpa.processor.core.modify.JPAMapBaseResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.persistence.Tuple;
import org.apache.olingo.server.api.ODataApplicationException;

class JPAMapCollectionResult
extends JPAMapBaseResult
implements JPACollectionResult {
    private Map<String, List<Object>> converted;
    private final JPAAssociationPath path;

    public JPAMapCollectionResult(JPAEntityType et, Collection<?> values, Map<String, List<String>> requestHeaders, JPACollectionAttribute attribute) throws ODataJPAModelException, ODataJPAProcessorException {
        super(et, requestHeaders);
        this.path = attribute.asAssociation();
        this.result = this.convertToTuple(et, values, attribute);
    }

    private List<Tuple> convertToTuple(JPAEntityType et, Collection<?> values, JPACollectionAttribute attribute) throws ODataJPAProcessorException, ODataJPAModelException {
        ArrayList<Tuple> tupleList = new ArrayList<Tuple>();
        for (Object value : values) {
            JPATuple tuple = new JPATuple();
            if (attribute.isComplex()) {
                for (JPAPath p : attribute.getStructuredType().getPathList()) {
                    this.convertPathToTuple(tuple, (Map)value, et.getPath(this.path.getAlias() + "/" + p.getAlias()), 1);
                }
            } else {
                tuple.addElement(this.path.getAlias(), attribute.getType(), value);
            }
            tupleList.add(tuple);
        }
        return tupleList;
    }

    @Override
    public void convert(JPATupleChildConverter converter) throws ODataApplicationException {
        this.converted = converter.getCollectionResult(this, Collections.emptySet());
    }

    @Override
    public Collection<Object> getPropertyCollection(String key) {
        return this.converted.get("root");
    }

    @Override
    public JPAAssociationPath getAssoziation() {
        return this.path;
    }
}

