/*
 * Decompiled with CFR 0.152.
 */
package com.sap.olingo.jpa.processor.core.modify;

import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAAssociationPath;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAAttribute;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPACollectionAttribute;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAElement;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAEntityType;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAPath;
import com.sap.olingo.jpa.metadata.core.edm.mapper.exception.ODataJPAModelException;
import com.sap.olingo.jpa.processor.core.converter.JPATuple;
import com.sap.olingo.jpa.processor.core.converter.JPATupleChildConverter;
import com.sap.olingo.jpa.processor.core.exception.ODataJPAProcessorException;
import com.sap.olingo.jpa.processor.core.modify.JPAMapBaseResult;
import com.sap.olingo.jpa.processor.core.modify.JPAMapCollectionResult;
import com.sap.olingo.jpa.processor.core.modify.JPAMapNavigationLinkResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.persistence.Tuple;
import org.apache.olingo.server.api.ODataApplicationException;

final class JPAMapResult
extends JPAMapBaseResult {
    JPAMapResult(JPAEntityType et, Map<String, Object> jpaEntity, Map<String, List<String>> requestHeaders, JPATupleChildConverter converter) throws ODataJPAModelException, ODataApplicationException {
        super(et, requestHeaders);
        this.valuePairedResult = jpaEntity;
        this.result = this.createResult();
        this.createChildren(converter);
    }

    private void createChildren(JPATupleChildConverter converter) throws ODataJPAModelException, ODataApplicationException {
        for (JPAAssociationPath path : this.et.getAssociationPathList()) {
            String pathPropertyName = ((JPAElement)path.getPath().get(0)).getInternalName();
            if (!(this.valuePairedResult.get(pathPropertyName) instanceof List)) continue;
            this.children.put(path, new JPAMapNavigationLinkResult((JPAEntityType)path.getTargetType(), (List)this.valuePairedResult.get(pathPropertyName), this.requestHeaders, converter));
        }
        for (JPAAssociationPath path : this.et.getCollectionAttributesPath()) {
            Map attributes = this.valuePairedResult;
            for (JPAElement e : path.getPath()) {
                Object value = attributes.get(e.getInternalName());
                if (e instanceof JPAAttribute && ((JPAAttribute)e).isComplex() && !((JPAAttribute)e).isCollection() && value != null) {
                    attributes = (Map)value;
                    continue;
                }
                if (!(e instanceof JPACollectionAttribute) || value == null) continue;
                JPAAssociationPath assPath = ((JPACollectionAttribute)e).asAssociation();
                JPAMapCollectionResult child = new JPAMapCollectionResult(this.et, (Collection)value, this.requestHeaders, (JPACollectionAttribute)e);
                child.convert(converter);
                this.children.put(assPath, child);
            }
        }
    }

    private List<Tuple> createResult() throws ODataJPAProcessorException {
        JPATuple tuple = new JPATuple();
        ArrayList<Tuple> tupleResult = new ArrayList<Tuple>();
        for (JPAPath path : this.pathList) {
            if (!this.notContainsCollection(path)) continue;
            this.convertPathToTuple(tuple, this.valuePairedResult, path, 0);
        }
        tupleResult.add(tuple);
        return tupleResult;
    }
}

