/*
 * Decompiled with CFR 0.152.
 */
package com.sap.olingo.jpa.processor.core.processor;

import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAServiceDocument;
import com.sap.olingo.jpa.processor.core.api.JPAODataCRUDContextAccess;
import com.sap.olingo.jpa.processor.core.api.JPAODataRequestContextAccess;
import com.sap.olingo.jpa.processor.core.api.JPAServiceDebugger;
import com.sap.olingo.jpa.processor.core.serializer.JPASerializer;
import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import org.apache.olingo.commons.api.ex.ODataException;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.commons.api.http.HttpStatusCode;
import org.apache.olingo.server.api.OData;
import org.apache.olingo.server.api.ODataResponse;
import org.apache.olingo.server.api.serializer.SerializerResult;
import org.apache.olingo.server.api.uri.UriInfoResource;

abstract class JPAAbstractRequestProcessor {
    protected final EntityManager em;
    protected final JPAServiceDocument sd;
    protected final JPAODataCRUDContextAccess sessionContext;
    protected final CriteriaBuilder cb;
    protected final UriInfoResource uriInfo;
    protected final JPASerializer serializer;
    protected final OData odata;
    protected final JPAServiceDebugger debugger;
    protected int successStatusCode = HttpStatusCode.OK.getStatusCode();
    protected final JPAODataRequestContextAccess requestContext;

    public JPAAbstractRequestProcessor(OData odata, JPAODataCRUDContextAccess context, JPAODataRequestContextAccess requestContext) throws ODataException {
        this.em = requestContext.getEntityManager();
        this.cb = this.em.getCriteriaBuilder();
        this.sessionContext = context;
        this.sd = context.getEdmProvider().getServiceDocument();
        this.uriInfo = requestContext.getUriInfo();
        this.serializer = requestContext.getSerializer();
        this.odata = odata;
        this.debugger = requestContext.getDebugger();
        this.requestContext = requestContext;
    }

    protected final void createSuccessResponce(ODataResponse response, ContentType responseFormat, SerializerResult serializerResult) {
        response.setContent(serializerResult.getContent());
        response.setStatusCode(this.successStatusCode);
        response.setHeader("Content-Type", responseFormat.toContentTypeString());
    }
}

